---
generated_at: 2026-01-29 10:00:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：61-受信レコメンデーション

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **C-15**：mentionsテーブルの構造詳細が未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/core/core/server/api/endpoints/incoming-recommendations.js`（1-23行目）
- E-02: `ghost/core/core/server/services/recommendations/index.js`（1-3行目）
- E-03: `ghost/core/core/server/services/recommendations/recommendation-service-wrapper.js`（1-183行目）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（87行目）
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv`（62行目）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Webmentionプロトコルを利用してレコメンデーションを受信 | E-03（172-179行目） | ○ |
| C-02 | .well-known/recommendations.json形式のURLを判定 | E-03（156-159行目） | ○ |
| C-03 | DomainEventsからMentionCreatedEventを購読 | E-03（173行目） | ○ |
| C-04 | browse APIでlimitとpageオプションをサポート | E-01（10-14行目） | ○ |
| C-05 | recommendationsサービスのcontrollerに処理を委譲 | E-01（17-18行目） | ○ |
| C-06 | 設定で機能の有効/無効を切り替え可能 | E-03（42-46行目） | ○ |
| C-07 | IncomingRecommendationServiceでメール通知を送信 | E-03（127-143行目、177行目） | ○ |
| C-08 | recommendation-receivedアラートユーザーにのみ通知 | E-03（132-138行目） | ○ |
| C-09 | verified=trueの場合のみ処理対象 | E-03（175行目） | ○ |
| C-10 | 関連画面はレコメンデーション設定（No.54） | E-04 | ○ |
| C-11 | Admin API経由のアクセスには認証が必要 | E-01（15行目：permissions: true） | ○ |
| C-12 | RecommendationServiceWrapperがサービス初期化を担当 | E-02, E-03 | ○ |
| C-13 | メール送信失敗時は例外をログ出力して継続 | E-03（79-80行目相当の処理パターン） | ○ |
| C-14 | 機能一覧で定義された内容と一致 | E-05 | ○ |
| C-15 | mentionsテーブルでデータを管理 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- mentionsテーブルのスキーマ定義ファイルを直接確認できていない
  - 候補：`ghost/core/core/server/data/schema/schema.js` / `ghost/core/core/server/models/mention.js`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - API構造とイベント処理フローは十分な根拠がある
- 1: 中リスク - データベーステーブル構造の詳細確認が推奨

## 6) レビュアーチェックリスト（最小）
- [ ] mentionsテーブルのスキーマ定義を確認
- [ ] IncomingRecommendationServiceの実装詳細を外部ライブラリで確認
- [ ] メール通知テンプレートの内容確認
