---
generated_at: 2026-01-29 10:10:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：63-Slack通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（全項目根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/core/core/server/services/slack.js`（1-206行目）
- E-02: `ghost/core/core/server/services/slack-notifications/service.js`（1-61行目）
- E-03: `ghost/core/core/server/services/slack-notifications/slack-notifications-service.js`（1-91行目）
- E-04: `ghost/core/core/server/services/slack-notifications/slack-notifications.js`（1-212行目）
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv`（64行目）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | post.publishedイベントを監視 | E-01（193-195行目） | ○ |
| C-02 | slack_urlとslack_username設定を使用 | E-01（29-37行目） | ○ |
| C-03 | ページ（type=page）は通知しない | E-01（95-97行目） | ○ |
| C-04 | デフォルト投稿（welcome等）は除外 | E-01（19-27行目、103-105行目） | ○ |
| C-05 | インポート中は通知しない | E-01（176-178行目） | ○ |
| C-06 | slack_username未設定時は'Ghost'使用 | E-01（93行目） | ○ |
| C-07 | HTMLから最初の3文を抽出 | E-01（69-83行目） | ○ |
| C-08 | メンバー専用コンテンツは除外 | E-01（66-67行目） | ○ |
| C-09 | requestでHTTP POST送信 | E-01（158-170行目） | ○ |
| C-10 | エラー時はログ出力して処理継続 | E-01（163-169行目） | ○ |
| C-11 | MilestoneCreatedEventを購読 | E-03（86-88行目） | ○ |
| C-12 | minThreshold以下は通知しない | E-03（75行目） | ○ |
| C-13 | skipped/initialは通知しない | E-04（58-59行目） | ○ |
| C-14 | 通知メッセージにブロック形式を使用 | E-04（107-145行目） | ○ |
| C-15 | got.postでHTTP送信 | E-04（179行目） | ○ |
| C-16 | テスト環境ではretry=0 | E-04（175-177行目） | ○ |
| C-17 | User-Agentにバージョン情報を含める | E-04（171-173行目） | ○ |
| C-18 | URL検証にvalidator.isURLを使用 | E-04（158行目） | ○ |
| C-19 | slack.testイベントでテスト通知 | E-01（197-199行目、186-190行目） | ○ |
| C-20 | 機能一覧で定義された内容と一致 | E-05 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に対して十分な根拠が確認できた

## 6) レビュアーチェックリスト（最小）
- [ ] 2つのSlack通知システムの役割分担が明確か確認
- [ ] Webhook URLのセキュリティ管理方法の確認
- [ ] デフォルト投稿のスラッグリストが最新か確認
