---
generated_at: 2026-01-29 10:15:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：64-マイルストーン通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全項目根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/core/core/server/services/milestones/service.js`（1-119行目）
- E-02: `ghost/core/core/server/services/milestones/milestones-service.js`（1-328行目）
- E-03: `ghost/core/core/server/services/milestones/milestone.js`（1-232行目）
- E-04: `ghost/core/core/server/models/milestone.js`（1-10行目）
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv`（65行目）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | メンバー数とARRを定期チェック | E-01（62-75行目）、E-02（320-326行目） | ○ |
| C-02 | 初回実行時はメール送信しない | E-02（229-236行目、287-294行目） | ○ |
| C-03 | reason: initialで保存 | E-02（232-235行目、290-293行目） | ○ |
| C-04 | スキップ処理（reason: skipped） | E-02（237-244行目、295-302行目） | ○ |
| C-05 | メール間隔制限をチェック | E-02（176-181行目） | ○ |
| C-06 | minDaysSinceLastEmail設定を使用 | E-02（180行目） | ○ |
| C-07 | インポート検出でメール除外 | E-02（183-184行目） | ○ |
| C-08 | reason: importで保存 | E-02（186-188行目） | ○ |
| C-09 | Stripeライブキー必須 | E-01（8-23行目、65-69行目） | ○ |
| C-10 | サポート通貨のフィルタリング | E-02（203-208行目） | ○ |
| C-11 | 0-4日のランダム遅延 | E-01（6行目） | ○ |
| C-12 | 開発環境では5秒後実行 | E-01（84-86行目） | ○ |
| C-13 | MilestoneCreatedEvent発行 | E-03（133-135行目） | ○ |
| C-14 | ObjectIDでID生成 | E-03（1行目、91行目） | ○ |
| C-15 | checkMilestoneExistsで重複チェック | E-02（84-97行目） | ○ |
| C-16 | getMatchedMilestonesで達成判定 | E-02（120-124行目） | ○ |
| C-17 | Milestoneエンティティとモデルの分離 | E-03、E-04 | ○ |
| C-18 | 機能一覧で定義された内容と一致 | E-05 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に対して十分な根拠が確認できた

## 6) レビュアーチェックリスト（最小）
- [ ] milestonesConfigの設定値を確認
- [ ] minDaysSinceLastEmailとminDaysSinceImportedの設定値確認
- [ ] Stripeキー判定ロジックの動作確認
