---
generated_at: 2026-01-29 10:20:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：65-データベース管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（全項目根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/core/core/server/api/endpoints/db.js`（1-178行目）
- E-02: `ghost/core/core/server/data/db/backup.js`（1-72行目）
- E-03: `ghost/core/core/server/data/exporter/exporter.js`（1-71行目）
- E-04: `ghost/core/core/server/data/importer/import-manager.js`（1-619行目）
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv`（66行目）
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（95, 99, 112行目）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | backupContent APIが存在 | E-01（15-36行目） | ○ |
| C-02 | exportContent APIが存在 | E-01（39-77行目） | ○ |
| C-03 | importContent APIが存在 | E-01（79-109行目） | ○ |
| C-04 | deleteAllContent APIが存在 | E-01（130-174行目） | ○ |
| C-05 | 削除前に自動バックアップ | E-01（137行目） | ○ |
| C-06 | disableJSBackups設定でスキップ | E-02（49-52行目） | ○ |
| C-07 | インポートタグの自動付与 | E-01（93行目）、E-04（93-94行目） | ○ |
| C-08 | 設定ブロックリストの適用 | E-03（27-31行目） | ○ |
| C-09 | 非同期ジョブでインポート | E-04（507-515行目） | ○ |
| C-10 | pool(100)で並列削除 | E-01（158-160行目、164-166行目） | ○ |
| C-11 | トランザクション内で削除 | E-01（147行目） | ○ |
| C-12 | NotFoundErrorを返却 | E-01（64-66行目） | ○ |
| C-13 | ZIP解凍処理の存在 | E-04（220-252行目） | ○ |
| C-14 | ZIPエンコードエラー処理 | E-04（231-239行目） | ○ |
| C-15 | 完了メール送信 | E-04（543-549行目） | ○ |
| C-16 | columns: 'id'で高速化 | E-01（149行目） | ○ |
| C-17 | 関連画面（マイグレーションツール等） | E-06 | ○ |
| C-18 | 全操作に管理者権限必要 | E-01（permissions: true複数箇所） | ○ |
| C-19 | content/dataに保存 | E-02（17行目） | ○ |
| C-20 | 機能一覧で定義された内容と一致 | E-05 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に対して十分な根拠が確認できた

## 6) レビュアーチェックリスト（最小）
- [ ] BACKUP_TABLESの具体的な内容確認
- [ ] SETTING_KEYS_BLOCKLISTの内容確認
- [ ] インポートハンドラーの種類と対応形式確認
