---
generated_at: 2026-01-29 10:25:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：66-ジョブ管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **C-14**：@tryghost/job-managerの詳細API

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/core/core/server/services/jobs/job-service.js`（1-50行目）
- E-02: `ghost/core/core/server/services/jobs/index.js`（1-2行目）
- E-03: `ghost/core/core/server/services/update-check/index.js`（75-86行目）
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv`（67行目）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | @tryghost/job-managerをラップ | E-01（6行目） | ○ |
| C-02 | errorHandlerでSentry連携 | E-01（12-16行目） | ○ |
| C-03 | workerMessageHandlerでログ出力 | E-01（19-23行目） | ○ |
| C-04 | initTestModeで5秒ごとログ | E-01（25-44行目） | ○ |
| C-05 | JobModelを依存関係として注入 | E-01（46行目） | ○ |
| C-06 | domainEventsを依存関係として注入 | E-01（46行目） | ○ |
| C-07 | configを依存関係として注入 | E-01（46行目） | ○ |
| C-08 | eventsを依存関係として注入 | E-01（46行目） | ○ |
| C-09 | sentry.captureExceptionでエラー送信 | E-01（15行目） | ○ |
| C-10 | 更新チェックでaddJob使用例 | E-03（81-85行目） | ○ |
| C-11 | cron式でスケジュール登録 | E-03（82行目） | ○ |
| C-12 | job-service.jsをエクスポート | E-02（1行目） | ○ |
| C-13 | 機能一覧で定義された内容と一致 | E-04 | ○ |
| C-14 | inlineQueueとbreeの詳細動作 | **根拠なし（外部ライブラリ）** | △ |

## 4) 不足情報（Unknown / Missing）
- @tryghost/job-managerの内部実装詳細は外部ライブラリのため未確認
  - 候補：node_modules/@tryghost/job-manager

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要なラッパー処理は確認できた
- 1: 中リスク - 外部ライブラリの詳細動作は別途確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] @tryghost/job-managerのAPIドキュメント確認
- [ ] Breeのスケジューリング仕様確認
- [ ] jobsテーブルの使用状況確認
