---
generated_at: 2026-01-29 10:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：67-メール配信管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全項目根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/core/core/server/services/mail/ghost-mailer.js`（1-209行目）
- E-02: `ghost/core/core/server/services/mail/index.js`（1-16行目）
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv`（68行目）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（83行目）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | subject, html, toは必須 | E-01（125-130行目） | ○ |
| C-02 | from未指定時はdefaultFromEmail使用 | E-01（33-36行目） | ○ |
| C-03 | name未指定時はサイトタイトル使用 | E-01（42-45行目） | ○ |
| C-04 | base64エンコーディング設定 | E-01（63行目） | ○ |
| C-05 | Mailgun時にタグ付与 | E-01（133-137行目） | ○ |
| C-06 | ghost-email, transactional-emailタグ | E-01（20行目、199行目） | ○ |
| C-07 | email_track_opens設定に従う | E-01（138-140行目） | ○ |
| C-08 | blog-{siteId}タグ追加 | E-01（201-204行目） | ○ |
| C-09 | nodemailer経由で送信 | E-01（95行目、107行目） | ○ |
| C-10 | トランスポート選択（direct/mailgun） | E-01（97-98行目、103-106行目） | ○ |
| C-11 | directレスポンスのpendingチェック | E-01（183-187行目） | ○ |
| C-12 | directレスポンスのerrorsチェック | E-01（189-193行目） | ○ |
| C-13 | EmailError（400）でRecipientError | E-01（84行目） | ○ |
| C-14 | メトリクス記録（Mailgun時） | E-01（156-161行目、166-170行目） | ○ |
| C-15 | ドメイン抽出の正規表現 | E-01（23行目） | ○ |
| C-16 | GhostMailerエクスポート | E-02（12行目） | ○ |
| C-17 | 関連画面（Mailgun設定） | E-04 | ○ |
| C-18 | 機能一覧で定義された内容と一致 | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に対して十分な根拠が確認できた

## 6) レビュアーチェックリスト（最小）
- [ ] emailAddress.serviceの実装詳細確認
- [ ] @tryghost/nodemailerの設定オプション確認
- [ ] メールテンプレートの存在確認
