---
generated_at: 2026-01-29 10:35:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：68-更新チェック

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（全項目根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/core/core/server/services/update-check/index.js`（1-87行目）
- E-02: `ghost/core/core/server/services/update-check/update-check-service.js`（1-395行目）
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv`（69行目）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（16行目）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | development/production環境のみ実行 | E-01（29-34行目） | ○ |
| C-02 | next_update_check以降のみ実行 | E-02（381行目） | ○ |
| C-03 | isPrivacyDisabledでデータ送信制御 | E-02（176行目） | ○ |
| C-04 | notificationGroupsでフィルタリング | E-02（251行目、282-297行目） | ○ |
| C-05 | type=alertはメール送信 | E-02（343-358行目） | ○ |
| C-06 | Owner/Administratorにメール | E-02（324-326行目） | ○ |
| C-07 | 24時間後のタイムスタンプ設定 | E-02（63-66行目） | ○ |
| C-08 | blog_idはmd5ハッシュ | E-02（130行目） | ○ |
| C-09 | HTTPタイムアウト1000ms | E-02（169-171行目） | ○ |
| C-10 | POSTで全データ送信 | E-02（180-181行目） | ○ |
| C-11 | GETでバージョンのみ | E-02（183-186行目） | ○ |
| C-12 | db_hash取得 | E-02（116行目） | ○ |
| C-13 | active_theme取得 | E-02（117行目） | ○ |
| C-14 | post_count取得 | E-02（132行目） | ○ |
| C-15 | user_count取得 | E-02（133行目） | ○ |
| C-16 | 404で空通知配列 | E-02（195-199行目） | ○ |
| C-17 | エラー時next_update_check更新 | E-02（81-86行目） | ○ |
| C-18 | スケジュール登録（cron形式） | E-01（77-85行目） | ○ |
| C-19 | 関連画面（What's New） | E-04 | ○ |
| C-20 | 機能一覧で定義された内容と一致 | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に対して十分な根拠が確認できた

## 6) レビュアーチェックリスト（最小）
- [ ] Ghost.org Update Check APIのエンドポイントURL確認
- [ ] プライバシー設定のドキュメント確認
- [ ] 通知グループの設定方法確認
