---
generated_at: 2026-01-29 10:40:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：69-制限管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **C-14**：@tryghost/limit-serviceの詳細API

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/core/core/server/services/limits.js`（1-49行目）
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv`（70行目）
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（113行目）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | @tryghost/limit-serviceをインポート | E-01（5行目） | ○ |
| C-02 | LimitServiceインスタンス生成 | E-01（6行目） | ○ |
| C-03 | billing:urlがなければghost.org/help | E-01（11-15行目） | ○ |
| C-04 | subscription設定（interval='month'） | E-01（21-22行目） | ○ |
| C-05 | hostSettings:limitsから制限取得 | E-01（26行目） | ○ |
| C-06 | loadLimits呼び出し | E-01（29-35行目） | ○ |
| C-07 | dbを依存関係として注入 | E-01（32行目） | ○ |
| C-08 | errorsを依存関係として注入 | E-01（34行目） | ○ |
| C-09 | IncorrectUsageErrorは警告として処理 | E-01（38-39行目） | ○ |
| C-10 | 他のエラーは再スロー | E-01（41行目） | ○ |
| C-11 | limitServiceをエクスポート | E-01（46行目） | ○ |
| C-12 | init関数をエクスポート | E-01（48行目） | ○ |
| C-13 | 関連画面（Pro画面） | E-03 | ○ |
| C-14 | isLimitReached/errorIfIsOverLimit等のAPI | **根拠なし（外部ライブラリ）** | △ |

## 4) 不足情報（Unknown / Missing）
- @tryghost/limit-serviceの詳細APIは外部ライブラリのため未確認
  - 候補：node_modules/@tryghost/limit-service

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な初期化処理は確認できた
- 1: 中リスク - 外部ライブラリの詳細動作は別途確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] @tryghost/limit-serviceのAPIドキュメント確認
- [ ] hostSettings:limitsの設定項目確認
- [ ] 制限対象（members, users等）の完全なリスト確認
