---
generated_at: 2026-01-29 11:00:00
metrics:
  claims_total: 24
  claims_with_evidence: 24
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：7-メディアアップロード

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：24 / 24、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠あり。特に優先度の高いレビュー項目なし。

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ghost/core/core/server/api/endpoints/images.js`
- E-02: `ghost/core/core/server/api/endpoints/media.js`
- E-03: `ghost/core/core/server/api/endpoints/files.js`
- E-04: `ghost/core/core/server/web/api/middleware/upload.js`
- E-05: `ghost/core/core/server/adapters/storage/index.js`
- E-06: `ghost/core/core/server/adapters/storage/LocalStorageBase.js`
- E-07: `ghost/core/core/server/adapters/storage/LocalImagesStorage.js`
- E-08: `ghost/core/core/server/adapters/storage/LocalMediaStorage.js`
- E-09: `ghost/core/core/shared/config/overrides.json`
- E-10: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画像拡張子は.jpg, .jpeg, .gif, .png, .svg, .svgz, .ico, .webp | E-09 (26行目) | ○ |
| C-02 | メディア拡張子は.mp4, .webm, .ogv, .mp3, .wav, .ogg, .m4a | E-09 (30行目) | ○ |
| C-03 | ファイル拡張子は.pdf, .json, .jsonld, .odp等 | E-09 (46-59行目) | ○ |
| C-04 | 画像最大幅は2000px | E-09 (112行目) defaultMaxWidth: 2000 | ○ |
| C-05 | multerで一時ディレクトリに保存 | E-04 (59行目) multer({dest: os.tmpdir()}) | ○ |
| C-06 | checkFileIsValidでMIMEタイプと拡張子を検証 | E-04 (154-162行目) | ○ |
| C-07 | SVGはDOMPurifyでサニタイズ | E-04 (198-213行目) sanitizeSvgContent() | ○ |
| C-08 | レスポンス完了後に一時ファイル削除 | E-04 (84-100行目) deleteFiles() | ○ |
| C-09 | shouldResizeFileExtensionでリサイズ対象判定 | E-01 (28行目) | ○ |
| C-10 | imageTransform.resizeFromPathで画像リサイズ | E-01 (40行目) | ○ |
| C-11 | オリジナル画像を_o付きで保存 | E-01 (71-75行目) generateOriginalImageName() | ○ |
| C-12 | ファイル名から_oサフィックスを削除 | E-01 (25行目) replace(/_o(\.\w+?)$/, '$1') | ○ |
| C-13 | 画像アップロードは201ステータス | E-01 (13行目) statusCode: 201 | ○ |
| C-14 | メディアアップロードでサムネイルも保存可能 | E-02 (15-17行目) thumbnail保存処理 | ○ |
| C-15 | uploadThumbnailでサムネイル追加 | E-02 (28-49行目) | ○ |
| C-16 | filesアップロードでoriginalnameを使用 | E-03 (14行目) frame.file.originalname | ○ |
| C-17 | ストレージアダプターはadapter-managerで管理 | E-05 (14行目) adapterManager.getAdapter() | ○ |
| C-18 | LocalStorageBaseでgetUniqueFileNameを使用 | E-06 (60行目) | ○ |
| C-19 | ファイル保存時にfs.mkdirsでディレクトリ作成 | E-06 (63行目) | ○ |
| C-20 | ファイル保存時にfs.copyでコピー | E-06 (66行目) | ○ |
| C-21 | 静的ファイル配信のmaxAgeは1年 | E-06 (168行目) maxAge: 365 * 24 * 60 * 60 * 1000 | ○ |
| C-22 | 画像ストレージパスはcontent/images/ | E-07 (16行目) config.getContentPath('images') | ○ |
| C-23 | メディアストレージパスはcontent/media/ | E-08 (16行目) config.getContentPath('media') | ○ |
| C-24 | mediaValidationでサムネイル名を_thumb付きに設定 | E-04 (345行目) _thumb${req.thumbnail.ext} | ○ |

## 4) 不足情報（Unknown / Missing）
- すべての主張に対して根拠が確認できた。不足情報なし。

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: アップロード設定（設定ファイルから直接抽出）
- **0 (低リスク)**: バリデーション処理（コードから明確）
- **0 (低リスク)**: 画像最適化処理（コードから明確）
- **0 (低リスク)**: ストレージアダプター（コードから明確）

## 6) レビュアーチェックリスト（最小）
- [ ] 画像リサイズ処理が正しく動作するか確認
- [ ] SVGサニタイズが正しくXSSを防止するか確認
- [ ] 一時ファイルがレスポンス完了後に確実に削除されるか確認
- [ ] S3ストレージアダプター使用時も同様に動作するか確認
