---
generated_at: 2026-01-29 10:45:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：70-アダプター管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - なし（全項目根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/core/core/server/services/adapter-manager/index.js`（1-41行目）
- E-02: `ghost/core/core/server/services/adapter-manager/adapter-manager.js`（1-183行目）
- E-03: `ghost/core/core/server/services/adapter-manager/config.js`（1-30行目）
- E-04: `ghost/core/core/server/services/adapter-manager/options-resolver.js`（1-40行目）
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv`（71行目）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | AdapterManagerクラス存在 | E-02（29行目） | ○ |
| C-02 | pathsToAdapters設定 | E-01（8-12行目） | ○ |
| C-03 | storage登録（ghost-storage-base） | E-01（15行目） | ○ |
| C-04 | scheduling登録（scheduling-base） | E-01（16行目） | ○ |
| C-05 | sso登録（SSOBase） | E-01（17行目） | ○ |
| C-06 | cache登録（@tryghost/adapter-base-cache） | E-01（18行目） | ○ |
| C-07 | registerAdapterメソッド | E-02（67-70行目） | ○ |
| C-08 | getAdapterメソッド | E-02（90-181行目） | ○ |
| C-09 | clearInstanceCacheメソッド | E-02（75-79行目） | ○ |
| C-10 | キャッシュキー形式 | E-02（113行目） | ○ |
| C-11 | パス検索順序 | E-01（8-12行目）、E-02（120-146行目） | ○ |
| C-12 | ベースクラス検証 | E-02（156-162行目） | ○ |
| C-13 | requiredFns検証 | E-02（164-168行目） | ○ |
| C-14 | 必須メソッド検証 | E-02（170-176行目） | ○ |
| C-15 | resolveAdapterExport（ESM/CJS対応） | E-02（4-18行目） | ○ |
| C-16 | IncorrectUsageError（未指定） | E-02（92-95行目） | ○ |
| C-17 | NotFoundError（未登録タイプ） | E-02（107-109行目） | ○ |
| C-18 | IncorrectUsageError（見つからない） | E-02（149-151行目） | ○ |
| C-19 | IncorrectUsageError（依存関係不足） | E-02（139-143行目） | ○ |
| C-20 | resolveAdapterOptions | E-04（10-36行目） | ○ |
| C-21 | getAdapterServiceConfig | E-03（10-28行目） | ○ |
| C-22 | 機能一覧で定義された内容と一致 | E-05 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に対して十分な根拠が確認できた

## 6) レビュアーチェックリスト（最小）
- [ ] 各ベースクラス（ghost-storage-base等）のAPI確認
- [ ] content/adaptersディレクトリの構造確認
- [ ] 実際に使用されているアダプター実装の確認
