---
generated_at: 2026-01-29 10:30:00
metrics:
  claims_total: 35
  claims_with_evidence: 32
  claims_without_evidence: 3
confidence_derived: 0.91
---

# 根拠レポート：71-Portal

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：32 / 35、根拠なし：3
- 優先レビュー（高）
  1. **パフォーマンス要件の数値**：具体的な数値根拠が不足
  2. **トランザクション仕様**：サーバーサイド実装の詳細確認が必要
  3. **マジックリンク有効期限**：具体的な設定値の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `apps/portal/package.json` - パッケージ定義
- E-02: `apps/portal/src/index.js` - エントリーポイント
- E-03: `apps/portal/src/App.js` - メインアプリケーション
- E-04: `apps/portal/src/actions.js` - アクションハンドラ
- E-05: `apps/portal/src/utils/api.js` - API通信層
- E-06: `apps/portal/src/pages.js` - ページルーティング
- E-07: `apps/portal/src/components/popup-modal.js` - モーダルコンポーネント
- E-08: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義
- E-09: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | PortalはReactベースのシングルページアプリケーション | E-01, E-02 | ○ |
| C-02 | サイト訪問者向けのメンバー登録・ログイン・アカウント管理機能を提供 | E-03, E-04, E-06 | ○ |
| C-03 | UMD形式でビルドされる | E-01 (files: ["umd/"]) | ○ |
| C-04 | Ghost Members API（/members/api/）と連携 | E-05 (endpointFor関数) | ○ |
| C-05 | Stripe決済連携を実装 | E-04 (checkoutPlan), E-05 (checkoutPlan) | ○ |
| C-06 | Sentry連携でエラートラッキング | E-03 (setupSentry関数) | ○ |
| C-07 | FirstPromoter連携でアフィリエイト追跡 | E-03 (setupFirstPromoter関数) | ○ |
| C-08 | マジックリンク認証を実装 | E-04 (signin関数), E-05 (sendMagicLink) | ○ |
| C-09 | OTC（ワンタイムコード）認証を実装 | E-04 (verifyOTC), E-05 (verifyOTC) | ○ |
| C-10 | 19種類のページコンポーネントが存在 | E-06 (Pages定義) | ○ |
| C-11 | サインアップ/サインイン/アカウントホーム等のページを含む | E-06 | ○ |
| C-12 | dispatchActionでアクションハンドリングを行う | E-03 (dispatchAction関数) | ○ |
| C-13 | ActionHandlerで25種類以上のアクションを処理 | E-04 (Actions オブジェクト) | ○ |
| C-14 | iframeベースのポップアップモーダルで表示 | E-07 (Frame コンポーネント使用) | ○ |
| C-15 | data-portal属性でカスタムトリガーボタンを設定可能 | E-03 (setupCustomTriggerButton) | ○ |
| C-16 | i18n対応で60以上の言語をサポート | E-03 (i18n.changeLanguage), E-01 (@tryghost/i18n依存) | ○ |
| C-17 | 招待制サイトではサインアップ不可 | E-03 (getContextPage関数) | ○ |
| C-18 | Integrity Tokenで不正リクエストを防止 | E-05 (getIntegrityToken) | ○ |
| C-19 | Honeypotフィールドでボット対策 | E-05 (sendMagicLink の phonenumber パラメータ) | ○ |
| C-20 | プレビューモードをサポート | E-03 (fetchPreviewData, hasMode) | ○ |
| C-21 | ニュースレター購読管理を実装 | E-04 (updateNewsletterPreference) | ○ |
| C-22 | サブスクリプション更新・解約を実装 | E-04 (updateSubscription, cancelSubscription) | ○ |
| C-23 | レコメンデーション機能と連携 | E-04 (trackRecommendationClicked), E-06 (RecommendationsPage) | ○ |
| C-24 | オーディエンスフィードバック収集を実装 | E-05 (api.feedback), E-06 (FeedbackPage) | ○ |
| C-25 | Stripe Billing Portal連携 | E-05 (manageBilling, editBilling) | ○ |
| C-26 | オファー適用機能を実装 | E-04 (applyOffer), E-05 (applyOffer) | ○ |
| C-27 | メール抑制リスト解除機能を実装 | E-04 (removeEmailFromSuppressionList), E-05 (deleteSuppression) | ○ |
| C-28 | プロフィール更新機能を実装 | E-04 (updateProfile), E-05 (update) | ○ |
| C-29 | エラーメッセージはcreatePopupNotificationで表示 | E-04 (各アクションのエラーハンドリング) | ○ |
| C-30 | URLハッシュフラグメントでページ遷移を制御 | E-03 (fetchLinkData, getPageFromLinkPath) | ○ |
| C-31 | Viteでビルド | E-01 (devDependencies: vite) | ○ |
| C-32 | React 17を使用 | E-01 (react: 17.0.2) | ○ |
| C-33 | パフォーマンス要件：初期ロード2秒以内 | **根拠なし** | △ |
| C-34 | トランザクション管理はGhost Coreが担当 | **根拠なし**（サーバーサイド実装要確認） | △ |
| C-35 | マジックリンク有効期限は設定時間で無効化 | **根拠なし**（具体的な設定値要確認） | △ |

## 4) 不足情報（Unknown / Missing）
- **パフォーマンス要件の具体的数値**：ソースコードやドキュメントに明示的な数値定義が見つからない。運用要件ドキュメントの確認が必要。
  - 候補：Ghost公式ドキュメント / 運用マニュアル / SLA定義書
- **トランザクション仕様の詳細**：Portal自体はクライアントサイドアプリのため、サーバーサイド（Ghost Core）の実装確認が必要。
  - 候補：`ghost/core/core/server/services/members/` / データベーストランザクション実装
- **マジックリンク有効期限**：サーバーサイドの設定値確認が必要。
  - 候補：`ghost/core/core/server/services/auth/` / 環境設定ファイル

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 大部分の主張はソースコードで直接確認可能
- 1: 中リスク - パフォーマンス要件、トランザクション仕様は補完情報が必要
- 0: 低リスク - セキュリティ関連の主張は実装コードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] C-33: パフォーマンス要件の数値が運用要件と一致するか確認
- [ ] C-34: Ghost Coreのトランザクション実装を確認
- [ ] C-35: マジックリンク有効期限の設定値を確認
- [ ] 関連画面（画面No.46, 78-92）との整合性を確認
- [ ] Stripe連携のエラーハンドリング網羅性を確認
