---
generated_at: 2026-01-29 10:45:00
metrics:
  claims_total: 32
  claims_with_evidence: 30
  claims_without_evidence: 2
confidence_derived: 0.94
---

# 根拠レポート：72-Comments UI

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：30 / 32、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件の数値**：具体的な数値根拠が不足
  2. **トランザクション仕様**：サーバーサイド実装の詳細確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `apps/comments-ui/package.json` - パッケージ定義
- E-02: `apps/comments-ui/src/index.tsx` - エントリーポイント
- E-03: `apps/comments-ui/src/app.tsx` - メインアプリケーション
- E-04: `apps/comments-ui/src/actions.ts` - アクションハンドラ
- E-05: `apps/comments-ui/src/utils/api.ts` - API通信層
- E-06: `apps/comments-ui/src/components/content/comment.tsx` - コメントコンポーネント
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義
- E-08: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Comments UIはReact + TypeScriptで実装 | E-01, E-03 | ○ |
| C-02 | Tiptapエディタを使用したリッチテキスト入力 | E-01 (@tiptap依存) | ○ |
| C-03 | UMD形式でビルドされる | E-01 (unpkg: umd/comments-ui.umd.js) | ○ |
| C-04 | Ghost Members API（/members/api/comments/）と連携 | E-05 (endpointFor関数) | ○ |
| C-05 | 階層的な返信構造をサポート | E-04 (addReply, loadMoreReplies) | ○ |
| C-06 | いいね機能を実装 | E-04 (likeComment, unlikeComment) | ○ |
| C-07 | 管理者によるモデレーション機能 | E-04 (hideComment, showComment) | ○ |
| C-08 | IntersectionObserverで遅延初期化 | E-03 (338-370行目) | ○ |
| C-09 | 管理者はOwner/Administrator/Super Editorのみ | E-03 (ALLOWED_MODERATORS定数) | ○ |
| C-10 | ページネーション対応（1ページ20件） | E-05 (params.set('limit', '20')) | ○ |
| C-11 | 並び替えデフォルト順がいいね数降順 | E-03 (order: 'count__likes desc, created_at desc') | ○ |
| C-12 | コメントの削除は論理削除（status更新） | E-04 (deleteComment関数) | ○ |
| C-13 | 楽観的更新でいいね操作を即座に反映 | E-04 (updateCommentLikeState, likeComment) | ○ |
| C-14 | コメント報告機能を実装 | E-04 (reportComment), E-05 (report) | ○ |
| C-15 | コメント編集機能を実装 | E-04 (editComment), E-05 (edit) | ○ |
| C-16 | 削除済みコメントはプレースホルダー表示 | E-06 (useCommentVisibility, showDeletedMessage) | ○ |
| C-17 | 非表示コメントは管理者のみ閲覧可能 | E-06 (showHiddenMessage, showCommentContent) | ○ |
| C-18 | メンバーのみコメント投稿可能 | E-03 (isMember state), E-06 (isCommentingDisabled) | ○ |
| C-19 | 有料メンバー限定設定可能 | E-03 (isPaidOnly, hasRequiredTier計算) | ○ |
| C-20 | Tailwind CSSでスタイリング | E-01 (tailwindcss依存) | ○ |
| C-21 | React 17を使用 | E-01 (react: 17.0.2) | ○ |
| C-22 | Viteでビルド | E-01 (vite依存) | ○ |
| C-23 | 多言語対応は@tryghost/i18nの'comments'名前空間 | E-03 (i18nLib(options.locale, 'comments')) | ○ |
| C-24 | コメントパーマリンク機能（labs flag） | E-03 (shouldFindScrollTarget), E-06 (useLabs) | ○ |
| C-25 | 編集済みコメントには(edited)表示 | E-06 (EditedInfo コンポーネント) | ○ |
| C-26 | 返信の返信でin_reply_to_snippetを表示 | E-06 (RepliedToSnippet コンポーネント) | ○ |
| C-27 | @headlessui/reactを使用 | E-01 (@headlessui/react依存) | ○ |
| C-28 | Admin API経由でモデレーション実行 | E-03 (adminApi), E-04 (hideComment, showComment) | ○ |
| C-29 | same-origin credentialsでセッション認証 | E-05 (credentials: 'same-origin') | ○ |
| C-30 | Playwrightでe2eテスト実装 | E-01 (@playwright/test依存) | ○ |
| C-31 | パフォーマンス要件の具体的数値 | **根拠なし** | △ |
| C-32 | トランザクション管理はGhost Coreが担当 | **根拠なし**（サーバーサイド実装要確認） | △ |

## 4) 不足情報（Unknown / Missing）
- **パフォーマンス要件の具体的数値**：ソースコードやドキュメントに明示的な数値定義が見つからない。運用要件ドキュメントの確認が必要。
  - 候補：Ghost公式ドキュメント / 運用マニュアル / SLA定義書
- **トランザクション仕様の詳細**：Comments UI自体はクライアントサイドアプリのため、サーバーサイド（Ghost Core）の実装確認が必要。
  - 候補：`ghost/core/core/server/services/comments/` / データベーストランザクション実装

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 大部分の主張はソースコードで直接確認可能
- 1: 中リスク - パフォーマンス要件、トランザクション仕様は補完情報が必要
- 0: 低リスク - 機能実装に関する主張は実装コードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] C-31: パフォーマンス要件の数値が運用要件と一致するか確認
- [ ] C-32: Ghost Coreのコメント関連トランザクション実装を確認
- [ ] 関連画面（画面No.93-99）との整合性を確認
- [ ] Admin API連携のエラーハンドリング網羅性を確認
- [ ] Tiptapエディタのカスタマイズ内容を確認
