---
generated_at: 2026-01-29 11:00:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：73-Signup Form

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **トランザクション仕様**：サーバーサイド実装の詳細確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `apps/signup-form/package.json` - パッケージ定義
- E-02: `apps/signup-form/src/index.tsx` - エントリーポイント
- E-03: `apps/signup-form/src/app.tsx` - メインアプリケーション
- E-04: `apps/signup-form/src/utils/api.tsx` - API通信層
- E-05: `apps/signup-form/src/components/pages/form-page.tsx` - フォームページ
- E-06: `apps/signup-form/src/components/pages/form-view.tsx` - フォームUI
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義
- E-08: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Signup FormはReact + TypeScriptで実装 | E-01, E-03 | ○ |
| C-02 | UMD形式でビルドされる | E-01 (files: ["umd/"]) | ○ |
| C-03 | Ghost Members API（/members/api/）と連携 | E-04 (apiPath = 'members/api') | ○ |
| C-04 | マジックリンクメール送信機能 | E-04 (sendMagicLink関数) | ○ |
| C-05 | Integrity Tokenで不正リクエスト防止 | E-04 (getIntegrityToken関数) | ○ |
| C-06 | メールアドレスバリデーション | E-05 (isValidEmail関数呼び出し) | ○ |
| C-07 | ミニマルモードのサポート | E-05 (isMinimal), E-06 | ○ |
| C-08 | SuccessPageへのページ遷移 | E-05 (setPage('SuccessPage')) | ○ |
| C-09 | インライン成功表示（ミニマル時） | E-05 (setSuccess(true)) | ○ |
| C-10 | data-*属性でカスタマイズ可能 | E-03 (useOptions(scriptTag)) | ○ |
| C-11 | ラベル付与機能（data-labels） | E-04 (labels: options.labels) | ○ |
| C-12 | URL履歴追跡（urlHistory） | E-04 (getUrlHistory({siteUrl})) | ○ |
| C-13 | Tailwind CSSでスタイリング | E-01 (tailwindcss依存) | ○ |
| C-14 | React 18を使用 | E-01 (react: 18.3.1) | ○ |
| C-15 | Viteでビルド | E-01 (vite依存) | ○ |
| C-16 | Storybookでコンポーネント開発 | E-01 (@storybook/*依存) | ○ |
| C-17 | 多言語対応は@tryghost/i18nの'signup-form'名前空間 | E-03 (i18nLib(options.locale, 'signup-form')) | ○ |
| C-18 | カスタマイズ可能な背景色・テキスト色・ボタン色 | E-05, E-06 (backgroundColor, textColor, buttonColor) | ○ |
| C-19 | ローディング状態の管理 | E-05 (loading state), E-06 (LoadingIcon) | ○ |
| C-20 | エラーメッセージ表示機能 | E-05 (error state), E-06 (error表示) | ○ |
| C-21 | Playwrightでe2eテスト実装 | E-01 (@playwright/test依存) | ○ |
| C-22 | 認証不要でパブリックに利用可能 | E-04 (credentials不使用) | ○ |
| C-23 | アイコン・タイトル・説明文のカスタマイズ | E-05, E-06 (icon, title, description) | ○ |
| C-24 | 「Subscribe」ボタンのテキスト | E-06 (t('Subscribe')) | ○ |
| C-25 | トランザクション管理はGhost Coreが担当 | **根拠なし**（サーバーサイド実装要確認） | △ |

## 4) 不足情報（Unknown / Missing）
- **トランザクション仕様の詳細**：Signup Form自体はクライアントサイドアプリのため、サーバーサイド（Ghost Core）の実装確認が必要。
  - 候補：`ghost/core/core/server/services/members/` / マジックリンク認証処理

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 大部分の主張はソースコードで直接確認可能
- 0: 低リスク - シンプルな機能構成のため主張の検証が容易
- 1: 中リスク - トランザクション仕様は補完情報が必要

## 6) レビュアーチェックリスト（最小）
- [ ] C-25: Ghost Coreのマジックリンク認証トランザクション実装を確認
- [ ] 関連画面（画面No.101-102）との整合性を確認
- [ ] Integrity Token取得のエラーハンドリングを確認
- [ ] Storybookでのコンポーネントプレビューを確認
