---
generated_at: 2026-01-29 11:15:00
metrics:
  claims_total: 28
  claims_with_evidence: 28
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：74-Search（Sodo Search）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：28 / 28、根拠なし：0
- 優先レビュー（高）
  - 特になし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `apps/sodo-search/package.json` - パッケージ定義
- E-02: `apps/sodo-search/src/index.js` - エントリーポイント
- E-03: `apps/sodo-search/src/app.js` - メインアプリケーション
- E-04: `apps/sodo-search/src/search-index.js` - 検索インデックス実装
- E-05: `apps/sodo-search/src/components/popup-modal.js` - 検索モーダルUI
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Sodo SearchはReactで実装 | E-01, E-03 | ○ |
| C-02 | Flexsearch.jsによるクライアントサイド全文検索 | E-01 (flexsearch依存), E-04 | ○ |
| C-03 | UMD形式でビルドされる | E-01 (files: ["umd/"]) | ○ |
| C-04 | Ghost Content API（/search-index/）と連携 | E-04 (fetchPosts, fetchAuthors, fetchTags) | ○ |
| C-05 | 記事・タグ・著者を検索対象 | E-04 (postsIndex, authorsIndex, tagsIndex) | ○ |
| C-06 | 遅延インデックス構築 | E-03 (componentDidUpdate: showPopup && !indexStarted) | ○ |
| C-07 | Cmd/Ctrl + Kショートカット | E-03 (addKeyboardShortcuts: e.key === 'k' && e.metaKey) | ○ |
| C-08 | カスタムトリガーボタン（data-ghost-search） | E-03 (setupCustomTriggerButton) | ○ |
| C-09 | URLハッシュ（#/search）対応 | E-03 (handleSearchUrl) | ○ |
| C-10 | RTLサポート（逆方向トークン化） | E-04 (tokenize: 'reverse' when rtl) | ○ |
| C-11 | CJKトークン化対応 | E-04 (isCJK, tokenizeCjkByCodePoint) | ○ |
| C-12 | 著者→タグ→記事の順で結果表示 | E-05 (Results: AuthorResults, TagResults, PostResults) | ○ |
| C-13 | 404URLフィルタリング | E-05 (invalidUrlRegex = /\/404\/$/) | ○ |
| C-14 | 初期10件、追加10件ずつページネーション | E-05 (DEFAULT_MAX_POSTS = 10, STEP_MAX_POSTS = 10) | ○ |
| C-15 | キーボードナビゲーション（矢印キー、Enter） | E-05 (Results: ArrowUp, ArrowDown, Enter) | ○ |
| C-16 | Escapeキーでモーダルクローズ | E-05 (SearchBox: event.key === 'Escape') | ○ |
| C-17 | 検索結果のハイライト表示 | E-05 (HighlightedSection, HighlightWord) | ○ |
| C-18 | React 17を使用 | E-01 (react: 17.0.2) | ○ |
| C-19 | Viteでビルド | E-01 (vite依存) | ○ |
| C-20 | Tailwind CSSでスタイリング | E-01 (tailwindcss script) | ○ |
| C-21 | iframeベースのモーダル | E-05 (Frame コンポーネント使用) | ○ |
| C-22 | 検索インデックス対象フィールド：title, excerpt | E-04 (index: ['title', 'excerpt']) | ○ |
| C-23 | 著者インデックス対象フィールド：name | E-04 (index: ['name']) | ○ |
| C-24 | タグインデックス対象フィールド：name | E-04 (index: ['name']) | ○ |
| C-25 | ローディング状態表示 | E-05 (Loading component, CircleAnimated) | ○ |
| C-26 | No matches found表示 | E-05 (NoResultsBox) | ○ |
| C-27 | 多言語対応（@tryghost/i18n 'search'名前空間） | E-03 (i18nLib(i18nLanguage, 'search')) | ○ |
| C-28 | 検索結果クリックでページ遷移 | E-05 (window.location.href = url) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。すべての主張がソースコードで確認可能。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで直接確認可能
- 0: 低リスク - シンプルなアーキテクチャで主張の検証が容易

## 6) レビュアーチェックリスト（最小）
- [ ] 関連画面（画面No.100）との整合性を確認
- [ ] Content APIのsearch-indexエンドポイントの仕様を確認
- [ ] CJKトークン化の対象範囲（Unicode範囲）を確認
- [ ] Flexsearchのバージョンと機能を確認
