---
generated_at: 2026-01-29 11:30:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：75-Announcement Bar

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - 特になし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `apps/announcement-bar/package.json` - パッケージ定義
- E-02: `apps/announcement-bar/src/index.js` - エントリーポイント
- E-03: `apps/announcement-bar/src/app.js` - メインアプリケーション
- E-04: `apps/announcement-bar/src/components/main.js` - Mainコンポーネント
- E-05: `apps/announcement-bar/src/components/announcement-bar.js` - AnnouncementBarコンポーネント
- E-06: `apps/announcement-bar/src/components/preview.js` - Previewコンポーネント
- E-07: `apps/announcement-bar/src/utils/api.js` - APIクライアント
- E-08: `apps/announcement-bar/src/components/announcement-bar.css` - スタイル定義
- E-09: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義
- E-10: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Announcement BarはReact 17.0.2で実装 | E-01 (react: 17.0.2) | ○ |
| C-02 | UMD形式でビルドされる | E-01 (files: ["umd/"]) | ○ |
| C-03 | Viteでビルド | E-01 (vite: 5.4.20) | ○ |
| C-04 | scriptタグのdata-api-urlからAPIエンドポイント取得 | E-02 (scriptTag.dataset.apiUrl) | ○ |
| C-05 | プレビューモードサポート（data-preview属性） | E-02 (scriptTag.dataset.preview) | ○ |
| C-06 | ルートdivをbody先頭に挿入 | E-02 (document.body.prepend) | ○ |
| C-07 | ルートdivのID: announcement-bar-root | E-02 (ROOT_DIV_ID = 'announcement-bar-root') | ○ |
| C-08 | previewData存在時はPreviewコンポーネント表示 | E-03 (if previewData return Preview) | ○ |
| C-09 | previewData不在時はMainコンポーネント表示 | E-03 (return Main) | ○ |
| C-10 | useRefでAPIインスタンスを保持 | E-04 (useRef(setupGhostApi)) | ○ |
| C-11 | useEffectで初回のみAPI呼び出し | E-04 (useEffect, 依存配列空) | ○ |
| C-12 | sessionStorageで表示状態を管理 | E-05 (sessionStorage.setItem/getItem) | ○ |
| C-13 | isAnnouncementBarVisibleキーで表示状態保存 | E-05 (BAR_VISIBILITY_STORAGE_KEY) | ○ |
| C-14 | announcementBarContentキーでコンテンツ保存 | E-05 (BAR_CONTENT_STORAGE_KEY) | ○ |
| C-15 | コンテンツ変更時は自動再表示 | E-05 (isContentChanged → setBarVisibility(true)) | ○ |
| C-16 | 閉じるボタンでsessionStorage更新 | E-05 (handleButtonClick → setBarVisibility(false)) | ○ |
| C-17 | dangerouslySetInnerHTMLで告知コンテンツ表示 | E-05 (dangerouslySetInnerHTML={{__html: settings.announcement}}) | ○ |
| C-18 | 3種類の背景テーマ（light/accent/dark） | E-08 (.light/.accent/.dark クラス定義) | ○ |
| C-19 | light: 背景#f0f0f0、文字#15171a | E-08 (19-22行目) | ○ |
| C-20 | accent: 背景var(--ghost-accent-color)、文字#fff | E-08 (24-27行目) | ○ |
| C-21 | dark: 背景#15171a、文字#fff | E-08 (29-32行目) | ○ |
| C-22 | z-index: 90で前面表示 | E-08 (z-index: 90) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。すべての主張がソースコードで確認可能。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで直接確認可能
- 0: 低リスク - シンプルなアーキテクチャで主張の検証が容易
- 1: 要注意 - dangerouslySetInnerHTMLの使用（XSSリスク）

## 6) レビュアーチェックリスト（最小）
- [ ] 関連画面（画面No.103）との整合性を確認
- [ ] Ghost Coreの告知設定APIエンドポイント仕様を確認
- [ ] dangerouslySetInnerHTML使用時のサーバーサイドサニタイズ処理を確認
- [ ] sessionStorage使用のプライバシー影響を確認
