---
generated_at: 2026-01-29 11:45:00
metrics:
  claims_total: 35
  claims_with_evidence: 33
  claims_without_evidence: 2
confidence_derived: 0.94
---

# 根拠レポート：76-Ghost Admin

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：33 / 35、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件の数値**：具体的なSLA定義が不足
  2. **トランザクション仕様**：サーバーサイド実装の詳細確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/admin/package.json` - パッケージ定義
- E-02: `ghost/admin/app/app.js` - アプリケーションエントリー
- E-03: `ghost/admin/app/router.js` - ルーター定義
- E-04: `ghost/admin/app/authenticators/cookie.js` - Cookie認証
- E-05: `ghost/admin/app/services/session.js` - セッションサービス
- E-06: `ghost/admin/app/routes/authenticated.js` - 認証済みルートベース
- E-07: `ghost/admin/app/routes/posts.js` - 記事ルート
- E-08: `ghost/admin/app/controllers/posts.js` - 記事コントローラ
- E-09: `ghost/admin/app/components/admin-x/admin-x-component.js` - Admin-X統合
- E-10: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Ghost AdminはEmber.js 3.24で実装 | E-01 (ember-source: 3.24.0) | ○ |
| C-02 | Octane Editionを使用 | E-01 (ember.edition: octane) | ○ |
| C-03 | ember-simple-auth 5.0で認証 | E-01 (ember-simple-auth: 5.0.0) | ○ |
| C-04 | React 18をAdmin-Xで使用 | E-01 (react: 18.3.1) | ○ |
| C-05 | Ember Data 3.24でデータ管理 | E-01 (ember-data: 3.24.0) | ○ |
| C-06 | rootElementは#ember-app | E-02 (rootElement: '#ember-app') | ○ |
| C-07 | HTML5 History APIでルーティング | E-03 (location: config.locationType) | ○ |
| C-08 | adminRootは/ghost/ | E-03 (rootURL: ghostPaths().adminRoot) | ○ |
| C-09 | Cookie認証でPOST /session | E-04 (this.ajax.post(this.sessionEndpoint)) | ○ |
| C-10 | トークン検証でPUT /session/verify | E-04 (this.ajax.put(this.sessionVerifyEndpoint)) | ○ |
| C-11 | invalidateでDELETE /session | E-04 (this.ajax.del(this.sessionEndpoint)) | ○ |
| C-12 | populateUserでユーザー情報取得 | E-05 (this.dataStore.queryRecord('user', {id})) | ○ |
| C-13 | postAuthPreparationで設定取得 | E-05 (configManager.fetchAuthenticated, feature.fetch) | ○ |
| C-14 | Sentryでエラートラッキング | E-05 (configureScope from @sentry/ember) | ○ |
| C-15 | AuthenticatedRouteでsession.requireAuthentication | E-06 (this.session.requireAuthentication) | ○ |
| C-16 | 未認証はsigninへリダイレクト | E-06 (transition, 'signin') | ○ |
| C-17 | 記事一覧は30件/ページ | E-07 (perPage = 30) | ○ |
| C-18 | infinity.modelで無限スクロール | E-07 (this.infinity.model) | ○ |
| C-19 | Author/Contributorは自分の記事のみ | E-07 (user.isAuthor → filterParams.authors = user.slug) | ○ |
| C-20 | PostsWithAnalyticsで分析データ付加 | E-07 (PostsWithAnalytics extends InfinityModel) | ○ |
| C-21 | queryParamsでフィルタリング | E-07 (queryParams = {type, visibility, author, tag, order}) | ○ |
| C-22 | draftはupdated_at desc順 | E-07 (order: params.order || 'updated_at desc') | ○ |
| C-23 | publishedはpublished_at desc順 | E-07 (order: params.order || 'published_at desc') | ○ |
| C-24 | TYPESにdraft/published/scheduled/sent/featured | E-08 (TYPES配列定義) | ○ |
| C-25 | VISIBILITIESにpublic/members/[paid,tiers] | E-08 (VISIBILITIES配列定義) | ○ |
| C-26 | lexical-editor.editで記事編集 | E-08 (router.transitionTo('lexical-editor.edit')) | ○ |
| C-27 | Admin-Xは動的インポート | E-09 (importComponent async function) | ○ |
| C-28 | Suspenseでローディング状態管理 | E-09 (Suspense fallback={fallback}) | ○ |
| C-29 | ErrorHandlerでエラーバウンダリ | E-09 (ErrorHandler extends React.Component) | ○ |
| C-30 | externalNavigateでEmber遷移 | E-09 (this.router.transitionTo(route, ...models)) | ○ |
| C-31 | @tryghost/admin-x-settingsに依存 | E-01 (nx.targets.build.dependsOn) | ○ |
| C-32 | @tryghost/postsに依存 | E-01 (nx.targets.build.dependsOn) | ○ |
| C-33 | @tryghost/statsに依存 | E-01 (nx.targets.build.dependsOn) | ○ |
| C-34 | パフォーマンス要件の具体的SLA | **根拠なし** | △ |
| C-35 | トランザクション仕様詳細 | **根拠なし**（サーバーサイド実装要確認） | △ |

## 4) 不足情報（Unknown / Missing）
- **パフォーマンス要件のSLA定義**：ソースコードやドキュメントに明示的な数値定義が見つからない。
  - 候補：Ghost公式ドキュメント / 運用マニュアル
- **トランザクション仕様の詳細**：Ghost AdminはクライアントサイドSPAのため、サーバーサイド（Ghost Core）の実装確認が必要。
  - 候補：`ghost/core/core/server/api/` / データベーストランザクション実装

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 大部分の主張はソースコードで直接確認可能
- 1: 中リスク - 大規模コードベースのため網羅性に注意
- 1: 中リスク - Admin-XとEmberの統合部分は複雑

## 6) レビュアーチェックリスト（最小）
- [ ] C-34: パフォーマンス要件のSLAを運用要件と照合
- [ ] C-35: Ghost CoreのAPI層トランザクション実装を確認
- [ ] Admin-Xアプリ（settings, posts, stats）の統合テストを確認
- [ ] ember-simple-authのセキュリティ設定を確認
- [ ] Sentryのエラートラッキング設定を確認
- [ ] 各ユーザーロール（Owner/Admin/Editor/Author/Contributor）の権限テストを確認
