---
generated_at: 2026-01-29 12:00:00
metrics:
  claims_total: 30
  claims_with_evidence: 29
  claims_without_evidence: 1
confidence_derived: 0.97
---

# 根拠レポート：77-Admin Settings（React）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：29 / 30、根拠なし：1
- 優先レビュー（高）
  1. **API操作詳細**: Ghost Admin APIの詳細仕様確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `apps/admin-x-settings/package.json` - パッケージ定義
- E-02: `apps/admin-x-settings/src/index.tsx` - エントリーポイント
- E-03: `apps/admin-x-settings/src/app.tsx` - アプリルート
- E-04: `apps/admin-x-settings/src/components/settings.tsx` - 設定メインコンポーネント
- E-05: `apps/admin-x-settings/src/components/providers/settings-router.tsx` - ルーティング
- E-06: `apps/admin-x-settings/src/components/providers/settings-app-provider.tsx` - アプリコンテキスト
- E-07: `apps/admin-x-settings/src/components/settings/general/general-settings.tsx` - 一般設定
- E-08: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | React 18.3.1で実装 | E-01 (react: 18.3.1) | ○ |
| C-02 | Viteでビルド | E-01 (vite: 5.4.20) | ○ |
| C-03 | TypeScriptを使用 | E-01 (tsc && vite build) | ○ |
| C-04 | @tryghost/admin-x-frameworkに依存 | E-01 (devDependencies) | ○ |
| C-05 | @tryghost/admin-x-design-systemに依存 | E-01 (devDependencies) | ○ |
| C-06 | @tryghost/shadeに依存 | E-01 (devDependencies) | ○ |
| C-07 | @tryghost/i18nで多言語対応 | E-01 (dependencies) | ○ |
| C-08 | StandaloneAppとしてエクスポート | E-02 (export StandaloneApp as AdminXApp) | ○ |
| C-09 | FrameworkProviderでAPI接続 | E-03 (FrameworkProvider {...framework}) | ○ |
| C-10 | SettingsAppProviderでアプリコンテキスト提供 | E-03 (SettingsAppProvider) | ○ |
| C-11 | NiceModal.Providerでモーダル管理 | E-03 (NiceModal.Provider) | ○ |
| C-12 | RoutingProviderでbasePath='settings' | E-03 (RoutingProvider basePath='settings') | ○ |
| C-13 | DesignSystemAppでデザインシステム適用 | E-03 (DesignSystemApp className='admin-x-settings') | ○ |
| C-14 | 6つの設定セクション構成 | E-04 (General, Site, Membership, Email, Growth, Advanced) | ○ |
| C-15 | GeneralSettingsにTitleAndDescription含む | E-07 (TitleAndDescription keywords={...}) | ○ |
| C-16 | GeneralSettingsにTimeZone含む | E-07 (TimeZone keywords={...}) | ○ |
| C-17 | GeneralSettingsにUsers含む | E-07 (Users keywords={...}) | ○ |
| C-18 | searchKeywordsで検索キーワード定義 | E-07 (searchKeywords = {titleAndDescription: [...], ...}) | ○ |
| C-19 | modalPathsでモーダルルート定義 | E-05 (modalPaths: {[key: string]: ModalName}) | ○ |
| C-20 | 'design/change-theme'でDesignAndThemeModal | E-05 ('design/change-theme': 'DesignAndThemeModal') | ○ |
| C-21 | 'staff/invite'でInviteUserModal | E-05 ('staff/invite': 'InviteUserModal') | ○ |
| C-22 | 'portal/edit'でPortalModal | E-05 ('portal/edit': 'PortalModal') | ○ |
| C-23 | 'tiers/:id'でTierDetailModal | E-05 ('tiers/:id': 'TierDetailModal') | ○ |
| C-24 | loadModalsで動的インポート | E-05 (loadModals = () => import('./routing/modals')) | ○ |
| C-25 | officialThemesデータ提供 | E-06 (officialThemes import from data) | ○ |
| C-26 | zapierTemplatesデータ提供 | E-06 (zapierTemplates import from data) | ○ |
| C-27 | useSearchServiceで検索機能 | E-06 (search = useSearchService()) | ○ |
| C-28 | sortingStateでソート状態管理 | E-06 (useState<Sorting[]>) | ○ |
| C-29 | validator.jsで入力検証 | E-01 (validator: 13.12.0) | ○ |
| C-30 | Ghost Admin API詳細仕様 | **根拠なし**（APIドキュメント要確認） | △ |

## 4) 不足情報（Unknown / Missing）
- **Ghost Admin API詳細仕様**：admin-x-frameworkを通じてアクセスするAPIの詳細仕様。
  - 候補：Ghost公式APIドキュメント / `ghost/core/core/server/api/` ソースコード

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 大部分の主張はソースコードで直接確認可能
- 0: 低リスク - 明確なコンポーネント構造で検証が容易
- 1: 中リスク - 大規模コンポーネント群のため網羅性に注意

## 6) レビュアーチェックリスト（最小）
- [ ] C-30: Ghost Admin APIのエンドポイント仕様を確認
- [ ] 各設定セクション（General, Site, Membership, Email, Growth, Advanced）の完全性を確認
- [ ] モーダルパス定義とコンポーネントの対応を確認
- [ ] @tryghost/admin-x-frameworkのAPIフック使用方法を確認
- [ ] 検索機能のキーワードカバレッジを確認
