---
generated_at: 2026-01-29 12:15:00
metrics:
  claims_total: 32
  claims_with_evidence: 31
  claims_without_evidence: 1
confidence_derived: 0.97
---

# 根拠レポート：78-Posts Analytics

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：31 / 32、根拠なし：1
- 優先レビュー（高）
  1. **Tinybird API仕様**: Tinybird APIの詳細仕様確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `apps/posts/package.json` - パッケージ定義
- E-02: `apps/posts/src/index.tsx` - エントリーポイント
- E-03: `apps/posts/src/app.tsx` - アプリルート
- E-04: `apps/posts/src/routes.tsx` - ルーティング定義
- E-05: `apps/posts/src/providers/post-analytics-context.tsx` - 分析コンテキスト
- E-06: `apps/posts/src/views/PostAnalytics/post-analytics.tsx` - 分析メインコンポーネント
- E-07: `apps/posts/src/views/PostAnalytics/Overview/overview.tsx` - 概要タブ
- E-08: `apps/posts/src/views/PostAnalytics/Web/web.tsx` - Web分析タブ
- E-09: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | React 18.3.1で実装 | E-01 (react: 18.3.1) | ○ |
| C-02 | Viteでビルド | E-01 (vite: 5.4.20) | ○ |
| C-03 | TypeScriptを使用 | E-01 (tsc && vite build) | ○ |
| C-04 | @tryghost/admin-x-frameworkに依存 | E-01 (dependencies) | ○ |
| C-05 | @tryghost/shadeに依存 | E-01 (dependencies) | ○ |
| C-06 | @tanstack/react-queryでデータフェッチ | E-01 (devDependencies) | ○ |
| C-07 | @tanstack/react-virtualで仮想スクロール | E-01 (devDependencies) | ○ |
| C-08 | App as AdminXAppとしてエクスポート | E-02 (App as AdminXApp) | ○ |
| C-09 | FrameworkProviderでstaleTime: 0 | E-03 (staleTime: 0) | ○ |
| C-10 | FrameworkProviderでrefetchOnMount: true | E-03 (refetchOnMount: true) | ○ |
| C-11 | PostsAppContextProviderでアプリコンテキスト | E-03 (PostsAppContextProvider) | ○ |
| C-12 | RouterProviderでprefix='/' | E-03 (RouterProvider prefix={APP_ROUTE_PREFIX}) | ○ |
| C-13 | PostsErrorBoundaryでエラーハンドリング | E-03 (PostsErrorBoundary) | ○ |
| C-14 | ShadeAppでデザインシステム適用 | E-03 (ShadeApp className='shade-posts app-container') | ○ |
| C-15 | posts/analytics/:postIdルート | E-04 (path: 'posts/analytics/:postId') | ○ |
| C-16 | Overview/Web/Growth/Newsletterサブルート | E-04 (children: ['', 'web', 'growth', 'newsletter']) | ○ |
| C-17 | lazyComponentで遅延ロード | E-04 (lazy: lazyComponent) | ○ |
| C-18 | PostAnalyticsProviderで動的インポート | E-04 (lazy: async () => import) | ○ |
| C-19 | postId必須検証 | E-05 (if (!postId) throw Error) | ○ |
| C-20 | useBrowseConfigで設定取得 | E-05 (useBrowseConfig()) | ○ |
| C-21 | useBrowseSiteでサイト情報取得 | E-05 (useBrowseSite()) | ○ |
| C-22 | useTinybirdTokenでトークン取得 | E-05 (useTinybirdToken()) | ○ |
| C-23 | useBrowsePostsで記事データ取得 | E-05 (useBrowsePosts()) | ○ |
| C-24 | include: email,authors,tags,tiers,count.* | E-05 (include: 'email,authors,...') | ○ |
| C-25 | PostAnalyticsLayoutでレイアウト | E-06 (PostAnalyticsLayout) | ○ |
| C-26 | hasBeenEmailedでNewsletter表示判定 | E-07 (hasBeenEmailed(post)) | ○ |
| C-27 | getRangeForStartDateで範囲計算 | E-07 (getRangeForStartDate(post.published_at)) | ○ |
| C-28 | useTinybirdQuery('api_kpis') | E-07, E-08 (endpoint: 'api_kpis') | ○ |
| C-29 | useTinybirdQuery('api_top_sources') | E-07, E-08 (endpoint: 'api_top_sources') | ○ |
| C-30 | useTinybirdQuery('api_top_locations') | E-08 (endpoint: 'api_top_locations') | ○ |
| C-31 | email_only記事はWebタブにアクセス不可 | E-08 (if post?.email_only navigate) | ○ |
| C-32 | Tinybird API詳細仕様 | **根拠なし**（外部APIドキュメント要確認） | △ |

## 4) 不足情報（Unknown / Missing）
- **Tinybird API詳細仕様**：api_kpis, api_top_sources, api_top_locationsの詳細パラメータと応答フォーマット。
  - 候補：Tinybird公式ドキュメント / `ghost/core/core/server/data/tinybird/` ソースコード

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 大部分の主張はソースコードで直接確認可能
- 0: 低リスク - 明確なコンポーネント構造で検証が容易
- 1: 中リスク - 外部API（Tinybird）の仕様は追加確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] C-32: Tinybird APIのエンドポイント仕様を確認
- [ ] 各タブ（Overview, Web, Growth, Newsletter）の表示条件を確認
- [ ] フィルタパラメータのURL同期動作を確認
- [ ] エラーハンドリング（PostsErrorBoundary）の動作を確認
- [ ] 記事データのincludeパラメータの網羅性を確認
