---
generated_at: 2026-01-29 12:30:00
metrics:
  claims_total: 30
  claims_with_evidence: 29
  claims_without_evidence: 1
confidence_derived: 0.97
---

# 根拠レポート：79-Stats Dashboard

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：29 / 30、根拠なし：1
- 優先レビュー（高）
  1. **Tinybird API仕様**: Tinybird APIの詳細仕様確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `apps/stats/package.json` - パッケージ定義
- E-02: `apps/stats/src/index.tsx` - エントリーポイント
- E-03: `apps/stats/src/app.tsx` - アプリルート
- E-04: `apps/stats/src/routes.tsx` - ルーティング定義
- E-05: `apps/stats/src/providers/global-data-provider.tsx` - グローバルデータプロバイダー
- E-06: `apps/stats/src/views/Stats/Overview/overview.tsx` - 概要タブ
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | React 18.3.1で実装 | E-01 (react: 18.3.1) | ○ |
| C-02 | Viteでビルド | E-01 (vite: 5.4.20) | ○ |
| C-03 | TypeScriptを使用 | E-01 (tsc && vite build) | ○ |
| C-04 | @tryghost/admin-x-frameworkに依存 | E-01 (dependencies) | ○ |
| C-05 | @tryghost/shadeに依存 | E-01 (dependencies) | ○ |
| C-06 | @tanstack/react-queryでデータフェッチ | E-01 (devDependencies) | ○ |
| C-07 | react-svg-mapで世界地図表示 | E-01 (dependencies) | ○ |
| C-08 | @svg-maps/worldで地図データ | E-01 (dependencies) | ○ |
| C-09 | App as AdminXAppとしてエクスポート | E-02 (App as AdminXApp) | ○ |
| C-10 | FrameworkProviderでstaleTime: 0 | E-03 (staleTime: 0) | ○ |
| C-11 | FrameworkProviderでrefetchOnMount: true | E-03 (refetchOnMount: true) | ○ |
| C-12 | AppProviderでappSettings提供 | E-03 (AppProvider appSettings={appSettings}) | ○ |
| C-13 | StatsErrorBoundaryでエラーハンドリング | E-03 (StatsErrorBoundary) | ○ |
| C-14 | GlobalDataProviderでグローバルデータ提供 | E-03 (GlobalDataProvider) | ○ |
| C-15 | ShadeAppでデザインシステム適用 | E-03 (ShadeApp className='shade-stats app-container') | ○ |
| C-16 | /analyticsルート | E-04 (path: 'analytics') | ○ |
| C-17 | Overview/Web/Growth/Newslettersサブルート | E-04 (children: index, web, growth, newsletters) | ○ |
| C-18 | lazyComponentで遅延ロード | E-04 (lazy: lazyComponent) | ○ |
| C-19 | useBrowseSettingsで設定取得 | E-05 (useBrowseSettings()) | ○ |
| C-20 | useBrowseSiteでサイト情報取得 | E-05 (useBrowseSite()) | ○ |
| C-21 | useBrowseConfigで設定取得 | E-05 (useBrowseConfig()) | ○ |
| C-22 | useTinybirdTokenでトークン取得 | E-05 (useTinybirdToken({enabled: hasStatsConfig})) | ○ |
| C-23 | selectedNewsletterIdでニュースレター選択 | E-05 (useState<string | null>(null)) | ○ |
| C-24 | useGrowthStatsで会員成長統計 | E-06 (useGrowthStats(range)) | ○ |
| C-25 | useLatestPostStatsで最新記事統計 | E-06 (useLatestPostStats()) | ○ |
| C-26 | useTopPostsViewsで人気記事統計 | E-06 (useTopPostsViews()) | ○ |
| C-27 | useTinybirdQuery('api_kpis')で訪問者KPI | E-06 (endpoint: 'api_kpis') | ○ |
| C-28 | sanitizeChartDataでチャートデータ正規化 | E-06 (sanitizeChartData<WebKpiDataItem>) | ○ |
| C-29 | paidMembersEnabled時のみMRRチャート表示 | E-06 (if !appSettings?.paidMembersEnabled return []) | ○ |
| C-30 | Tinybird API詳細仕様 | **根拠なし**（外部APIドキュメント要確認） | △ |

## 4) 不足情報（Unknown / Missing）
- **Tinybird API詳細仕様**：api_kpis, api_top_sources, api_top_locationsの詳細パラメータと応答フォーマット。
  - 候補：Tinybird公式ドキュメント / `ghost/core/core/server/data/tinybird/` ソースコード

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 大部分の主張はソースコードで直接確認可能
- 0: 低リスク - 明確なコンポーネント構造で検証が容易
- 1: 中リスク - 外部API（Tinybird）の仕様は追加確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] C-30: Tinybird APIのエンドポイント仕様を確認
- [ ] 各タブ（Overview, Web, Growth, Newsletters）の表示条件を確認
- [ ] 日付範囲選択の動作を確認
- [ ] エラーハンドリング（StatsErrorBoundary）の動作を確認
- [ ] useGrowthStats, useLatestPostStats, useTopPostsViewsの実装を確認
