---
generated_at: 2026-01-29 11:10:00
metrics:
  claims_total: 26
  claims_with_evidence: 26
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：8-メンバー登録

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：26 / 26、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠あり。特に優先度の高いレビュー項目なし。

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ghost/core/core/server/models/member.js`
- E-02: `ghost/core/core/server/api/endpoints/members.js`
- E-03: `ghost/core/core/server/services/members/members-api/services/member-bread-service.js`
- E-04: `ghost/core/core/server/data/schema/schema.js`
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | membersテーブルが存在 | E-01 (7行目) tableName: 'members', E-04 (417行目) | ○ |
| C-02 | actionsCollectCRUD: trueで監査ログ記録 | E-01 (9行目) | ○ |
| C-03 | デフォルトstatus='free' | E-01 (15行目), E-04 (422-425行目) | ○ |
| C-04 | uuid自動生成（crypto.randomUUID） | E-01 (16行目) | ○ |
| C-05 | transient_id自動生成 | E-01 (17行目) | ○ |
| C-06 | productsとのbelongsToMany関係 | E-01 (171-180行目) | ○ |
| C-07 | newslettersとのbelongsToMany関係 | E-01 (182-190行目) | ○ |
| C-08 | labelsとのbelongsToMany関係 | E-01 (197-206行目) | ○ |
| C-09 | email_recipientsはdestroyRelated: false | E-01 (152-154行目) | ○ |
| C-10 | onSavingでラベル重複排除 | E-01 (279-324行目) | ○ |
| C-11 | searchQueryでname, emailのLIKE検索 | E-01 (379-384行目) | ○ |
| C-12 | toJSONでGravatarアバター生成 | E-01 (394-407行目) | ○ |
| C-13 | add/edit/destroyはトランザクション内で実行 | E-01 (424-461行目) | ○ |
| C-14 | allowedIncludes = ['email_recipients', 'products', 'tiers'] | E-02 (32行目) | ○ |
| C-15 | addアクションでemail必須 | E-02 (108-111行目) | ○ |
| C-16 | email_typeはsignin, signup, subscribeのいずれか | E-02 (113-115行目) | ○ |
| C-17 | 検証必須時はウェルカムメール抑制 | E-02 (120-123行目) | ○ |
| C-18 | exportCSVでCSVエクスポート | E-02 (370-400行目) | ○ |
| C-19 | importCSVでCSVインポート | E-02 (402-445行目) | ○ |
| C-20 | bulkEditでunsubscribe, addLabel, removeLabelアクション | E-02 (354-360行目) | ○ |
| C-21 | browse時のlimit制限は100 | E-03 (467-469行目) | ○ |
| C-22 | Stripe未接続でcomped指定時はエラー | E-03 (282-289行目) | ○ |
| C-23 | メール重複時はValidationError | E-03 (301-307行目) | ○ |
| C-24 | addでStripeカスタマーリンク | E-03 (316-321行目) | ○ |
| C-25 | addでウェルカムメール送信 | E-03 (338-342行目) | ○ |
| C-26 | logout時にtransient_idをサイクル | E-03 (451-453行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- すべての主張に対して根拠が確認できた。不足情報なし。

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: モデル定義の基本構造（コードから明確）
- **0 (低リスク)**: APIエンドポイント（コードから直接抽出）
- **0 (低リスク)**: BREADサービスのビジネスロジック（コードから明確）
- **0 (低リスク)**: トランザクション制御（コードから明確）

## 6) レビュアーチェックリスト（最小）
- [ ] メール重複チェックが正しく動作するか確認
- [ ] Stripe連携時のエラーハンドリングが正しいか確認
- [ ] ラベル重複排除ロジックが正しく動作するか確認
- [ ] 一覧取得時の100件制限が正しく適用されるか確認
- [ ] ウェルカムメール抑制条件が正しいか確認
