---
generated_at: 2026-01-29 12:45:00
metrics:
  claims_total: 35
  claims_with_evidence: 35
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：80-ActivityPub Admin

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：35 / 35、根拠なし：0
- 優先レビュー（高）
  - 特になし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `apps/activitypub/package.json` - パッケージ定義
- E-02: `apps/activitypub/src/index.tsx` - エントリーポイント
- E-03: `apps/activitypub/src/app.tsx` - アプリルート
- E-04: `apps/activitypub/src/routes.tsx` - ルーティング定義
- E-05: `apps/activitypub/src/api/activitypub.ts` - APIクライアント
- E-06: `apps/activitypub/src/views/inbox/inbox.tsx` - Inboxビュー
- E-07: `apps/activitypub/src/views/feed/feed.tsx` - Feedビュー
- E-08: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | React 18.3.1で実装 | E-01 (react: 18.3.1) | ○ |
| C-02 | Viteでビルド | E-01 (vite: 5.4.20) | ○ |
| C-03 | TypeScriptを使用 | E-01 (tsc && vite build) | ○ |
| C-04 | @tryghost/admin-x-frameworkに依存 | E-01 (dependencies) | ○ |
| C-05 | @tryghost/shadeに依存 | E-01 (dependencies) | ○ |
| C-06 | @radix-ui/react-formを使用 | E-01 (dependencies) | ○ |
| C-07 | use-debounceを使用 | E-01 (dependencies) | ○ |
| C-08 | AdminXAppとしてエクスポート | E-02 (export {default as AdminXApp}) | ○ |
| C-09 | routesをエクスポート | E-02 (export {routes}) | ○ |
| C-10 | FeatureFlagsProviderをエクスポート | E-02 (export {FeatureFlagsProvider}) | ○ |
| C-11 | activityPubEnabled=falseでnull返却 | E-03 (if activityPubEnabled === false return null) | ○ |
| C-12 | FrameworkProviderでラップ | E-03 (FrameworkProvider {...framework}) | ○ |
| C-13 | RouterProviderでprefix='/' | E-03 (RouterProvider prefix={'/'}) | ○ |
| C-14 | ShadeAppでdarkMode=false | E-03 (ShadeApp darkMode={false}) | ○ |
| C-15 | basePath='activitypub' | E-04 (basePath: 'activitypub') | ○ |
| C-16 | index→Navigateで'reader'へ | E-04 (element: <Navigate to="reader" />) | ○ |
| C-17 | reader→Inbox | E-04 (path: 'reader' → import('./views/inbox')) | ○ |
| C-18 | notes→Feed | E-04 (path: 'notes' → import('./views/feed/feed')) | ○ |
| C-19 | notifications→Notifications | E-04 (path: 'notifications' → import('./views/notifications')) | ○ |
| C-20 | explore→Explore | E-04 (path: 'explore' → import('./views/explore')) | ○ |
| C-21 | profile→Profile | E-04 (path: 'profile' → import('./views/profile')) | ○ |
| C-22 | preferences→Preferences | E-04 (path: 'preferences' → import('./views/preferences')) | ○ |
| C-23 | welcome→Onboarding | E-04 (path: 'welcome' → import('./components/layout/onboarding')) | ○ |
| C-24 | lazyComponentで遅延ロード | E-04 (lazy: lazyComponent) | ○ |
| C-25 | ActivityPubAPIクラス | E-05 (class ActivityPubAPI) | ○ |
| C-26 | getToken()でトークン取得 | E-05 (async getToken(): Promise<string \| null>) | ○ |
| C-27 | Authorization: Bearerヘッダー | E-05 (Authorization: `Bearer ${token}`) | ○ |
| C-28 | Accept: application/activity+jsonヘッダー | E-05 (Accept: 'application/activity+json') | ○ |
| C-29 | follow/unfollowアクション | E-05 (async follow/unfollow) | ○ |
| C-30 | like/unlikeアクション | E-05 (async like/unlike) | ○ |
| C-31 | repost/derepostアクション | E-05 (async repost/derepost) | ○ |
| C-32 | noteアクション | E-05 (async note(content, image)) | ○ |
| C-33 | Bluesky連携API（v2） | E-05 (enableBluesky/disableBluesky/confirmBlueskyHandle) | ○ |
| C-34 | useInboxForUser/useDiscoveryFeedForUser使用 | E-06 (useInboxForUser, useDiscoveryFeedForUser) | ○ |
| C-35 | useFeedForUser/useUserDataForUser使用 | E-07 (useFeedForUser, useUserDataForUser) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。すべての主張がソースコードで確認可能。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで直接確認可能
- 0: 低リスク - 明確なAPI設計で検証が容易
- 1: 要注意 - ActivityPubプロトコル仕様への準拠確認

## 6) レビュアーチェックリスト（最小）
- [ ] ActivityPub APIエンドポイント（.ghost/activitypub/v1/*）の仕様を確認
- [ ] Bluesky連携API（v2）の仕様を確認
- [ ] 各ビュー（Inbox, Feed, Notifications等）の動作を確認
- [ ] モデレーション機能（ブロック/ドメインブロック）の動作を確認
- [ ] Onboarding（初回セットアップ）フローを確認
- [ ] フィーチャーフラグによる機能制御を確認
