---
generated_at: 2026-01-29 10:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：81-Shade

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **バンドルサイズ最小化の詳細仕様**：具体的な数値目標が不明
  2. **コンポーネント数（50種以上）の正確性**：概算値のため要確認
  3. **利用シーンの完全性**：他の利用パターンがある可能性

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `apps/shade/package.json`
- E-02: `apps/shade/README.md`
- E-03: `apps/shade/AGENTS.md`
- E-04: `apps/shade/src/index.ts`
- E-05: `apps/shade/src/shade-app.tsx`
- E-06: `apps/shade/src/providers/shade-provider.tsx`
- E-07: `apps/shade/src/lib/utils.ts`
- E-08: `apps/shade/src/components/ui/button.tsx`
- E-09: `apps/shade/tailwind.config.cjs`
- E-10: `apps/shade/src/docs/introduction.mdx`
- E-11: `apps/shade/src/docs/architecture.mdx`
- E-12: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ShadCN/UI、Radix UI、TailwindCSSベースのデザインシステム | E-01, E-02, E-10 | ○ |
| C-02 | マイクロフロントエンド間で共有可能 | E-02, E-10 | ○ |
| C-03 | admin-x-design-systemを段階的に置き換え | E-03, CLAUDE.md | ○ |
| C-04 | 50種以上のUIコンポーネント提供 | E-04 | ○ |
| C-05 | TailwindCSSプリセットによるデザイントークン管理 | E-09 | ○ |
| C-06 | ShadeProvider/ShadeAppによるテーマ管理 | E-05, E-06 | ○ |
| C-07 | cn()関数によるクラス名マージ | E-07 | ○ |
| C-08 | ダークモード対応（.darkクラス） | E-05, E-09 | ○ |
| C-09 | CVAによるバリアント管理 | E-08 | ○ |
| C-10 | ToasterPortalによる通知表示 | E-06 | ○ |
| C-11 | lucide-reactアイコン利用 | E-01, E-04, E-11 | ○ |
| C-12 | rechartsチャートライブラリ利用 | E-01, E-04 | ○ |
| C-13 | react-hook-form + zodフォームバリデーション | E-01 | ○ |
| C-14 | .shadeコンテナでCSSスコープ | E-09 (important: '.shade') | ○ |
| C-15 | ESモジュールとしてエクスポート | E-01 (main: es/index.js) | ○ |
| C-16 | デザインサンドボックス画面（105番）が関連画面 | E-12 | ○ |
| C-17 | tree-shakingサポート | E-01 (sideEffects: false) | ○ |
| C-18 | バンドルサイズ最小化の具体的数値 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- バンドルサイズ最小化に関する具体的な数値目標や制限値
  - 候補：ビルド設定ファイル / パフォーマンステスト結果 / CI設定

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 大部分の主張がソースコードで確認可能
- 1: 中リスク - コンポーネント数の正確性は要確認（概算値）

## 6) レビュアーチェックリスト（最小）
- [ ] package.jsonの依存関係とドキュメントの記載が一致しているか確認
- [ ] tailwind.config.cjsのカラーパレット定義を確認
- [ ] ShadeApp/ShadeProviderの実装がドキュメントと一致するか確認
- [ ] CVAバリアントの定義パターンが正確か確認
