---
generated_at: 2026-01-29 10:35:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：82-Admin X Design System

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **段階的廃止の具体的スケジュール**：明確な期限が不明
  2. **関連画面番号（32-63）の正確性**：概算のため要確認

## 2) 参照した情報（Evidence一覧）

- E-01: `apps/admin-x-design-system/package.json`
- E-02: `apps/admin-x-design-system/README.md`
- E-03: `apps/admin-x-design-system/src/index.ts`
- E-04: `CLAUDE.md` (プロジェクトルート)
- E-05: `apps/admin-x-design-system/src/docs/Welcome.mdx`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Ghost Adminのレガシーデザインシステム | E-04 | ○ |
| C-02 | 段階的にShadeへ移行中 | E-04 | ○ |
| C-03 | フォームコンポーネント提供 | E-03 | ○ |
| C-04 | モーダルコンポーネント提供 | E-03 | ○ |
| C-05 | 設定専用コンポーネント提供 | E-03 | ○ |
| C-06 | レイアウトコンポーネント提供 | E-03 | ○ |
| C-07 | @radix-ui依存 | E-01 | ○ |
| C-08 | @dnd-kit依存 | E-01 | ○ |
| C-09 | @ebay/nice-modal-react依存 | E-01 | ○ |
| C-10 | react-colorful依存 | E-01 | ○ |
| C-11 | @uiw/react-codemirror依存 | E-01 | ○ |
| C-12 | tree-shakingサポート | E-01 (sideEffects: false) | ○ |
| C-13 | Storybookでドキュメント提供 | E-01 (scripts.storybook) | ○ |
| C-14 | 廃止スケジュールの具体的期限 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 段階的廃止の具体的なスケジュール・マイルストーン
  - 候補：プロジェクトロードマップ / GitHub Issues

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 大部分の主張がソースコードで確認可能
- 1: 中リスク - 廃止スケジュールが不明確なため、利用判断に影響あり

## 6) レビュアーチェックリスト（最小）
- [ ] package.jsonの依存関係を確認
- [ ] index.tsのエクスポート一覧が網羅されているか確認
- [ ] CLAUDE.mdでの「being phased out」記述を確認
