---
generated_at: 2026-01-29 10:40:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：83-Admin X Framework

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - 特になし。すべての主張に根拠あり。

## 2) 参照した情報（Evidence一覧）

- E-01: `apps/admin-x-framework/package.json`
- E-02: `apps/admin-x-framework/README.md`
- E-03: `apps/admin-x-framework/src/index.ts`
- E-04: `apps/admin-x-framework/src/providers/framework-provider.tsx`
- E-05: `apps/admin-x-framework/src/providers/app-provider.tsx`
- E-06: `apps/admin-x-framework/src/providers/router-provider.tsx`
- E-07: `apps/admin-x-framework/src/hooks/use-form.ts`
- E-08: `apps/admin-x-framework/src/hooks/use-permissions.ts`
- E-09: `apps/admin-x-framework/src/hooks/use-tinybird-query.ts`
- E-10: `apps/admin-x-framework/src/utils/api/hooks.ts`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | マイクロフロントエンド共通フレームワーク | E-02 | ○ |
| C-02 | @tanstack/react-query依存 | E-01 | ○ |
| C-03 | react-router依存 | E-01 | ○ |
| C-04 | @tinybirdco/charts依存 | E-01 | ○ |
| C-05 | FrameworkProvider提供 | E-03, E-04 | ○ |
| C-06 | AppProvider提供 | E-03, E-05 | ○ |
| C-07 | RouterProvider提供 | E-03, E-06 | ○ |
| C-08 | useForm提供 | E-03, E-07 | ○ |
| C-09 | usePermissions提供 | E-03, E-08 | ○ |
| C-10 | useTinybirdQuery提供 | E-03, E-09 | ○ |
| C-11 | ESMとCommonJS両方サポート | E-01 (exports定義) | ○ |
| C-12 | APIキャッシング機能 | E-10 | ○ |
| C-13 | フォームダーティ状態管理 | E-07 | ○ |
| C-14 | Ghost Admin APIとの通信 | E-10 | ○ |
| C-15 | Tinybirdトークン管理 | E-09 | ○ |
| C-16 | 権限チェック機能 | E-08 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] package.jsonの依存関係を確認
- [ ] index.tsのエクスポート一覧を確認
- [ ] Provider階層が正しく記述されているか確認
