---
generated_at: 2026-01-29 10:45:00
metrics:
  claims_total: 15
  claims_with_evidence: 12
  claims_without_evidence: 3
confidence_derived: 0.80
---

# 根拠レポート：84-Lexical Editor

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.80**
  - 根拠あり：12 / 15、根拠なし：3
- 優先レビュー（高）
  1. **@tryghost/koenig-lexicalの詳細実装**：外部パッケージのため詳細確認困難
  2. **自動保存間隔の具体値**：設定ファイルで要確認
  3. **コラボレーティブ編集機能のロードマップ**：将来機能として記載

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/core/core/server/data/schema/schema.js`（posts.lexicalカラム定義）
- E-02: `ghost/core/core/server/models/post.js`
- E-03: `apps/admin-x-design-system/src/global/form/koenig-editor-base.tsx`
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Lexicalフレームワークベースのエディタ | E-04 | ○ |
| C-02 | 記事・ページの作成・編集に使用 | E-05 | ○ |
| C-03 | posts.lexicalカラムに保存 | E-01 (66-67行目) | ○ |
| C-04 | Lexical JSON形式でシリアライズ | E-01 | ○ |
| C-05 | HTML出力の生成 | E-01 (posts.html) | ○ |
| C-06 | plaintext抽出 | E-01 (posts.plaintext) | ○ |
| C-07 | maxlength 1GB | E-01 (maxlength: 1000000000) | ○ |
| C-08 | @tryghost/koenig-lexical依存 | E-04 | ○ |
| C-09 | Unsplash API連携 | E-03 | ○ |
| C-10 | oEmbed連携 | E-04 | ○ |
| C-11 | post_revisionsへのリビジョン保存 | E-01 (post_revisions定義) | ○ |
| C-12 | エディタ画面（No.13）が関連画面 | E-05 | ○ |
| C-13 | 自動保存の具体的な間隔値 | **根拠なし** | △ |
| C-14 | 画像自動リサイズの仕様 | **根拠なし** | △ |
| C-15 | コラボレーティブ編集機能の計画 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 自動保存の具体的な間隔設定
  - 候補：Ghost Admin設定 / @tryghost/koenig-lexical内部設定
- 画像自動リサイズの具体的仕様
  - 候補：画像サービス設定
- コラボレーティブ編集のロードマップ
  - 候補：GitHub Issues / プロジェクトロードマップ

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - @tryghost/koenig-lexicalが外部パッケージのため、詳細実装の確認が困難
- 0: 低リスク - DBスキーマに基づく主張は確実

## 6) レビュアーチェックリスト（最小）
- [ ] posts.lexicalカラムの定義を確認
- [ ] @tryghost/koenig-lexicalパッケージの存在を確認
- [ ] エディタ画面（No.13）との関連を確認
- [ ] 自動保存設定の実際の値を確認
