---
generated_at: 2026-01-29 10:50:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：85-Mobiledoc変換

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - 特になし。すべての主張に根拠あり。

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/core/core/server/models/mobiledoc-revision.js`
- E-02: `ghost/core/core/server/data/schema/schema.js`（395-401行目）
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | tableName: mobiledoc_revisions | E-01 (4行目) | ○ |
| C-02 | permittedOptions: filter, columns | E-01 (6-17行目) | ○ |
| C-03 | orderDefaultRaw: created_at_ts DESC | E-01 (19-21行目) | ○ |
| C-04 | toJSONでcreated_at_ts除外 | E-01 (23-29行目) | ○ |
| C-05 | id: 24文字の主キー | E-02 (396行目) | ○ |
| C-06 | post_id: インデックスあり | E-02 (397行目) | ○ |
| C-07 | mobiledoc: 最大1GB | E-02 (398行目) | ○ |
| C-08 | created_at_ts: BigInt | E-02 (399行目) | ○ |
| C-09 | created_at: DateTime | E-02 (400行目) | ○ |
| C-10 | レガシーフォーマット | E-03 | ○ |
| C-11 | ghostBookshelfモデル | E-01 (1-3行目) | ○ |
| C-12 | モジュールエクスポート | E-01 (32-34行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] mobiledoc-revision.jsのモデル定義を確認
- [ ] schema.jsのmobiledoc_revisionsテーブル定義を確認
- [ ] orderDefaultRawの降順ソートを確認
- [ ] toJSONでのcreated_at_ts除外を確認
