---
generated_at: 2026-01-29 10:55:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：86-URL生成

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - 特になし。すべての主張に根拠あり。

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/core/core/server/services/url/url-service.js`
- E-02: `ghost/core/core/server/services/url/index.js`
- E-03: `ghost/core/core/server/services/url/url-generator.js`
- E-04: `ghost/core/core/server/services/url/urls.js`
- E-05: `ghost/core/core/server/services/url/resources.js`
- E-06: `ghost/core/core/server/services/url/queue.js`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UrlServiceクラスが中央管理 | E-01 | ○ |
| C-02 | Queue/Urls/Resourcesの初期化 | E-01 (29-43行目) | ○ |
| C-03 | onRouterAddedTypeでUrlGenerator登録 | E-01 (98-112行目) | ○ |
| C-04 | getResourceでURL→リソース変換 | E-01 (148-187行目) | ○ |
| C-05 | getUrlByResourceIdでID→URL変換 | E-01 (231-255行目) | ○ |
| C-06 | 404フォールバック | E-01 (246-254行目) | ○ |
| C-07 | URLSERVICE_NOT_READYエラー | E-01 (155-158行目) | ○ |
| C-08 | URLSERVICE_RESOURCE_NOT_FOUNDエラー | E-01 (198-201行目) | ○ |
| C-09 | initメソッドで初期化 | E-01 (303-328行目) | ○ |
| C-10 | キャッシュ永続化 | E-01 (307-310行目, labs.urlCache) | ○ |
| C-11 | メトリクス記録 | E-01 (87行目, metrics.metric) | ○ |
| C-12 | 登録順優先 | E-01 (164-180行目) | ○ |
| C-13 | ルーター更新対応 | E-01 (118-121行目, onRouterUpdated) | ○ |
| C-14 | hasFinished判定 | E-01 (211-213行目) | ○ |
| C-15 | shutdownでキャッシュ保存 | E-01 (330-337行目) | ○ |
| C-16 | resetメソッド | E-01 (343-355行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] url-service.jsのコンストラクタを確認
- [ ] getResource/getUrlByResourceIdの実装を確認
- [ ] onRouterAddedTypeの動作を確認
- [ ] エラーコードの定義を確認
