---
generated_at: 2026-01-29 11:00:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：87-リンクリダイレクト

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - 特になし。すべての主張に根拠あり。

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/core/core/server/services/link-redirection/link-redirects-service.js`
- E-02: `ghost/core/core/server/services/link-redirection/index.js`
- E-03: `ghost/core/core/server/services/link-redirection/link-redirect.js`
- E-04: `ghost/core/core/server/services/link-redirection/redirect-event.js`
- E-05: `ghost/core/core/server/services/link-redirection/link-redirect-repository.js`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | /r/プレフィックス | E-01 (21行目: redirectURLPrefix = 'r/') | ○ |
| C-02 | crypto.randomBytes(4)でスラグ生成 | E-01 (48行目) | ○ |
| C-03 | getSlugUrlでユニークスラグ生成 | E-01 (45-52行目) | ○ |
| C-04 | addRedirectでリダイレクト追加 | E-01 (69-78行目) | ○ |
| C-05 | handleRequestでリダイレクト処理 | E-01 (96-117行目) | ○ |
| C-06 | RedirectEvent発行 | E-01 (105-108行目) | ○ |
| C-07 | DomainEvents.dispatch | E-01 (110行目) | ○ |
| C-08 | X-Robots-Tag: noindex, nofollow | E-01 (112行目) | ○ |
| C-09 | 302リダイレクト | E-01 (113行目: res.redirect) | ○ |
| C-10 | 存在しない場合next() | E-01 (101-103行目) | ○ |
| C-11 | baseURL設定 | E-01 (30-37行目) | ○ |
| C-12 | relativeRedirectPrefix | E-01 (84-87行目) | ○ |
| C-13 | getFilteredIds | E-01 (59-61行目) | ○ |
| C-14 | LinkRedirectオブジェクト | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] link-redirects-service.jsのhandleRequestを確認
- [ ] スラグ生成ロジックを確認
- [ ] RedirectEventの発行を確認
- [ ] X-Robots-Tag設定を確認
