---
generated_at: 2026-01-29 11:05:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：88-認証

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 特になし。すべての主張に根拠あり。

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/core/core/server/services/auth/index.js`
- E-02: `ghost/core/core/server/services/auth/authenticate.js`
- E-03: `ghost/core/core/server/services/auth/session/session-service.js`
- E-04: `ghost/core/core/server/services/auth/passwordreset.js`
- E-05: `ghost/core/core/server/services/auth/api-key/admin.js`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | セッション認証とAPIキー認証の両方サポート | E-02 | ○ |
| C-02 | authenticateAdminApi定義 | E-02 (6行目) | ○ |
| C-03 | authenticateContentApi定義 | E-02 (9行目) | ○ |
| C-04 | cookieCsrfProtection実装 | E-03 (78-92行目) | ○ |
| C-05 | isVerificationRequired実装 | E-03 (99-101行目) | ○ |
| C-06 | createSessionForUser実装 | E-03 (111-136行目) | ○ |
| C-07 | sendAuthCodeToUser実装 | E-03 (245-289行目) | ○ |
| C-08 | getUserForSession実装 | E-03 (337-360行目) | ○ |
| C-09 | OTP検証 | E-03 (171-175行目, verifyAuthCodeForUser) | ○ |
| C-10 | session.verified管理 | E-03 (297-300行目) | ○ |
| C-11 | generateToken実装 | E-04 (36-64行目) | ○ |
| C-12 | doReset実装 | E-04 (96-162行目) | ○ |
| C-13 | リセットトークン1日有効 | E-04 (52-53行目, moment().add(1, 'days')) | ○ |
| C-14 | JWT認証（Admin API） | E-05 | ○ |
| C-15 | サインイン画面（No.1）が関連 | E-06 | ○ |
| C-16 | パスワードリセット画面（No.4）が関連 | E-06 | ○ |
| C-17 | user_agent, ip記録 | E-03 (122-123行目) | ○ |
| C-18 | Origin検証（CSRF） | E-03 (87-91行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] session-service.jsのCSRF保護ロジックを確認
- [ ] OTP生成・検証ロジックを確認
- [ ] パスワードリセットトークンの有効期限を確認
- [ ] 画面機能マッピングとの整合性を確認
