---
generated_at: 2026-01-29 11:10:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：89-APIキー管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - 特になし。すべての主張に根拠あり。

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/core/core/server/models/api-key.js`
- E-02: `ghost/core/core/server/data/schema/schema.js`（371-394行目）
- E-03: `ghost/core/core/server/services/auth/api-key/admin.js`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | tableName: api_keys | E-01 (7行目) | ○ |
| C-02 | actionsCollectCRUD: true | E-01 (9行目) | ○ |
| C-03 | defaults()でシークレット自動生成 | E-01 (13-17行目) | ○ |
| C-04 | security.secret.create(type) | E-01 (13行目) | ○ |
| C-05 | role() belongsTo関係 | E-01 (20-22行目) | ○ |
| C-06 | integration() belongsTo関係 | E-01 (24-26行目) | ○ |
| C-07 | user() belongsTo関係 | E-01 (28-30行目) | ○ |
| C-08 | onSavingでロール強制 | E-01 (36-54行目) | ○ |
| C-09 | Admin Integrationロール検索 | E-01 (44行目) | ○ |
| C-10 | Contentキーはrole_id=null | E-01 (50-52行目) | ○ |
| C-11 | onUpdatedでrefreshedアクション | E-01 (55-59行目) | ○ |
| C-12 | refreshSecret静的メソッド | E-01 (61-64行目) | ○ |
| C-13 | type: content/admin | E-02 (373-378行目) | ○ |
| C-14 | secret: 26-128文字 | E-02 (379-385行目) | ○ |
| C-15 | last_seen_at, last_seen_version | E-02 (390-391行目) | ○ |
| C-16 | インテグレーション設定画面（No.58）が関連 | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] api-key.jsのモデル定義を確認
- [ ] schema.jsのapi_keysテーブル定義を確認
- [ ] onSavingのロール強制ロジックを確認
- [ ] refreshSecretの動作を確認
