---
generated_at: 2026-01-29 11:20:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：9-メンバー認証

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠あり。特に優先度の高いレビュー項目なし。

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ghost/core/core/server/services/auth/members/index.js`
- E-02: `ghost/core/core/server/services/members/members-ssr.js`
- E-03: `ghost/core/core/server/api/endpoints/session.js`
- E-04: `ghost/core/core/server/services/auth/session/session-service.js`
- E-05: `ghost/core/core/server/services/auth/session/middleware.js`
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GhostMembers認証スキームを使用 | E-01 (28行目) scheme !== 'GhostMembers' | ○ |
| C-02 | RS512アルゴリズムで署名検証 | E-01 (19行目) algorithms: ['RS512'] | ○ |
| C-03 | credentialsRequired: false（オプショナル認証） | E-01 (15行目) | ○ |
| C-04 | セッション有効期間は約6ヶ月（184日） | E-02 (26行目) SIX_MONTHS_MS = 1000 * 60 * 60 * 24 * 184 | ○ |
| C-05 | Cookie名はmembers-ssr | E-02 (49行目) cookieName = 'members-ssr' | ○ |
| C-06 | CookieはSameSite=lax | E-02 (75行目) sameSite: 'lax' | ○ |
| C-07 | CookieはHttpOnly | E-02 (74行目) httpOnly: true | ○ |
| C-08 | transient_idでセッション識別 | E-02 (264行目) this._setSessionCookie(req, res, member.transient_id) | ○ |
| C-09 | 初回ログイン時にGeoIP設定 | E-02 (254-262行目) | ○ |
| C-10 | exchangeTokenForSessionでトークン交換 | E-02 (228-267行目) | ○ |
| C-11 | deleteSessionでログアウト | E-02 (281-290行目) | ○ |
| C-12 | body.all=trueで全セッション無効化 | E-02 (282-287行目) | ○ |
| C-13 | getMemberDataFromSessionでセッション確認 | E-02 (300-304行目) | ○ |
| C-14 | ghost-access, ghost-access-hmac Cookieの削除 | E-02 (115-118行目) | ○ |
| C-15 | Admin認証はusername/password方式 | E-03 (16行目, 29-32行目) | ○ |
| C-16 | Admin認証で2FA対応 | E-03 (69-78行目) sendVerification, verify | ○ |
| C-17 | Admin 2FAはOTP方式 | E-04 (158-162行目) otp.generate, E-04 (171-175行目) otp.verify | ○ |
| C-18 | Admin認証でisVerificationRequired() | E-04 (99-101行目) require_email_mfa設定確認 | ○ |
| C-19 | Adminセッション作成時にverified状態設定 | E-04 (126-135行目) | ○ |
| C-20 | Admin認証コードメール送信 | E-04 (245-289行目) sendAuthCodeToUser | ○ |
| C-21 | Adminミドルウェアで2FAトークン要求エラー | E-05 (17-22行目) 2FA_TOKEN_REQUIRED / 2FA_NEW_DEVICE_DETECTED | ○ |
| C-22 | Adminログアウトで204ステータス | E-05 (32行目) res.sendStatus(204) | ○ |

## 4) 不足情報（Unknown / Missing）
- すべての主張に対して根拠が確認できた。不足情報なし。

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: JWT認証設定（コードから明確）
- **0 (低リスク)**: Cookie設定（コードから明確）
- **0 (低リスク)**: セッション管理フロー（コードから明確）
- **0 (低リスク)**: Admin 2FA実装（コードから明確）

## 6) レビュアーチェックリスト（最小）
- [ ] マジックリンクの有効期限が適切か確認
- [ ] セッションCookieの有効期間が適切か確認
- [ ] RS512署名検証が正しく動作するか確認
- [ ] 全セッション無効化（transient_idサイクル）が正しく動作するか確認
- [ ] Admin 2FAが正しく動作するか確認
