---
generated_at: 2026-01-29 11:15:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：90-ブルートフォース対策

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - 特になし。すべての主張に根拠あり。

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/core/core/server/data/schema/schema.js`（322-328行目）
- E-02: `ghost/core/core/server/web/shared/middleware/brute.js`
- E-03: `ghost/core/core/server/web/shared/middleware/api/spam-prevention.js`
- E-04: `ghost/core/core/server/web/api/endpoints/admin/routes.js`
- E-05: `ghost/core/core/server/api/endpoints/session.js`
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | bruteテーブル定義（key, firstRequest, lastRequest, lifetime, count） | E-01 (322-328行目) | ○ |
| C-02 | keyがプライマリキー、maxlength: 191 | E-01 (323行目) | ○ |
| C-03 | globalBlockミドルウェア | E-02 (12-18行目) | ○ |
| C-04 | userLoginミドルウェア | E-02 (34-40行目) | ○ |
| C-05 | userResetミドルウェア | E-02 (45-51行目) | ○ |
| C-06 | privateBlogミドルウェア | E-02 (78-84行目) | ○ |
| C-07 | contentApiKeyミドルウェア（成功時リセット） | E-02 (90-106行目) | ○ |
| C-08 | membersAuthミドルウェア | E-02 (111-121行目) | ○ |
| C-09 | membersAuthEnumerationミドルウェア | E-02 (127-128行目) | ○ |
| C-10 | otcVerificationミドルウェア | E-02 (141-151行目) | ○ |
| C-11 | BruteKnexでtablename: 'brute' | E-03 (92行目, 121行目等) | ○ |
| C-12 | ExpressBruteインスタンス生成 | E-03 (87行目, 97行目等) | ○ |
| C-13 | spamConfigKeys: freeRetries, minWait, maxWait, lifetime | E-03 (62行目) | ○ |
| C-14 | TooManyRequestsErrorの返却 | E-03 (101-106行目) | ○ |
| C-15 | attachResetToRequest: true（userLogin） | E-03 (338行目) | ○ |
| C-16 | MemoryStore使用（contentApiKey） | E-03 (477-479行目) | ○ |
| C-17 | /session POST にglobalBlock + userLogin | E-04 (266-269行目) | ○ |
| C-18 | /authentication/password_reset POSTにglobalReset + userReset | E-04 (279-282行目) | ○ |
| C-19 | req.brute.reset()でカウンタリセット | E-05 (35行目) | ○ |
| C-20 | config.get('spam')で設定取得 | E-03 (8行目) | ○ |
| C-21 | handleStoreErrorでエラーログ出力 | E-03 (64-80行目) | ○ |
| C-22 | reset()関数で全インスタンスクリア | E-03 (512-540行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] schema.jsのbruteテーブル定義を確認
- [ ] brute.jsの各ミドルウェアエクスポートを確認
- [ ] spam-prevention.jsのExpressBruteインスタンス生成を確認
- [ ] routes.jsでのbrute.*ミドルウェア適用を確認
- [ ] session.jsのreq.brute.reset()呼び出しを確認
