---
generated_at: 2026-01-29 21:15:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：91-Explore連携

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **C-25 スケジュール実行予定**：コメントのみで実装計画は不明

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ghost/core/core/server/services/explore-ping/explore-ping-service.js` (1-131行目)
- E-02: `ghost/core/core/server/services/explore-ping/index.js` (1-35行目)
- E-03: `ghost/core/core/server/services/explore/explore-service.js` (1-60行目)
- E-04: `ghost/core/core/server/services/explore/index.js` (1-19行目)
- E-05: `ghost/core/core/server/api/endpoints/explore.js` (1-19行目)
- E-06: `ghost/core/core/server/api/endpoints/utils/serializers/output/explore.js` (1-12行目)
- E-07: `ghost/core/core/server/data/schema/default-settings/default-settings.json` (636-652行目)
- E-08: `ghost/core/core/server/data/schema/fixtures/fixtures.json` (explore関連行)
- E-09: `ghost/core/test/unit/server/services/explore-ping/explore-ping-service.test.js` (1-304行目)
- E-10: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (53, 74, 75行目)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Explore連携はGhost ExploreディレクトリへのGhostサイト情報登録・同期機能 | E-01, E-03 | ○ |
| C-02 | サーバー起動時に自動的にExploreへpingを送信 | E-02 (27-34行目) | ○ |
| C-03 | Labs 'explore'フラグが有効な場合のみping送信 | E-01 (112-114行目) | ○ |
| C-04 | explore_ping設定がtrueの場合のみping送信 | E-01 (122-125行目) | ○ |
| C-05 | explore_ping_growth設定がtrueの場合のみメンバー・MRR送信 | E-01 (62-85行目) | ○ |
| C-06 | stripe_connect_livemodeがtrueの場合のみMRRデータ送信 | E-01 (69-76行目), E-09 (135-196行目) | ○ |
| C-07 | ペイロードにGhostバージョン、site_uuid、url、theme等を含む | E-01 (32-40行目), E-09 (96-108行目) | ○ |
| C-08 | 投稿統計（総数、最新日、初投稿日）を取得 | E-01 (43-51行目) | ○ |
| C-09 | 投稿統計取得失敗時はnullを設定 | E-01 (52-60行目), E-09 (198-205行目) | ○ |
| C-10 | メンバー統計取得失敗時はnullを設定 | E-01 (77-84行目), E-09 (207-213行目) | ○ |
| C-11 | HTTPリクエストはPOSTメソッドでJSON形式 | E-01 (90-101行目), E-09 (243-252行目) | ○ |
| C-12 | リクエスト失敗時は警告ログを出力 | E-01 (106-108行目), E-09 (254-262行目) | ○ |
| C-13 | ExploreService.fetchData()でAdmin API用データ取得 | E-03 (25-58行目), E-05 (12-14行目) | ○ |
| C-14 | fetchDataでメンバー数、MRR履歴、サイト情報を収集 | E-03 (26-47行目) | ○ |
| C-15 | fetchDataでオーナーメールアドレスを取得 | E-03 (54-55行目) | ○ |
| C-16 | Admin APIはexploreの読み取り権限が必要 | E-05 (9行目), E-08 (explore権限設定) | ○ |
| C-17 | 関連画面にExplore設定（画面No.53）がある | E-10 (53行目) | ○ |
| C-18 | 関連画面にExplore画面（画面No.74）がある | E-10 (74行目) | ○ |
| C-19 | 関連画面にExplore接続画面（画面No.75）がある | E-10 (75行目) | ○ |
| C-20 | explore_pingのデフォルト値はtrue | E-07 (637-644行目) | ○ |
| C-21 | explore_ping_growthのデフォルト値はfalse | E-07 (645-652行目) | ○ |
| C-22 | explore_url未設定時は警告ログを出力 | E-01 (117-119行目), E-09 (274-282行目) | ○ |
| C-23 | MRRデータはcurrencyとmrrを含む配列形式 | E-09 (177-178行目, 191-195行目) | ○ |
| C-24 | データベースへの書き込み操作がない | E-01, E-03 全体 | ○ |
| C-25 | 将来的にスケジュール実行が予定されている | E-02 (30-31行目コメント) | △ |

## 4) 不足情報（Unknown / Missing）
- C-25について：コードコメントに「The final intention is to have this run on a schedule」とあるが、具体的な実装計画や時期は不明
  - 候補：開発ロードマップ / IssueTracker / プロダクトバックログ

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ほぼすべての主張がソースコードで確認可能
- 1: 中リスク - 将来計画（スケジュール実行）の記載は根拠が薄い

## 6) レビュアーチェックリスト（最小）
- [ ] Labs機能としてexploreフラグの制御が正しく記載されているか確認
- [ ] MRRデータのlivemode制限が正しく記載されているか確認
- [ ] 関連画面（53, 74, 75）との整合性を確認
- [ ] 将来計画の記載を削除または注釈を追加するか検討
