---
generated_at: 2026-01-29 21:20:00
metrics:
  claims_total: 32
  claims_with_evidence: 31
  claims_without_evidence: 1
confidence_derived: 0.97
---

# 根拠レポート：92-メンバー属性

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：31 / 32、根拠なし：1
- 優先レビュー（高）
  1. **C-32 セッション終了時の自動削除**：ブラウザ依存の動作のため実装詳細は不明

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ghost/core/core/frontend/src/member-attribution/member-attribution.js` (1-178行目)
- E-02: `ghost/core/core/frontend/src/utils/url-attribution.js` (1-105行目)
- E-03: `ghost/core/core/server/services/member-attribution/index.js` (1-58行目)
- E-04: `ghost/core/core/server/services/member-attribution/member-attribution-service.js` (1-220行目)
- E-05: `ghost/core/core/server/services/member-attribution/attribution-builder.js` (1-251行目)
- E-06: `ghost/core/core/server/services/member-attribution/url-history.js` (1-98行目)
- E-07: `ghost/core/core/server/services/member-attribution/url-translator.js` (1-164行目)
- E-08: `ghost/core/core/server/services/member-attribution/referrer-translator.js` (1-121行目)
- E-09: `ghost/core/core/server/services/member-attribution/outbound-link-tagger.js` (1-116行目)
- E-10: `ghost/core/core/server/models/member-created-event.js` (1-58行目)
- E-11: `ghost/core/core/server/models/subscription-created-event.js` (1-46行目)
- E-12: `ghost/core/core/server/data/schema/schema.js` (520-790行目)
- E-13: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (24, 29行目)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | メンバー属性はメンバー獲得経路・リファラーを追跡する機能 | E-03, E-04 | ○ |
| C-02 | フロントエンドでsessionStorageを使用して履歴を保存 | E-01 (8行目, 38行目) | ○ |
| C-03 | 履歴のキー名は'ghost-history' | E-01 (8行目) | ○ |
| C-04 | 24時間以上前のエントリは無効 | E-01 (13行目), E-06 (94行目) | ○ |
| C-05 | 履歴は最大15件まで保持 | E-01 (16行目, 168-170行目) | ○ |
| C-06 | ALLOWED_TYPESは'post'のみ許可 | E-06 (24行目) | ○ |
| C-07 | Last Post Algorithmでアトリビューション決定 | E-05 (168-247行目) | ○ |
| C-08 | post > page/tag/author > url の優先順位 | E-05 (207-238行目) | ○ |
| C-09 | members_track_sources設定で追跡を制御 | E-03 (52行目), E-04 (78-80行目) | ○ |
| C-10 | outbound_link_tagging設定でリンクタギング制御 | E-03 (39行目), E-09 (33-35行目) | ○ |
| C-11 | ref > source > utm_source の順でソース決定 | E-02 (33行目) | ○ |
| C-12 | checkout.stripe.comからのリファラーは無視 | E-08 (80-83行目) | ○ |
| C-13 | import/api/adminコンテキストで特別なアトリビューション | E-04 (36-67行目) | ○ |
| C-14 | importコンテキストはreferrerSource='Imported' | E-04 (46-48行目) | ○ |
| C-15 | adminコンテキストはreferrerSource='Created manually' | E-04 (49-51行目) | ○ |
| C-16 | apiコンテキストはreferrerSource='Created via API' | E-04 (52-54行目) | ○ |
| C-17 | integration情報があればIntegration名をreferrerSourceに設定 | E-04 (58-65行目) | ○ |
| C-18 | attribution_id/typeをURLパラメータから取得 | E-01 (119-140行目) | ○ |
| C-19 | URLパラメータ取得後にパラメータを削除 | E-01 (132-136行目) | ○ |
| C-20 | members_created_eventsにアトリビューション記録 | E-12 (526-554行目), E-10 | ○ |
| C-21 | members_subscription_created_eventsにアトリビューション記録 | E-12 (715-739行目), E-11 | ○ |
| C-22 | donation_payment_eventsにアトリビューション記録 | E-12 (762-789行目) | ○ |
| C-23 | Facebookドメイン等へのref付与はブロック | E-09 (4-14行目) | ○ |
| C-24 | OutboundLinkTaggerは既存のref/utm_source/sourceがあれば上書きしない | E-09 (56-59行目) | ○ |
| C-25 | ニュースレター名をrefパラメータに使用可能 | E-09 (74-79行目) | ○ |
| C-26 | Attribution型にはutmSource/utmMedium/utmCampaign/utmTerm/utmContent含む | E-05 (10-14行目) | ○ |
| C-27 | ReferrerParserパッケージを使用 | E-08 (13行目) | ○ |
| C-28 | 同一ドメインリファラーは除外 | E-02 (79-86行目) | ○ |
| C-29 | Portal内のハッシュURL（#/portal）も対応 | E-02 (59-62行目) | ○ |
| C-30 | postAttribution/userAttribution/tagAttributionのリレーション定義 | E-10 (18-27行目), E-11 (22-31行目) | ○ |
| C-31 | 関連画面24と29が存在 | E-13 (24, 29行目) | ○ |
| C-32 | セッション終了時に履歴が自動削除される | E-01 (sessionStorage使用) | △ |

## 4) 不足情報（Unknown / Missing）
- C-32について：sessionStorageの動作はブラウザ仕様に依存。コード上では明示的な削除処理なし
  - 候補：ブラウザ仕様ドキュメント / MDN Web Docs

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ほぼすべての主張がソースコードで確認可能
- 0: 低リスク - データベーススキーマとモデル定義が整合

## 6) レビュアーチェックリスト（最小）
- [ ] Last Post Algorithmの優先順位が正しく記載されているか確認
- [ ] UTMパラメータの全項目（source/medium/campaign/term/content）が漏れなく記載されているか確認
- [ ] ブロックドメインリストが最新であるか確認（E-09）
- [ ] コンテキスト判定ロジック（import/api/admin/member）の網羅性を確認
- [ ] 関連画面（24, 29）との整合性を確認
