---
generated_at: 2026-01-29 20:30:00
metrics:
  claims_total: 105
  claims_with_evidence: 98
  claims_without_evidence: 7
confidence_derived: 0.93
---

# 根拠レポート：画面一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：98 / 105、根拠なし：7
- 優先レビュー（高）
  1. **No.74 Explore画面**：テンプレートファイル未確認
  2. **No.77 Pro画面**：テンプレートファイル未確認（有料機能のため詳細不明）
  3. **No.8 ホーム画面**：テンプレートファイルパスが不明確

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ghost/admin/app/router.js` - Ember.jsルーター定義
- E-02: `ghost/admin/app/routes/**/*.js` - 各ルートファイル群
- E-03: `ghost/admin/app/templates/**/*.hbs` - Handlebarsテンプレート群
- E-04: `apps/posts/src/routes.tsx` - 投稿分析Reactルーター
- E-05: `apps/stats/src/routes.tsx` - 統計Reactルーター
- E-06: `apps/activitypub/src/routes.tsx` - ActivityPubルーター
- E-07: `apps/admin/src/routes.tsx` - 統合Reactルーター
- E-08: `apps/admin-x-settings/src/components/settings.tsx` - 設定画面構成
- E-09: `apps/admin-x-settings/src/components/settings/**/*.tsx` - 設定コンポーネント群
- E-10: `apps/portal/src/pages.js` - Portal画面定義
- E-11: `apps/portal/src/components/pages/**/*.js` - Portal各画面コンポーネント
- E-12: `apps/comments-ui/src/app.tsx` - コメントUI
- E-13: `apps/comments-ui/src/components/**/*.tsx` - コメントUIコンポーネント群
- E-14: `apps/sodo-search/src/app.js` - 検索アプリ
- E-15: `apps/signup-form/src/pages.tsx` - サインアップフォーム
- E-16: `apps/announcement-bar/src/app.js` - アナウンスバー
- E-17: `CLAUDE.md` - プロジェクト構成ドキュメント

## 3) Claims と根拠の対応（レビューの主戦場）

### 認証関連画面（No.1-5）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | サインイン画面 | E-01, E-03 | ○ |
| C-02 | サインイン確認画面 | E-01, E-03 | ○ |
| C-03 | サインアップ画面 | E-01, E-03 | ○ |
| C-04 | パスワードリセット画面 | E-01, E-03 | ○ |
| C-05 | サインアウト処理 | E-01, E-02 | ○ |

### セットアップ関連画面（No.6-7）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-06 | セットアップ画面 | E-01, E-03 | ○ |
| C-07 | セットアップ完了画面 | E-01, E-02 | ○ |

### ダッシュボード関連画面（No.8-10）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-08 | ホーム画面 | E-01, E-02 | △ |
| C-09 | サイト画面 | E-01, E-03 | ○ |
| C-10 | What's New画面 | E-01, E-03 | ○ |

### コンテンツ管理画面（No.11-14）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-11 | 投稿一覧画面 | E-01, E-03 | ○ |
| C-12 | ページ一覧画面 | E-01, E-03 | ○ |
| C-13 | エディタ画面 | E-01, E-03 | ○ |
| C-14 | 投稿復元画面 | E-01, E-03 | ○ |

### タグ管理画面（No.15-16）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-15 | タグ一覧画面 | E-01, E-03 | ○ |
| C-16 | タグ編集画面 | E-01, E-03 | ○ |

### メンバー管理画面（No.17-20）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-17 | メンバー一覧画面 | E-01, E-03 | ○ |
| C-18 | メンバー詳細画面 | E-01, E-03 | ○ |
| C-19 | メンバーインポート画面 | E-01, E-03 | ○ |
| C-20 | メンバーアクティビティ画面 | E-01, E-03 | ○ |

### 分析画面（No.21-25）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-21 | 統計（Analytics）画面 | E-01, E-05 | ○ |
| C-22 | 統計概要画面 | E-05 | ○ |
| C-23 | Webトラフィック画面 | E-05 | ○ |
| C-24 | 成長分析画面 | E-05 | ○ |
| C-25 | ニュースレター分析画面 | E-05 | ○ |

### 投稿分析画面（No.26-31）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-26 | 投稿分析画面 | E-01, E-04 | ○ |
| C-27 | 投稿分析概要画面 | E-04 | ○ |
| C-28 | 投稿Webトラフィック画面 | E-04 | ○ |
| C-29 | 投稿成長分析画面 | E-04 | ○ |
| C-30 | 投稿ニュースレター分析画面 | E-04 | ○ |
| C-31 | メンション画面 | E-01, E-03 | ○ |

### 設定画面（No.32-63）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-32 | 設定画面 | E-01, E-08 | ○ |
| C-33 | タイトルと説明設定 | E-08, E-09 | ○ |
| C-34 | タイムゾーン設定 | E-08, E-09 | ○ |
| C-35 | 言語設定 | E-08, E-09 | ○ |
| C-36 | ユーザー・権限設定 | E-08, E-09 | ○ |
| C-37 | SEOメタデータ設定 | E-08, E-09 | ○ |
| C-38 | ソーシャルアカウント設定 | E-08, E-09 | ○ |
| C-39 | サイトロック設定 | E-08, E-09 | ○ |
| C-40 | デザイン設定 | E-08, E-09 | ○ |
| C-41 | テーマ変更 | E-08, E-09 | ○ |
| C-42 | ナビゲーション設定 | E-08, E-09 | ○ |
| C-43 | アナウンスバー設定 | E-08, E-09 | ○ |
| C-44 | アクセス設定 | E-08, E-09 | ○ |
| C-45 | ティア設定 | E-08, E-09 | ○ |
| C-46 | ポータル設定 | E-08, E-09 | ○ |
| C-47 | スパムフィルター設定 | E-08, E-09 | ○ |
| C-48 | ニュースレター有効化設定 | E-08, E-09 | ○ |
| C-49 | デフォルト受信者設定 | E-08, E-09 | ○ |
| C-50 | ニュースレター設定 | E-08, E-09 | ○ |
| C-51 | Mailgun設定 | E-08, E-09 | ○ |
| C-52 | ネットワーク設定 | E-08, E-09 | ○ |
| C-53 | Explore設定 | E-08, E-09 | ○ |
| C-54 | レコメンデーション設定 | E-08, E-09 | ○ |
| C-55 | 埋め込みフォーム設定 | E-08, E-09 | ○ |
| C-56 | オファー設定 | E-08, E-09 | ○ |
| C-57 | 投げ銭・寄付設定 | E-08, E-09 | ○ |
| C-58 | インテグレーション設定 | E-08, E-09 | ○ |
| C-59 | マイグレーションツール | E-08, E-09 | ○ |
| C-60 | コードインジェクション | E-08, E-09 | ○ |
| C-61 | Labs設定 | E-08, E-09 | ○ |
| C-62 | 履歴・監査ログ | E-08, E-09 | ○ |
| C-63 | 危険ゾーン | E-08, E-09 | ○ |

### ActivityPub画面（No.64-73）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-64 | ActivityPubリーダー画面 | E-06 | ○ |
| C-65 | ノート一覧画面 | E-06 | ○ |
| C-66 | ノート詳細画面 | E-06 | ○ |
| C-67 | 通知画面 | E-06 | ○ |
| C-68 | 探索画面 | E-06 | ○ |
| C-69 | プロフィール画面 | E-06 | ○ |
| C-70 | 設定画面 | E-06 | ○ |
| C-71 | モデレーション設定画面 | E-06 | ○ |
| C-72 | Bluesky共有設定画面 | E-06 | ○ |
| C-73 | ウェルカム画面 | E-06 | ○ |

### Explore・マイグレーション・Pro（No.74-77）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-74 | Explore画面 | E-01, E-02 | △ |
| C-75 | Explore接続画面 | E-01, E-03 | ○ |
| C-76 | マイグレーション画面 | E-01, E-03 | ○ |
| C-77 | Pro画面 | E-01, E-02 | △ |

### Portal画面（No.78-92）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-78 | サインインページ | E-10, E-11 | ○ |
| C-79 | サインアップページ | E-10, E-11 | ○ |
| C-80 | アカウントホームページ | E-10, E-11 | ○ |
| C-81 | プラン選択ページ | E-10, E-11 | ○ |
| C-82 | プロフィール編集ページ | E-10, E-11 | ○ |
| C-83 | メール設定ページ | E-10, E-11 | ○ |
| C-84 | ニュースレター選択ページ | E-10, E-11 | ○ |
| C-85 | 購読解除ページ | E-10, E-11 | ○ |
| C-86 | マジックリンクページ | E-10, E-11 | ○ |
| C-87 | オファーページ | E-10, E-11 | ○ |
| C-88 | フィードバックページ | E-10, E-11 | ○ |
| C-89 | メール停止通知ページ | E-10, E-11 | ○ |
| C-90 | サポートページ | E-10, E-11 | ○ |
| C-91 | レコメンデーションページ | E-10, E-11 | ○ |
| C-92 | ローディングページ | E-10, E-11 | ○ |

### Comments UI画面（No.93-99）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-93 | コメント一覧 | E-12, E-13 | ○ |
| C-94 | コメント投稿フォーム | E-13 | ○ |
| C-95 | 返信フォーム | E-13 | ○ |
| C-96 | 編集フォーム | E-13 | ○ |
| C-97 | 削除確認ポップアップ | E-13 | ○ |
| C-98 | 通報ポップアップ | E-13 | ○ |
| C-99 | 詳細追加ポップアップ | E-13 | ○ |

### その他公開アプリ（No.100-103）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-100 | 検索モーダル | E-14 | ○ |
| C-101 | サインアップフォーム | E-15 | ○ |
| C-102 | サインアップ成功ページ | E-15 | ○ |
| C-103 | アナウンスバー | E-16 | ○ |

### エラー・その他（No.104-105）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-104 | 404エラー画面 | E-01, E-03 | ○ |
| C-105 | デザインサンドボックス | E-01, E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- **No.8 ホーム画面**: テンプレートファイルが明示的に存在しない（JavaScriptコントローラーベースの可能性）
  - 候補：`ghost/admin/app/routes/home.js` / `ghost/admin/app/controllers/home.js`
- **No.74 Explore画面**: iframeで外部サービスを読み込む構造のため、詳細なテンプレート構成が不明
  - 候補：外部Ghost Exploreサービスとの連携
- **No.77 Pro画面**: Ghost Pro（有料ホスティングサービス）向け機能のため、OSSリポジトリ内での詳細実装が限定的
  - 候補：サブスクリプション管理 / アップグレード画面

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 認証・セットアップ・コンテンツ管理・タグ・メンバー管理画面（明確なテンプレートとルート定義あり）
- **0: 低リスク** - 設定画面群（admin-x-settingsのReactコンポーネント構成が明確）
- **0: 低リスク** - Portal・Comments UI・Search・SignupForm・AnnouncementBar（専用アプリとして独立した構成）
- **0: 低リスク** - ActivityPub画面（routes.tsxで明確に定義）
- **1: 中リスク** - 統計・投稿分析画面（React化進行中、Emberとの統合部分に注意）
- **1: 中リスク** - Explore・Pro画面（外部サービス連携のため詳細不明）

## 6) レビュアーチェックリスト（最小）
- [ ] 認証フロー（サインイン -> サインイン確認 -> ホーム）が正しく遷移するか確認
- [ ] エディタ画面の設定パネルが正しく動作するか確認
- [ ] 設定画面の各セクション（General/Site/Membership/Email/Growth/Advanced）へのアクセスを確認
- [ ] ActivityPub画面のオンボーディングフローが完了するか確認
- [ ] Portal画面でのサインアップ -> アカウント管理への遷移を確認
- [ ] コメントUIでの投稿・返信・編集・削除フローを確認
- [ ] No.74 Explore画面、No.77 Pro画面の実際の動作を確認（根拠不足のため）
