# Ghost 画面遷移図

## 概要

Ghostは管理画面（Admin）と公開画面（Public）の2つの主要な画面群で構成されています。

## 1. 管理画面（Admin）全体遷移

```mermaid
flowchart TB
    subgraph Auth["認証"]
        signin[サインイン画面]
        signinVerify[サインイン確認画面]
        signup[サインアップ画面]
        reset[パスワードリセット画面]
    end

    subgraph Setup["セットアップ"]
        setup[セットアップ画面]
        setupDone[セットアップ完了画面]
    end

    subgraph Dashboard["ダッシュボード"]
        home[ホーム画面]
        site[サイト画面]
        whatsnew[What's New画面]
    end

    subgraph Content["コンテンツ管理"]
        posts[投稿一覧画面]
        pages[ページ一覧画面]
        editor[エディタ画面]
        restorePosts[投稿復元画面]
    end

    subgraph Tags["タグ管理"]
        tagList[タグ一覧画面]
        tagEdit[タグ編集画面]
    end

    subgraph Members["メンバー管理"]
        memberList[メンバー一覧画面]
        memberDetail[メンバー詳細画面]
        memberImport[メンバーインポート画面]
        memberActivity[メンバーアクティビティ画面]
    end

    subgraph Analytics["分析"]
        statsOverview[統計概要画面]
        statsWeb[Webトラフィック画面]
        statsGrowth[成長分析画面]
        statsNewsletters[ニュースレター分析画面]
    end

    subgraph PostAnalytics["投稿分析"]
        postOverview[投稿分析概要画面]
        postWeb[投稿Webトラフィック画面]
        postGrowth[投稿成長分析画面]
        postNewsletter[投稿ニュースレター分析画面]
    end

    subgraph Settings["設定"]
        settings[設定画面]
    end

    subgraph ActivityPub["ActivityPub"]
        apReader[リーダー画面]
        apNotes[ノート一覧画面]
        apNotifications[通知画面]
        apExplore[探索画面]
        apProfile[プロフィール画面]
    end

    %% 認証フロー
    signin --> signinVerify
    signin --> home
    signinVerify --> home
    signup --> home
    reset --> signin

    %% セットアップフロー
    setup --> setupDone
    setupDone --> home

    %% ダッシュボードからの遷移
    home --> posts
    home --> pages
    home --> memberList
    home --> statsOverview
    home --> settings
    home --> site
    home --> whatsnew

    %% コンテンツ管理
    posts --> editor
    pages --> editor
    posts --> postOverview
    posts --> restorePosts

    %% タグ管理
    tagList --> tagEdit

    %% メンバー管理
    memberList --> memberDetail
    memberList --> memberImport
    memberList --> memberActivity

    %% 分析
    statsOverview --> statsWeb
    statsOverview --> statsGrowth
    statsOverview --> statsNewsletters

    %% 投稿分析
    postOverview --> postWeb
    postOverview --> postGrowth
    postOverview --> postNewsletter
    postOverview --> memberList

    %% ActivityPub
    apReader --> apNotes
    apNotes --> apNotifications
    apNotes --> apExplore
    apNotes --> apProfile
```

## 2. 設定画面詳細遷移

```mermaid
flowchart TB
    subgraph SettingsMain["設定メイン"]
        settings[設定画面]
    end

    subgraph General["一般設定"]
        titleDesc[タイトルと説明]
        timezone[タイムゾーン]
        language[言語設定]
        users[ユーザー・権限]
        seoMeta[SEOメタデータ]
        socialAccounts[ソーシャルアカウント]
        lockSite[サイトロック]
    end

    subgraph Site["サイト設定"]
        design[デザイン設定]
        theme[テーマ変更]
        navigation[ナビゲーション]
        announcementBar[アナウンスバー]
    end

    subgraph Membership["メンバーシップ設定"]
        access[アクセス設定]
        tiers[ティア設定]
        portal[ポータル設定]
        spamFilters[スパムフィルター]
    end

    subgraph Email["メール設定"]
        enableNewsletters[ニュースレター有効化]
        defaultRecipients[デフォルト受信者]
        newsletters[ニュースレター]
        mailgun[Mailgun設定]
    end

    subgraph Growth["成長設定"]
        network[ネットワーク]
        explore[Explore]
        recommendations[レコメンデーション]
        embedForm[埋め込みフォーム]
        offers[オファー]
        tips[投げ銭・寄付]
    end

    subgraph Advanced["高度な設定"]
        integrations[インテグレーション]
        migration[マイグレーションツール]
        codeInjection[コードインジェクション]
        labs[Labs]
        history[履歴・監査ログ]
        dangerZone[危険ゾーン]
    end

    settings --> titleDesc
    settings --> timezone
    settings --> language
    settings --> users
    settings --> seoMeta
    settings --> socialAccounts
    settings --> lockSite

    settings --> design
    settings --> theme
    settings --> navigation
    settings --> announcementBar

    settings --> access
    settings --> tiers
    settings --> portal
    settings --> spamFilters

    settings --> enableNewsletters
    settings --> defaultRecipients
    settings --> newsletters
    settings --> mailgun

    settings --> network
    settings --> explore
    settings --> recommendations
    settings --> embedForm
    settings --> offers
    settings --> tips

    settings --> integrations
    settings --> migration
    settings --> codeInjection
    settings --> labs
    settings --> history
    settings --> dangerZone
```

## 3. ActivityPub画面詳細遷移

```mermaid
flowchart TB
    subgraph Welcome["オンボーディング"]
        welcome[ウェルカム画面]
        step1[ステップ1]
        step2[ステップ2]
        step3[ステップ3]
    end

    subgraph Main["メイン画面"]
        reader[リーダー画面]
        notes[ノート一覧画面]
        noteDetail[ノート詳細画面]
        notifications[通知画面]
        explore[探索画面]
        exploreWithTopic[トピック別探索]
    end

    subgraph Profile["プロフィール"]
        profile[プロフィール画面]
        profileLikes[いいね一覧]
        profileFollowing[フォロー中]
        profileFollowers[フォロワー]
        otherProfile[他ユーザープロフィール]
    end

    subgraph Preferences["設定"]
        preferences[設定画面]
        moderation[モデレーション設定]
        blueskySharing[Bluesky共有設定]
    end

    welcome --> step1
    step1 --> step2
    step2 --> step3
    step3 --> reader

    reader --> notes
    notes --> noteDetail
    notes --> notifications
    notes --> explore
    explore --> exploreWithTopic

    reader --> profile
    profile --> profileLikes
    profile --> profileFollowing
    profile --> profileFollowers
    notes --> otherProfile

    profile --> preferences
    preferences --> moderation
    preferences --> blueskySharing
```

## 4. 公開画面（Portal）遷移

```mermaid
flowchart TB
    subgraph Auth["認証"]
        signin[サインインページ]
        signup[サインアップページ]
        magiclink[マジックリンクページ]
    end

    subgraph Account["アカウント管理"]
        accountHome[アカウントホームページ]
        accountPlan[プラン選択ページ]
        accountProfile[プロフィール編集ページ]
        accountEmail[メール設定ページ]
        newsletterSelection[ニュースレター選択ページ]
    end

    subgraph Subscription["購読管理"]
        unsubscribe[購読解除ページ]
        offer[オファーページ]
    end

    subgraph Feedback["フィードバック"]
        feedback[フィードバックページ]
    end

    subgraph Support["サポート"]
        support[サポートページ]
        supportSuccess[サポート成功]
        supportError[サポートエラー]
    end

    subgraph Other["その他"]
        recommendations[レコメンデーションページ]
        emailSuppressed[メール停止通知ページ]
        loading[ローディングページ]
    end

    signin --> magiclink
    magiclink --> accountHome
    signup --> magiclink
    signup --> newsletterSelection
    newsletterSelection --> magiclink

    accountHome --> accountPlan
    accountHome --> accountProfile
    accountHome --> accountEmail

    accountEmail --> unsubscribe

    offer --> signup
    offer --> signin

    support --> supportSuccess
    support --> supportError

    accountHome --> recommendations
```

## 5. コメントUI遷移

```mermaid
flowchart TB
    subgraph Main["メイン"]
        commentList[コメント一覧]
        mainForm[コメント投稿フォーム]
    end

    subgraph Interaction["インタラクション"]
        replyForm[返信フォーム]
        editForm[編集フォーム]
    end

    subgraph Popups["ポップアップ"]
        deletePopup[削除確認ポップアップ]
        reportPopup[通報ポップアップ]
        addDetailsPopup[詳細追加ポップアップ]
        ctaPopup[CTA ポップアップ]
    end

    commentList --> mainForm
    mainForm --> commentList

    commentList --> replyForm
    replyForm --> commentList

    commentList --> editForm
    editForm --> commentList

    commentList --> deletePopup
    deletePopup --> commentList

    commentList --> reportPopup
    reportPopup --> commentList

    mainForm --> addDetailsPopup
    addDetailsPopup --> mainForm

    mainForm --> ctaPopup
```

## 6. 検索・アナウンスバー

```mermaid
flowchart TB
    subgraph Search["検索"]
        searchTrigger[検索トリガー]
        searchModal[検索モーダル]
        searchResults[検索結果]
    end

    subgraph Announcement["アナウンスバー"]
        announcementBar[アナウンスバー]
        dismissAction[閉じる]
    end

    searchTrigger --> searchModal
    searchModal --> searchResults
    searchResults --> searchModal

    announcementBar --> dismissAction
```

## 7. エディタ画面遷移

```mermaid
flowchart TB
    subgraph Editor["エディタ"]
        editorMain[エディタメイン画面]
        settingsPanel[設定パネル]
        postHistory[投稿履歴]
    end

    subgraph Publishing["公開"]
        publishFlow[公開フロー]
        scheduleFlow[予約投稿フロー]
        updateFlow[更新フロー]
    end

    subgraph Navigation["ナビゲーション"]
        postsList[投稿一覧]
        pagesList[ページ一覧]
        analytics[投稿分析]
    end

    postsList --> editorMain
    pagesList --> editorMain

    editorMain --> settingsPanel
    settingsPanel --> editorMain

    editorMain --> postHistory
    postHistory --> editorMain

    editorMain --> publishFlow
    editorMain --> scheduleFlow
    editorMain --> updateFlow

    publishFlow --> postsList
    scheduleFlow --> postsList
    updateFlow --> editorMain

    editorMain --> analytics
```

## 技術構成メモ

| 画面グループ | 技術スタック | 備考 |
|------------|------------|------|
| 管理画面（基本） | Ember.js | ghost/admin |
| 設定画面 | React (admin-x-settings) | Ember内にiframeで埋め込み |
| 統計・分析 | React (stats) | apps/stats |
| 投稿分析 | React (posts) | apps/posts |
| ActivityPub | React (activitypub) | apps/activitypub |
| Portal | React (portal) | apps/portal - 公開画面 |
| コメントUI | React (comments-ui) | apps/comments-ui - 公開画面 |
| 検索 | JavaScript (sodo-search) | apps/sodo-search - 公開画面 |
| サインアップフォーム | React (signup-form) | apps/signup-form - 埋め込み用 |
| アナウンスバー | JavaScript (announcement-bar) | apps/announcement-bar - 公開画面 |
