---
generated_at: 2026-01-29 20:30:00
metrics:
  claims_total: 148
  claims_with_evidence: 142
  claims_without_evidence: 6
confidence_derived: 0.96
---

# 根拠レポート：画面機能マッピング

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：142 / 148、根拠なし：6
- 優先レビュー（高）
  1. **Pro画面と制限管理機能の関連**：具体的なコード実装の確認が必要
  2. **履歴・監査ログ機能**：history.tsxの内部実装詳細の確認が必要
  3. **スパムフィルター設定機能**：spam-filters.tsxの内部実装詳細の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧ドキュメント
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧ドキュメント
- E-03: `ghost/admin/app/router.js` - Ember.jsルーター定義
- E-04: `ghost/admin/app/routes/signin.js` - サインインルート
- E-05: `ghost/admin/app/controllers/signin.js` - サインインコントローラー
- E-06: `ghost/admin/app/routes/posts.js` - 投稿一覧ルート
- E-07: `ghost/admin/app/routes/members.js` - メンバー一覧ルート
- E-08: `ghost/admin/app/routes/lexical-editor.js` - エディタルート
- E-09: `apps/portal/src/pages.js` - Portalページ定義
- E-10: `apps/portal/src/components/pages/signin-page.js` - Portalサインインページ
- E-11: `apps/stats/src/routes.tsx` - 統計アプリルート
- E-12: `apps/posts/src/routes.tsx` - 投稿分析アプリルート
- E-13: `apps/activitypub/src/routes.tsx` - ActivityPubアプリルート
- E-14: `apps/comments-ui/src/app.tsx` - コメントUIアプリ
- E-15: `apps/admin-x-settings/src/components/settings/` - 設定画面コンポーネント群

## 3) Claims と根拠の対応（レビューの主戦場）

### 認証系画面
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | サインイン画面は認証機能を主機能として使用 | E-04, E-05 | ○ |
| C-02 | サインイン画面でスタッフ管理機能と連携 | E-05（sessionサービス経由） | ○ |
| C-03 | サインイン確認画面は2段階認証処理を行う | E-05（isTwoFactorTokenRequiredError） | ○ |
| C-04 | サインアップ画面は招待トークンで登録 | E-03（/signup/:token） | ○ |
| C-05 | パスワードリセット画面はトークン検証を行う | E-03（/reset/:token） | ○ |

### コンテンツ管理系画面
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-06 | 投稿一覧画面は記事管理機能を主機能として使用 | E-06（modelName = 'post'） | ○ |
| C-07 | 投稿一覧画面で記事分析機能と連携 | E-06（postAnalytics.loadVisitorCounts） | ○ |
| C-08 | 投稿一覧画面でタグによるフィルタリング | E-06（queryParams.tag） | ○ |
| C-09 | エディタ画面はLexical Editorを使用 | E-08, E-03（lexical-editor） | ○ |
| C-10 | エディタ画面で記事リビジョンを保存 | E-01, E-02（post-revision.js参照） | ○ |

### メンバー管理系画面
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-11 | メンバー一覧画面はメンバー登録機能を使用 | E-07（fetchMembersTask） | ○ |
| C-12 | メンバー一覧画面でラベルフィルタリング | E-07（fetchLabelsTask） | ○ |
| C-13 | メンバー詳細画面でプロフィール編集 | E-01（member.hbs） | ○ |

### Portal系画面
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-14 | PortalサインインページはdoActionでsigninを呼び出し | E-10（doAction('signin'）） | ○ |
| C-15 | Portalページ群はPortalウィジェット内で表示 | E-09, E-10 | ○ |
| C-16 | アカウントホームページでサブスクリプション状態表示 | E-09（AccountHomePage） | ○ |

### 統計・分析系画面
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-17 | 統計画面はサイト統計機能を主機能として使用 | E-11（/analytics） | ○ |
| C-18 | Webトラフィック画面はTinybird連携を使用 | E-11, E-02（Tinybird連携） | ○ |
| C-19 | 投稿分析画面は記事分析機能を使用 | E-12（/posts/analytics/:postId） | ○ |
| C-20 | ニュースレター分析画面はメール分析機能を使用 | E-11（/analytics/newsletters） | ○ |

### コメント系画面
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-21 | コメント一覧は記事コメント機能を使用 | E-14（api.comments.browse） | ○ |
| C-22 | コメント投稿フォームはComments UIで表示 | E-14（ContentBox） | ○ |
| C-23 | 通報ポップアップはコメント報告機能を使用 | E-14, E-01（report-popup.tsx） | ○ |

### ActivityPub系画面
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-24 | ActivityPubリーダー画面はActivityPub機能を使用 | E-13（/reader） | ○ |
| C-25 | ノート一覧画面でノート投稿が可能 | E-13（/notes） | ○ |
| C-26 | 通知画面でActivityPub通知を表示 | E-13（/notifications） | ○ |

### 設定系画面
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-27 | 設定画面は一般設定機能を主機能として使用 | E-15（settings.tsx） | ○ |
| C-28 | ニュースレター設定はニュースレター管理機能を使用 | E-15（newsletters.tsx） | ○ |
| C-29 | インテグレーション設定でWebhook管理が可能 | E-15（webhooks-table.tsx） | ○ |

### 根拠不足の項目
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-30 | Pro画面は制限管理機能と連携 | **根拠なし** | △ |
| C-31 | 履歴・監査ログ画面の具体的な機能実装 | **根拠不足** | △ |
| C-32 | スパムフィルター設定の具体的な処理 | **根拠不足** | △ |
| C-33 | What's New画面の管理者通知機能との連携詳細 | **根拠不足** | △ |
| C-34 | Labs設定の具体的なフラグ管理実装 | **根拠不足** | △ |
| C-35 | 危険ゾーンのデータベース管理機能との連携詳細 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- Pro画面（画面No.77）の具体的な機能実装コードが見つからなかった
  - 候補：ghost/admin/app/routes/pro.js / ghost/core/core/server/services/limits.js
- 履歴・監査ログ機能の詳細実装
  - 候補：apps/admin-x-settings/src/components/settings/advanced/history.tsx / history-modal.tsx
- スパムフィルター設定の詳細実装
  - 候補：apps/admin-x-settings/src/components/settings/advanced/spam-filters.tsx
- What's New画面の通知データ取得元
  - 候補：ghost/core/core/server/services/notifications/
- Labs設定の機能フラグ管理
  - 候補：apps/admin-x-settings/src/components/settings/advanced/labs.tsx

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 認証系・コンテンツ管理系・メンバー管理系の画面機能マッピング
  - コードから明確に機能呼び出しが確認できる
- **0: 低リスク** - Portal系・コメント系・ActivityPub系の画面機能マッピング
  - Reactコンポーネントとルーティングから明確に確認できる
- **1: 中リスク** - 設定系画面の一部機能マッピング
  - 設定画面コンポーネントは多数存在し、一部の内部実装の詳細確認が必要
- **1: 中リスク** - Pro画面・Labs設定などの特殊機能
  - 具体的な実装詳細の確認が推奨される

## 6) レビュアーチェックリスト（最小）
- [ ] 認証系画面（No.1-5）の機能マッピングが正確か確認
- [ ] エディタ画面（No.13）のLexical Editor連携が正しいか確認
- [ ] Portal系画面（No.78-92）のPortal機能との連携が正確か確認
- [ ] コメント系画面（No.93-99）のComments UI連携が正確か確認
- [ ] ActivityPub系画面（No.64-73）のActivityPub機能との連携が正確か確認
- [ ] 設定系画面（No.32-63）の各設定機能との対応が正確か確認
- [ ] 根拠不足（△）の6項目について、追加のコード調査を実施
