# 画面設計書 102-サインアップ成功ページ

## 概要

本ドキュメントは、Ghost CMSの埋め込み用サインアップフォームにおける登録成功ページ（Success Page）の設計を定義するものである。この画面はメール登録が正常に完了した後に表示される確認画面である。

### 本画面の処理概要

サインアップ成功ページは、ユーザーがサインアップフォームでメールアドレスを送信し、マジックリンクメールの送信が完了した後に表示される確認画面である。ユーザーに対してメールの確認を促すメッセージを表示し、次のアクションを案内する。

**業務上の目的・背景**：サインアップフォームでメールアドレスを送信した後、ユーザーは次に何をすべきかを知る必要がある。この画面は、マジックリンクメールが送信されたことを明確に伝え、メールボックスを確認するよう促す役割を持つ。これにより、ユーザーが確認メールを見落とすことを防ぎ、購読完了率を向上させる。また、メールが届かない場合の対処法（スパムフォルダの確認）も案内することで、サポート問い合わせを減らす効果がある。

**画面へのアクセス方法**：この画面は直接アクセスするものではなく、サインアップフォーム（FormPage）でメールアドレス送信が成功した場合に自動的に遷移する。ミニマルモードの場合はこの画面に遷移せず、フォーム内で完了表示が行われる。

**主要な操作・処理内容**：
1. 成功メッセージの表示 - マジックリンクメールが送信されたことを通知
2. メール確認の促進 - ユーザーにメールボックスの確認を促す
3. スパムフォルダ確認の案内 - 3分以内にメールが届かない場合の対処法を表示

**画面遷移**：
- 遷移元: サインアップフォーム（FormPage）- 通常モードで送信成功時
- 遷移先: なし（この画面が終端）

**権限による表示制御**：この画面は公開ウィジェットの一部であり、認証不要。サインアップフォームからの遷移でのみ表示される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 8 | メンバー登録 | 主機能 | 登録完了メッセージの表示 |
| 73 | Signup Form | 補助機能 | 埋め込みフォームUIの表示 |
| 9 | メンバー認証 | API連携 | マジックリンク送信完了の通知 |

## 画面種別

確認・完了（結果表示）

## URL/ルーティング

- 内部ルーティング: `SuccessPage` (アプリケーション内のページ名)
- 外部URL: なし（埋め込みウィジェット内のページ遷移）

## 入出力項目

### 入力項目（Props）

| 項目名 | 項目ID | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| メールアドレス | email | string | 必須 | 登録されたメールアドレス（表示には使用されない） |

### 表示設定（Context経由）

| 項目名 | 項目ID | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| 背景色 | backgroundColor | string | 任意 | 画面の背景色 |
| テキスト色 | textColor | string | 任意 | テキストの色 |

## 表示項目

| 項目名 | 表示条件 | 説明 |
|--------|----------|------|
| メールアイコン | 常時 | 幅32pxのメールアイコンSVG |
| タイトル | 常時 | 「Now check your email!」（i18n対応） |
| 説明文 | 常時 | 確認リンクをクリックするよう案内するメッセージ |

### 表示テキスト（i18n対応）

| テキストID | デフォルト値（英語） | 説明 |
|-----------|---------------------|------|
| title | Now check your email! | ページタイトル |
| description | To complete signup, click the confirmation link in your inbox. If it doesn't arrive within 3 minutes, check your spam folder! | 説明文 |

## イベント仕様

### 1-ページ表示

**トリガー**: FormPageからの遷移（setPage('SuccessPage', {email})）

**処理フロー**:
1. propsからemailを受け取る（表示には使用しない）
2. useAppContext()からoptionsを取得
3. SuccessViewコンポーネントにbackgroundColor、textColorを渡してレンダリング

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| - | - | - | この画面ではデータベース操作は発生しない |

この画面は純粋な表示画面であり、データベースへの読み書きは行わない。

## メッセージ仕様

| メッセージID | 種別 | メッセージ | 表示条件 |
|-------------|------|-----------|----------|
| MSG-001 | 情報 | Now check your email! | 常時表示（タイトル） |
| MSG-002 | 情報 | To complete signup, click the confirmation link in your inbox. If it doesn't arrive within 3 minutes, check your spam folder! | 常時表示（説明文） |

## 例外処理

| 例外状況 | 処理内容 | 表示メッセージ |
|---------|---------|---------------|
| - | - | この画面では例外処理は発生しない |

この画面は単純な表示のみを行うため、例外処理は実装されていない。エラーハンドリングはFormPage側で完了している。

## 備考

- この画面は通常モードのサインアップフォームでのみ使用される
- ミニマルモード（titleが設定されていない場合）では、FormPage内で「Email sent」と表示され、この画面には遷移しない
- propsで渡されるemailは将来の拡張のために用意されているが、現在のSuccessViewでは使用されていない
- i18n対応により、data-localeで指定した言語でメッセージが表示される
- 背景色・テキスト色はサインアップフォームの設定（data属性）から継承される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

成功ページに渡されるデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | pages.tsx | `apps/signup-form/src/pages.tsx` | PageTypes型定義でSuccessPageのpropsがemail: stringであることを確認 |
| 1-2 | app-context.ts | `apps/signup-form/src/app-context.ts` | SignupFormOptionsでbackgroundColor, textColorの型を確認 |

**読解のコツ**: TypeScriptの型定義から、コンポーネント間のデータ受け渡しを把握する。SuccessPageはemail propsを受け取り、コンテキストからオプションを取得する。

#### Step 2: エントリーポイントを理解する

成功ページへの遷移元を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | form-page.tsx | `apps/signup-form/src/components/pages/form-page.tsx` | 32-34行目でsetPage('SuccessPage', {email})を呼び出している箇所を確認 |
| 2-2 | App.tsx | `apps/signup-form/src/App.tsx` | 43行目でpages[page.name]から動的にページコンポーネントを取得 |

**主要処理フロー**:
1. **32-34行目 (form-page.tsx)**: ミニマルモードでない場合、setPageでSuccessPageに遷移
2. **43-45行目 (App.tsx)**: pageステートに基づいてPageComponentを決定しレンダリング

#### Step 3: 成功ページコンポーネントを理解する

成功ページのロジックとUIを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | success-page.tsx | `apps/signup-form/src/components/pages/success-page.tsx` | ページコンポーネント。コンテキストからオプションを取得しViewに渡す |
| 3-2 | success-view.tsx | `apps/signup-form/src/components/pages/success-view.tsx` | UIコンポーネント。メールアイコン、タイトル、説明文を表示 |

**主要処理フロー**:
- **9-16行目 (success-page.tsx)**: useAppContext()からoptionsを取得し、SuccessViewに色設定を渡す
- **9-21行目 (success-view.tsx)**: 背景色・テキスト色を適用し、アイコン・タイトル・説明文を表示

### プログラム呼び出し階層図

```
FormPage (form-page.tsx)
    |
    +-- submit() 成功時
            |
            +-- setPage('SuccessPage', {email})
                    |
                    v
App.tsx
    |
    +-- pages[page.name] = SuccessPage
            |
            v
SuccessPage (success-page.tsx)
    |
    +-- useAppContext() --> options
    |
    +-- SuccessView (success-view.tsx)
            |
            +-- EmailIcon (SVG)
            +-- h1 タイトル
            +-- p 説明文
```

### データフロー図

```
[入力]                           [処理]                              [出力]

FormPage.email ──────────▶ setPage('SuccessPage', {email}) ──▶ page.data.email
                                    |
                                    v
                              App.tsx (ルーティング)
                                    |
                                    v
                              SuccessPage
                                    |
options.backgroundColor ────▶ useAppContext() ──────────────▶ SuccessView
options.textColor                   |
                                    v
                              背景色・テキスト色を適用した
                              確認メッセージ画面
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| success-page.tsx | `apps/signup-form/src/components/pages/success-page.tsx` | ソース | 成功ページのロジックコンポーネント |
| success-view.tsx | `apps/signup-form/src/components/pages/success-view.tsx` | ソース | 成功ページのUIコンポーネント |
| form-page.tsx | `apps/signup-form/src/components/pages/form-page.tsx` | ソース | 遷移元のフォームページ |
| App.tsx | `apps/signup-form/src/App.tsx` | ソース | ページルーティング |
| pages.tsx | `apps/signup-form/src/pages.tsx` | ソース | ページ定義・型定義 |
| app-context.ts | `apps/signup-form/src/app-context.ts` | ソース | アプリケーションコンテキスト |
| email.svg | `apps/signup-form/assets/icons/email.svg` | アセット | メールアイコン |
