# 画面設計書 105-デザインサンドボックス

## 概要

本ドキュメントは、Ghost CMS管理画面（Ghost Admin）のデザインサンドボックス画面の設計を定義するものである。この画面はUIコンポーネントのテスト・プレビュー用の開発者向けツールである。

### 本画面の処理概要

デザインサンドボックスは、Ghost Adminで使用されるUIコンポーネントを一覧表示し、開発者がコンポーネントの外観や動作を確認できる画面である。ボタン、リスト、セクション、設定エリアなど、管理画面で使用される主要なUIパターンが表示される。

**業務上の目的・背景**：Ghost Admin の開発において、UIコンポーネントの一貫性を保ち、新しいコンポーネントの開発やスタイルの調整を効率的に行うために、コンポーネントを一覧できるサンドボックス環境が必要である。これにより、開発者は実際のページコンテキストに依存せずにコンポーネントの見た目と動作を確認でき、デザインシステムの管理が容易になる。また、新機能開発時のUIの参照先としても活用される。

**画面へのアクセス方法**：この画面は開発者実験機能（Developer Experiments）が有効な場合のみアクセス可能である。URLは`/ghost/designsandbox`。enableDeveloperExperimentsが無効の場合は、ホーム画面にリダイレクトされる。

**主要な操作・処理内容**：
1. 開発者機能有効チェック - enableDeveloperExperimentsの確認
2. サンプルデータ取得 - 最新の投稿を1件取得（コンポーネントサンプル用）
3. コンポーネント一覧表示 - 各種UIコンポーネントのサンプルを表示

**画面遷移**：
- 遷移元: URLの直接入力、または開発者向けメニュー（存在する場合）
- 遷移先:
  - enableDeveloperExperimentsが無効の場合はホーム画面へリダイレクト
  - その他の特定の遷移先なし

**権限による表示制御**：この画面は開発者実験機能が有効な場合のみアクセス可能。設定はconfig.enableDeveloperExperimentsで制御される。通常のユーザーはこの画面にアクセスできない。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 81 | Shade | 主機能 | UIコンポーネントのテスト・プレビュー |
| 1 | 記事管理 | 補助機能 | サンプル投稿データの取得 |

## 画面種別

開発者ツール（コンポーネントカタログ）

## URL/ルーティング

- ルート定義: `designsandbox`
- URL: `/ghost/designsandbox`

## 入出力項目

### 入力項目（なし）

この画面はユーザー入力を受け付けない。

### モデルデータ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| model | Post | 最新の公開済み投稿（コンポーネントサンプル用） |

## 表示項目

### セクション構成

| セクション名 | 説明 |
|-------------|------|
| Post bookmark | GhPostBookmarkコンポーネントのサンプル |
| Buttons | 各種ボタンスタイルのサンプル |
| Lists | リスト表示のサンプル |
| Sections | セクションレイアウトのサンプル |
| Setting area | 設定エリア（展開可能ブロック）のサンプル |

### Buttonsセクション

| コンポーネント | クラス名 | 説明 |
|--------------|---------|------|
| Primary button | gh-btn gh-btn-primary | プライマリボタン |
| Regular button | gh-btn | 通常ボタン |
| Blue button | gh-btn gh-btn-blue | 青色ボタン |
| Green button | gh-btn gh-btn-green | 緑色ボタン |
| Red button | gh-btn gh-btn-red | 赤色ボタン |
| Outline button | gh-btn gh-btn-outline | アウトラインボタン |
| Large button | gh-btn gh-btn-primary gh-btn-large | 大きいプライマリボタン |

### Listsセクション

| 要素 | クラス名 | 説明 |
|-----|---------|------|
| リストコンテナ | gh-list | リスト全体のコンテナ |
| ヘッダー行 | gh-list-row header | ヘッダー行 |
| ヘッダーセル | gh-list-header | ヘッダーセル |
| データ行 | gh-list-row | データ行 |
| データセル | gh-list-data | データセル |

### Sectionsセクション

| レイアウト | クラス名 | 説明 |
|----------|---------|------|
| Single column | gh-main-section-content | 単一カラムレイアウト |
| Two columns | gh-main-section-content columns-2 | 2カラムレイアウト |
| Side by side blocks | gh-main-section columns-2 | 横並びブロック |

### Setting areaセクション

| 要素 | クラス名 | 説明 |
|-----|---------|------|
| 設定コンテナ | gh-expandable | 展開可能設定コンテナ |
| 設定ブロック | gh-expandable-block | 個別設定ブロック |
| ヘッダー | gh-expandable-header | ブロックヘッダー |
| タイトル | gh-expandable-title | 設定タイトル |
| 説明 | gh-expandable-description | 設定説明 |

## イベント仕様

### 1-ルートアクセス（beforeModel）

**トリガー**: designsandboxルートへのアクセス

**処理フロー**:
1. `this.config.enableDeveloperExperiments`を確認
2. falseの場合、`this.transitionTo('home')`でホーム画面へリダイレクト
3. trueの場合、処理を続行

### 2-モデル取得（model）

**トリガー**: beforeModelの後

**処理フロー**:
1. `this.store.queryRecord('post', {limit: 1, order: 'published_at DESC'})`を実行
2. 最新の公開済み投稿を1件取得
3. 取得した投稿をモデルとして返す
4. GhPostBookmarkコンポーネントのサンプル表示に使用

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| モデル取得 | posts | SELECT | 最新投稿の取得（読み取りのみ） |

### テーブル別更新項目詳細

#### posts（読み取りのみ）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | ORDER BY published_at DESC LIMIT 1 | 最新の公開済み投稿を取得 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ | 表示条件 |
|-------------|------|-----------|----------|
| - | - | - | この画面ではメッセージは表示されない |

## 例外処理

| 例外状況 | 処理内容 | 表示メッセージ |
|---------|---------|---------------|
| 開発者機能が無効 | ホーム画面へリダイレクト | なし |
| 投稿が存在しない | GhPostBookmarkは空で表示 | なし |

## 備考

- この画面は開発者向けの機能であり、本番環境では通常無効化されている
- enableDeveloperExperimentsは`ghost/core/config.development.json`等で設定される
- コンポーネントはプレースホルダーテキスト（"Data", "Title", "Description"等）を使用
- 実際の投稿データはGhPostBookmarkコンポーネントのデモンストレーションにのみ使用
- CSSクラス名はGhost Adminのデザインシステムに基づいている

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: ルーティングを理解する

designsandboxルートの定義を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | router.js | `ghost/admin/app/router.js` | 93行目でdesignsandboxルートが定義されていることを確認 |

**読解のコツ**: Ember.jsのルーター定義で、シンプルなルート定義である。特にパスオプションがないため、ルート名がそのままURLパスになる。

#### Step 2: ルートクラスを理解する

DesignsandboxRouteの実装を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | designsandbox.js | `ghost/admin/app/routes/designsandbox.js` | beforeModel, modelの各メソッド |

**主要処理フロー**:
- **6行目**: storeサービスの注入
- **8行目**: configの注入
- **10-15行目**: beforeModelで開発者機能の有効チェック
- **17-19行目**: modelで最新投稿を取得

#### Step 3: テンプレートを理解する

designsandbox.hbsテンプレートの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | designsandbox.hbs | `ghost/admin/app/templates/designsandbox.hbs` | 各セクションの構造とCSSクラス |

**主要処理フロー**:
- **1-6行目**: GhCanvasHeaderでページタイトル表示
- **8-11行目**: GhPostBookmarkコンポーネントのサンプル
- **12-21行目**: Buttonsセクション
- **23-64行目**: Listsセクション
- **66-96行目**: Sectionsセクション
- **98-134行目**: Setting areaセクション

### プログラム呼び出し階層図

```
router.js (route定義)
    |
    +-- this.route('designsandbox')
            |
            v
DesignsandboxRoute (designsandbox.js)
    |
    +-- @service store
    +-- @inject config
    |
    +-- beforeModel()
    |       |
    |       +-- [enableDeveloperExperiments=false]
    |       |       |
    |       |       +── transitionTo('home')
    |       |
    |       +-- [enableDeveloperExperiments=true]
    |               |
    |               +── 続行
    |
    +-- model()
            |
            +-- store.queryRecord('post', {...})
                    |
                    v
designsandbox.hbs (テンプレート)
    |
    +-- GhCanvasHeader
    +-- GhPostBookmark (@post=this.model)
    +-- Buttons section
    +-- Lists section
    +-- Sections section
    +-- Setting area section
```

### データフロー図

```
[入力]                           [処理]                              [出力]

/ghost/designsandbox ─────▶ router.js ─────────────────────▶ designsandboxルート
                                |
                                v
                          DesignsandboxRoute.beforeModel()
                                |
                                +── [enableDeveloperExperiments判定]
                                |       |
                                |       +─[false]─▶ homeへリダイレクト
                                |       |
                                |       +─[true]──▶ 続行
                                |
                                v
                          DesignsandboxRoute.model()
                                |
                                +── store.queryRecord('post')
                                        |
                                        v
                          最新投稿（model）
                                |
                                v
                          designsandbox.hbs
                                |
                                +── GhPostBookmark (model使用)
                                +── 静的UIコンポーネントサンプル
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| router.js | `ghost/admin/app/router.js` | ソース | ルート定義（93行目にdesignsandbox） |
| designsandbox.js | `ghost/admin/app/routes/designsandbox.js` | ソース | Designsandboxルートクラス |
| designsandbox.hbs | `ghost/admin/app/templates/designsandbox.hbs` | テンプレート | コンポーネントカタログテンプレート |
| gh-post-bookmark | `ghost/admin/app/components/gh-post-bookmark/` | コンポーネント | 投稿ブックマークコンポーネント |
| gh-canvas-header | `ghost/admin/app/components/gh-canvas-header.hbs` | コンポーネント | ページヘッダーコンポーネント |
