# 画面設計書 22-統計概要画面

## 概要

Ghost管理画面の統計機能における概要（Overview）画面の設計書である。サイト全体の主要KPIをダッシュボード形式で表示し、訪問者数・メンバー数・MRRの推移、最新投稿のパフォーマンス、人気投稿ランキングを一覧できる。

### 本画面の処理概要

統計概要画面は、Ghostサイトの運営状況を俯瞰的に把握するための主要ダッシュボードである。

**業務上の目的・背景**：サイト運営者がログイン後すぐにサイトの健全性と成長状況を把握できるよう、最も重要な指標を集約して表示する。訪問者トレンド、メンバー成長、収益状況という3つの軸でサイトパフォーマンスを可視化し、詳細分析への導線を提供する。

**画面へのアクセス方法**：統計（Analytics）画面のデフォルト表示として、`/analytics` にアクセスすると本画面が表示される。サイドバーの「Analytics」リンクをクリックした際の初期表示画面となる。

**主要な操作・処理内容**：
1. 日付範囲セレクターで表示期間を変更（過去7日/30日/90日/全期間など）
2. 訪問者数・メンバー数・MRRの推移チャートを確認
3. 最新投稿のパフォーマンス（訪問者数、開封率など）を確認
4. 人気投稿トップ5の一覧を確認
5. 個別投稿をクリックして投稿分析画面へ遷移
6. 「Grow your audience」セクションのヘルプリンクから外部ドキュメントへアクセス

**画面遷移**：
- 遷移元：統計（Analytics）画面、サイドバーナビゲーション
- 遷移先：投稿分析概要画面（/posts/analytics/:postId）、外部ヘルプドキュメント（ghost.org/help）

**権限による表示制御**：有料メンバーシップ機能（paidMembersEnabled）が無効の場合、MRR関連のKPIやチャートは非表示となる。Webアナリティクスが無効の場合、訪問者数セクションの表示が制限される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 51 | サイト統計 | 主機能 | 統計のオーバービュー・主要KPI表示 |
| 52 | 記事分析 | 補助機能 | 人気記事のサマリー表示 |
| 55 | Tinybird連携 | 補助機能 | Tinybirdからのアナリティクスデータ取得 |

## 画面種別

ダッシュボード / 概要

## URL/ルーティング

| パス | コンポーネント | 説明 |
|------|---------------|------|
| `/analytics` | Overview | 統計概要画面（インデックスルート） |

## 入出力項目

### 入力項目

| 項目名 | 項目ID | データ型 | 必須 | 説明 |
|--------|--------|----------|------|------|
| 日付範囲 | range | number | Yes | 統計の表示期間（7, 30, 90, -1など） |

### 出力項目

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| 訪問者数 | number | 選択期間内の総訪問者数 |
| 訪問者チャートデータ | array | 日別訪問者数の時系列データ |
| メンバー数 | number | 期間終了時点の総メンバー数 |
| メンバーチャートデータ | array | 日別メンバー数の時系列データ |
| MRR | number | 月間経常収益（セント単位） |
| MRRチャートデータ | array | 日別MRRの時系列データ |
| 最新投稿統計 | object | 最新投稿のパフォーマンスデータ |
| 人気投稿一覧 | array | トップ5人気投稿のリスト |

## 表示項目

### KPIカード

| 項目名 | データ型 | 説明 | 表示条件 |
|--------|----------|------|---------|
| Visitors | number | 総訪問者数 | 常時表示 |
| Members | number | 総メンバー数（無料+有料） | 常時表示 |
| MRR | string | 月間経常収益（通貨記号付き） | paidMembersEnabled時のみ |

### 最新投稿セクション

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| タイトル | string | 投稿タイトル |
| 公開日 | string | 投稿公開日時 |
| 訪問者数 | number | 投稿への訪問者数 |
| 開封率 | number | ニュースレター開封率 |

### 人気投稿セクション

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| タイトル | string | 投稿タイトル |
| 訪問者数 | number | 投稿への訪問者数 |
| 公開日 | string | 投稿公開日時 |

## イベント仕様

### 1-日付範囲変更

**トリガー**: DateRangeSelectコンポーネントで期間を選択

**処理フロー**:
1. setRange関数が新しい期間値で呼び出される
2. GlobalDataContext経由でrangeが更新される
3. 各種データ取得フック（useTinybirdQuery, useGrowthStats等）が再実行
4. チャート・KPIが新しいデータで再描画

**関連コード**: `apps/stats/src/views/Stats/Overview/overview.tsx` 69-108行目

### 2-投稿クリック

**トリガー**: 最新投稿または人気投稿一覧の投稿タイトルをクリック

**処理フロー**:
1. クリックイベントハンドラが発火
2. navigate関数で `/posts/analytics/:postId` に遷移
3. PostAnalyticsアプリが該当投稿のデータをロード

### 3-ヘルプリンククリック

**トリガー**: 「Grow your audience」セクションのカードをクリック

**処理フロー**:
1. 外部リンク（ghost.org）が新しいタブで開く

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | - | SELECT | Tinybird APIからKPIデータを取得 |
| 画面表示 | posts | SELECT | Ghost APIから投稿データを取得 |

### API呼び出し詳細

#### Tinybird API

| エンドポイント | パラメータ | 戻り値 | 用途 |
|---------------|-----------|--------|------|
| api_kpis | site_uuid, date_from, date_to, timezone, member_status | visits, pageviews等の配列 | 訪問者KPI |

#### Ghost API

| エンドポイント | メソッド | 用途 |
|---------------|---------|------|
| /ghost/api/admin/stats/member_count/ | GET | 成長統計データ取得 |
| /ghost/api/admin/posts/ | GET | 最新投稿・人気投稿取得 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| - | 情報 | Understanding analytics in Ghost | ヘルプカード説明文 |
| - | 情報 | How to get your content seen online | ヘルプカード説明文 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| データなし | 各KPIに0を表示、チャートは空表示 |
| API取得失敗 | StatsErrorBoundaryでエラーページ表示 |
| statsConfig未設定 | ローディング状態を継続 |

## 備考

- 訪問者チャートのY軸範囲は動的に計算され、負の値は除外される
- メンバーチャートは無料メンバー＋有料メンバーの合計を表示
- MRRはセント単位で保存されており、表示時にドル変換（centsToDollars）される
- 「today」期間はDateRangeSelectのexcludeRangesで除外されている

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | overview.tsx | `apps/stats/src/views/Stats/Overview/overview.tsx` | WebKpiDataItem, GrowthChartDataItem型定義（50-64行目） |
| 1-2 | global-data-provider.tsx | `apps/stats/src/providers/global-data-provider.tsx` | GlobalData型、useGlobalDataフック |

**読解のコツ**: visitorsChartData, membersChartData, mrrChartDataの各useMemoで、データがどのように加工されているか確認する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | overview.tsx | `apps/stats/src/views/Stats/Overview/overview.tsx` | Overviewコンポーネント全体（66-246行目） |
| 2-2 | routes.tsx | `apps/stats/src/routes.tsx` | indexルートでOverviewを遅延ロード（15-17行目） |

**主要処理フロー**:
1. **68-79行目**: useGlobalData, useGrowthStats, useLatestPostStats, useTopPostsViewsでデータ取得
2. **83-95行目**: Tinybird APIパラメータ構築とuseTinybirdQuery実行
3. **97-126行目**: visitorsChartData計算（sanitizeChartDataでデータ正規化）
4. **131-150行目**: membersChartData計算
5. **155-174行目**: mrrChartData計算
6. **178-192行目**: kpiValues計算（総訪問者数）

#### Step 3: 子コンポーネントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | overview-kpis.tsx | `apps/stats/src/views/Stats/Overview/components/overview-kpis.tsx` | KPIカード表示ロジック |
| 3-2 | latest-post.tsx | `apps/stats/src/views/Stats/Overview/components/latest-post.tsx` | 最新投稿セクション |
| 3-3 | top-posts.tsx | `apps/stats/src/views/Stats/Overview/components/top-posts.tsx` | 人気投稿一覧 |

#### Step 4: カスタムフックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | use-growth-stats.ts | `apps/stats/src/hooks/use-growth-stats.ts` | 成長統計データ取得・加工ロジック |
| 4-2 | use-latest-post-stats.ts | `apps/stats/src/hooks/use-latest-post-stats.ts` | 最新投稿統計取得 |

### プログラム呼び出し階層図

```
Overview (overview.tsx)
    │
    ├─ useGlobalData()
    │      └─ statsConfig, range取得
    │
    ├─ useGrowthStats(range)
    │      └─ chartData, totals, currencySymbol取得
    │
    ├─ useLatestPostStats()
    │      └─ 最新投稿データ取得
    │
    ├─ useTopPostsViews({searchParams})
    │      └─ 人気投稿Top5取得
    │
    ├─ useTinybirdQuery({endpoint: 'api_kpis', ...})
    │      └─ 訪問者KPIデータ取得
    │
    ├─ OverviewKPIs
    │      └─ 訪問者/メンバー/MRRチャート表示
    │
    ├─ LatestPost
    │      └─ 最新投稿カード表示
    │
    ├─ TopPosts
    │      └─ 人気投稿テーブル表示
    │
    └─ HelpCard x 2
           └─ 外部ヘルプリンク
```

### データフロー図

```
[入力]                        [処理]                           [出力]

range (日付範囲) ────────▶ useTinybirdQuery ────────▶ visitorsData
                                  │
                                  ▼
                         sanitizeChartData()
                                  │
                                  ▼
                         visitorsChartData ────────▶ OverviewKPIs
                                                          │
                                                          ▼
                                                    Area Chart表示

range (日付範囲) ────────▶ useGrowthStats ─────────▶ growthChartData
                                  │
                                  ▼
                         sanitizeChartData()
                                  │
                                  ▼
                         membersChartData ─────────▶ OverviewKPIs
                         mrrChartData                     │
                                                          ▼
                                                    Area Chart表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| overview.tsx | `apps/stats/src/views/Stats/Overview/overview.tsx` | ソース | 概要画面メインコンポーネント |
| overview-kpis.tsx | `apps/stats/src/views/Stats/Overview/components/overview-kpis.tsx` | ソース | KPIカード群 |
| latest-post.tsx | `apps/stats/src/views/Stats/Overview/components/latest-post.tsx` | ソース | 最新投稿セクション |
| top-posts.tsx | `apps/stats/src/views/Stats/Overview/components/top-posts.tsx` | ソース | 人気投稿一覧 |
| use-growth-stats.ts | `apps/stats/src/hooks/use-growth-stats.ts` | ソース | 成長統計フック |
| use-latest-post-stats.ts | `apps/stats/src/hooks/use-latest-post-stats.ts` | ソース | 最新投稿統計フック |
| date-range-select.tsx | `apps/stats/src/views/Stats/components/date-range-select.tsx` | ソース | 日付範囲セレクター |
| stats-layout.tsx | `apps/stats/src/views/Stats/layout/stats-layout.tsx` | ソース | 共通レイアウト |
| stats-header.tsx | `apps/stats/src/views/Stats/layout/stats-header.tsx` | ソース | ヘッダー |
| stats-view.tsx | `apps/stats/src/views/Stats/layout/stats-view.tsx` | ソース | ビューラッパー |
