# 画面設計書 27-投稿分析概要画面

## 概要

投稿分析画面のデフォルトビューである概要（Overview）画面の設計書。特定の投稿に対するWebトラフィック、ニュースレター配信パフォーマンス、成長貢献の主要KPIをサマリー形式で表示する。

### 本画面の処理概要

投稿分析概要画面は、個別投稿のパフォーマンスを一目で把握するためのダッシュボードである。

**業務上の目的・背景**：コンテンツ制作者が特定の投稿の成果を素早く確認するための入口となる画面。Webトラフィック（訪問者数・ソース）、ニュースレター配信効果（開封率・クリック率）、成長貢献（メンバー獲得数・MRR）の3軸で投稿パフォーマンスを可視化し、詳細分析への導線を提供する。

**画面へのアクセス方法**：投稿分析画面（/posts/analytics/:postId）にアクセスした際のデフォルト表示。または投稿分析画面内の「Overview」タブをクリック。

**主要な操作・処理内容**：
1. Webトラフィックカード：訪問者数とトップソースを表示、「View more」で詳細Web画面へ
2. ニュースレターカード：開封率・クリック率を表示、「View more」で詳細Newsletter画面へ
3. 成長カード：Free members/Paid members/MRR impactを表示、「View more」で詳細Growth画面へ

**画面遷移**：
- 遷移元：投稿一覧画面、統計画面
- 遷移先：投稿Webトラフィック画面（/posts/analytics/:postId/web）、投稿成長分析画面（/posts/analytics/:postId/growth）、投稿ニュースレター分析画面（/posts/analytics/:postId/newsletter）

**権限による表示制御**：投稿の種別により表示セクションが変わる。email_only投稿の場合はWebセクション非表示。ニュースレター未配信の投稿はNewsletterセクション非表示。webAnalytics無効かつpublished_only投稿の場合はGrowth画面にリダイレクト。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 52 | 記事分析 | 主機能 | 投稿のオーバービュー・主要指標表示 |
| 55 | Tinybird連携 | 補助機能 | Tinybirdからのアナリティクスデータ取得 |

## 画面種別

ダッシュボード / 概要

## URL/ルーティング

| パス | コンポーネント | 説明 |
|------|---------------|------|
| `/posts/analytics/:postId` | Overview | 投稿分析概要画面（インデックスルート） |

## 入出力項目

### 入力項目

| 項目名 | 項目ID | データ型 | 必須 | 説明 |
|--------|--------|----------|------|------|
| 投稿ID | postId | string | Yes | URLパラメータ |

### 出力項目

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| 訪問者数 | number | 投稿公開以降の総訪問者数 |
| 訪問者チャートデータ | array | 日別訪問者数の時系列 |
| トップソース | array | 参照元上位の一覧 |
| 開封率 | number | ニュースレター開封率 |
| クリック率 | number | ニュースレターリンククリック率 |
| 無料メンバー獲得数 | number | この投稿から獲得した無料メンバー |
| 有料メンバー獲得数 | number | この投稿から獲得した有料メンバー |
| MRR impact | number | この投稿からのMRR貢献（セント） |

## 表示項目

### Webセクション

| 項目名 | データ型 | 説明 | 表示条件 |
|--------|----------|------|---------|
| Visitors | number | 訪問者数 | showWebSection |
| visitorsチャート | array | エリアチャート | showWebSection |
| Top sources | array | ソース一覧（最大3件） | showWebSection |

### Newsletterセクション

| 項目名 | データ型 | 説明 | 表示条件 |
|--------|----------|------|---------|
| Open rate | number | 開封率（%） | showNewsletterSection |
| Click rate | number | クリック率（%） | showNewsletterSection |
| Radial charts | - | 放射状チャート | showNewsletterSection |

### Growthセクション

| 項目名 | データ型 | 説明 | 表示条件 |
|--------|----------|------|---------|
| Free members | number | 獲得した無料メンバー数 | 常時表示 |
| Paid members | number | 獲得した有料メンバー数 | paidMembersEnabled |
| MRR impact | string | MRR貢献額（通貨記号付き） | paidMembersEnabled |

## イベント仕様

### 1-Webカード「View more」クリック

**トリガー**: Webセクションの「View more」ボタンをクリック

**処理フロー**:
1. WebOverviewコンポーネント内でボタンクリック
2. navigate関数で `/posts/analytics/:postId/web` に遷移

### 2-Newsletterカード「View more」クリック

**トリガー**: Newsletterセクションの「View more」ボタンをクリック

**処理フロー**:
1. NewsletterOverviewコンポーネント内でボタンクリック
2. navigate関数で `/posts/analytics/:postId/newsletter` に遷移

### 3-Growthカード「View more」クリック

**トリガー**: Growthセクションの「View more」ボタンをクリック

**処理フロー**:
1. Growthセクションの「View more」ボタンクリック
2. navigate関数で `/posts/analytics/:postId/growth` に遷移

**関連コード**: `apps/posts/src/views/PostAnalytics/Overview/overview.tsx` 142-144行目

### 4-webAnalytics無効時のリダイレクト

**トリガー**: 投稿ロード完了後、webAnalytics無効かつpublished_only投稿の場合

**処理フロー**:
1. useEffectで条件判定
2. isPublishedOnly(post)がtrue かつ webAnalytics無効
3. navigate関数で `/posts/analytics/:postId/growth` にリダイレクト

**関連コード**: `apps/posts/src/views/PostAnalytics/Overview/overview.tsx` 99-103行目

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | posts | SELECT | 投稿詳細（Contextから取得済み） |
| 画面表示 | - | SELECT | Tinybird APIからKPI/ソースデータ取得 |
| 画面表示 | members_attribution | SELECT | リファラー統計取得 |

### API呼び出し詳細

#### Tinybird API

| エンドポイント | パラメータ | 用途 |
|---------------|-----------|------|
| api_kpis | site_uuid, post_uuid, date_from, date_to, timezone | KPIチャートデータ |
| api_top_sources | site_uuid, post_uuid, date_from, date_to, timezone | トップソースデータ |

#### Ghost API

| エンドポイント | パラメータ | 用途 |
|---------------|-----------|------|
| /ghost/api/admin/stats/referrers/posts/:postId | - | 成長貢献データ（usePostReferrers） |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| - | - | - | 特記事項なし |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| 投稿ロード中 | BarChartLoadingIndicator表示 |
| webAnalytics無効 + published_only | Growthにリダイレクト |
| statsConfig未設定 | 一部データが表示されない |

## 備考

- チャートの日付範囲は投稿の公開日から自動計算される（getRangeForStartDate）
- hasBeenEmailed関数でニュースレター配信有無を判定
- isPublishedOnly関数でWebのみ公開（メール配信なし）を判定
- Growthセクションは常に表示（col-span-2で横幅いっぱい）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | overview.tsx | `apps/posts/src/views/PostAnalytics/Overview/overview.tsx` | KpiDataItem型、KPI_METRICS参照 |
| 1-2 | kpi-helpers.ts | `apps/posts/src/utils/kpi-helpers.ts` | KpiDataItem型定義 |
| 1-3 | post-analytics-context.tsx | `apps/posts/src/providers/post-analytics-context.tsx` | Post型（useGlobalDataの戻り値） |

**読解のコツ**: useGlobalDataからpost, statsConfig, postId等を取得。usePostReferrersでtotals（成長KPI）を取得。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | overview.tsx | `apps/posts/src/views/PostAnalytics/Overview/overview.tsx` | Overviewコンポーネント全体（17-194行目） |
| 2-2 | routes.tsx | `apps/posts/src/routes.tsx` | ''パスでoverviewを遅延ロード（37-40行目） |

**主要処理フロー**:
1. **18-22行目**: useGlobalData/usePostReferrers/useAppContextでデータ取得
2. **25-31行目**: chartRangeを投稿公開日から計算（getRangeForStartDate）
3. **36-53行目**: paramsを構築（statsConfig.id, post.uuid, date範囲）
4. **55-59行目**: useTinybirdQueryでチャートデータ取得
5. **62-70行目**: totalVisitors計算
6. **73-82行目**: processedChartData作成（sanitizeChartData）
7. **85-89行目**: useTinybirdQueryでsourcesData取得
8. **95-96行目**: showNewsletterSection/showWebSection判定
9. **99-103行目**: webAnalytics無効時リダイレクト

#### Step 3: 子コンポーネントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | web-overview.tsx | `apps/posts/src/views/PostAnalytics/Overview/components/web-overview.tsx` | Webセクション |
| 3-2 | newsletter-overview.tsx | `apps/posts/src/views/PostAnalytics/Overview/components/newsletter-overview.tsx` | Newsletterセクション |

#### Step 4: カスタムフックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | use-post-referrers.ts | `apps/posts/src/hooks/use-post-referrers.ts` | 成長貢献データ（totals: free_members, paid_members, mrr） |

### プログラム呼び出し階層図

```
Overview (overview.tsx)
    │
    ├─ useGlobalData()
    │      └─ statsConfig, post, postId, isPostLoading
    │
    ├─ usePostReferrers(postId)
    │      └─ totals (free_members, paid_members, mrr), currencySymbol
    │
    ├─ useAppContext()
    │      └─ appSettings (paidMembersEnabled, analytics設定)
    │
    ├─ useMemo: chartRange
    │      └─ getRangeForStartDate(post.published_at)
    │
    ├─ useTinybirdQuery({endpoint: 'api_kpis', params})
    │      └─ chartData
    │
    ├─ useMemo: totalVisitors
    │      └─ chartData.reduce(visits)
    │
    ├─ useTinybirdQuery({endpoint: 'api_top_sources', params})
    │      └─ sourcesData
    │
    ├─ WebOverview (showWebSection時)
    │      └─ visitors, chartData, sourcesData表示
    │
    ├─ NewsletterOverview (showNewsletterSection時)
    │      └─ post.email, open_rate, click_rate表示
    │
    └─ Growth Card
           └─ free_members, paid_members, mrr表示
```

### データフロー図

```
[入力]                        [処理]                           [出力]

postId (Context) ─────────▶ useTinybirdQuery ───────▶ chartData
post.uuid                         │
post.published_at ───────▶ getRangeForStartDate ───▶ chartRange
                                  │
                                  ▼
                        processedChartData
                                  │
                                  ▼
                        WebOverview -> Area Chart

postId ──────────────────▶ usePostReferrers ────────▶ totals
                                  │
                                  ▼
                        Growth Card -> KPI Cards

post.email ──────────────▶ Newsletter計算 ──────────▶ NewsletterOverview
                                  │
                                  ▼
                        Radial Charts
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| overview.tsx | `apps/posts/src/views/PostAnalytics/Overview/overview.tsx` | ソース | 概要画面メイン |
| web-overview.tsx | `apps/posts/src/views/PostAnalytics/Overview/components/web-overview.tsx` | ソース | Webセクション |
| newsletter-overview.tsx | `apps/posts/src/views/PostAnalytics/Overview/components/newsletter-overview.tsx` | ソース | Newsletterセクション |
| kpi-card.tsx | `apps/posts/src/views/PostAnalytics/components/kpi-card.tsx` | ソース | KPIカードコンポーネント |
| post-analytics-header.tsx | `apps/posts/src/views/PostAnalytics/components/post-analytics-header.tsx` | ソース | ヘッダー |
| post-analytics-content.tsx | `apps/posts/src/views/PostAnalytics/components/post-analytics-content.tsx` | ソース | コンテンツエリア |
| use-post-referrers.ts | `apps/posts/src/hooks/use-post-referrers.ts` | ソース | リファラーフック |
| kpi-helpers.ts | `apps/posts/src/utils/kpi-helpers.ts` | ソース | KPIヘルパー |
