# 画面設計書 29-投稿成長分析画面

## 概要

投稿分析画面のGrowthタブにおける詳細成長分析画面の設計書。特定の投稿がメンバー獲得にどれだけ貢献したかを分析し、無料メンバー/有料メンバー/MRRへの影響と、その流入経路（ソース）を可視化する。

### 本画面の処理概要

投稿成長分析画面は、個別投稿のメンバーシップビジネスへの貢献度を詳細に分析するための専門画面である。

**業務上の目的・背景**：コンテンツ制作者が特定の投稿がどれだけメンバー獲得・収益に貢献したかを把握するために使用する。どのソース（流入経路）からのメンバー獲得が多いかを分析し、コンテンツ配信戦略やマーケティング施策の効果測定に活用できる。

**画面へのアクセス方法**：投稿分析画面内の「Growth」タブをクリック、または直接 `/posts/analytics/:postId/growth` にアクセスする。

**主要な操作・処理内容**：
1. Free members/Paid members/MRR impactのKPIカード表示
2. 「View members」ボタンクリックで該当メンバー一覧画面へ遷移
3. Top sources（流入経路）一覧の確認

**画面遷移**：
- 遷移元：投稿分析概要画面（/posts/analytics/:postId）
- 遷移先：メンバー一覧画面（/members?filterParam=...）

**権限による表示制御**：有料メンバーシップ機能（paidMembersEnabled）が無効の場合、Paid members/MRR impactのカードは非表示。テーブルの列数とレイアウトも変更される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 52 | 記事分析 | 主機能 | 投稿からのメンバー獲得分析 |
| 92 | メンバー属性 | 補助機能 | 投稿経由の獲得経路分析 |

## 画面種別

ダッシュボード / 分析

## URL/ルーティング

| パス | コンポーネント | 説明 |
|------|---------------|------|
| `/posts/analytics/:postId/growth` | Growth | 投稿成長分析画面 |

## 入出力項目

### 入力項目

| 項目名 | 項目ID | データ型 | 必須 | 説明 |
|--------|--------|----------|------|------|
| 投稿ID | postId | string | Yes | URLパラメータ |

### 出力項目

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| 無料メンバー獲得数 | number | この投稿から獲得した無料メンバー数 |
| 有料メンバー獲得数 | number | この投稿から獲得した有料メンバー数 |
| MRR impact | number | この投稿からのMRR貢献額（セント） |
| トップソース | array | 獲得経路別のデータ |

## 表示項目

### KPIカード

| 項目名 | アイコン | 説明 | 表示条件 |
|--------|---------|------|---------|
| Free members | User | 無料メンバー獲得数 | 常時表示 |
| Paid members | WalletCards | 有料メンバー獲得数 | paidMembersEnabled |
| MRR | Coins | MRR貢献額（通貨記号付き） | paidMembersEnabled |

### トップソーステーブル

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| source | string | 流入経路名 |
| free_members | number | 無料メンバー獲得数 |
| paid_members | number | 有料メンバー獲得数 |
| mrr | number | MRR貢献額 |

## イベント仕様

### 1-Free members「View members」クリック

**トリガー**: Free members KPIカードの「View members」ボタンをクリック

**処理フロー**:
1. KpiCardMoreButtonのonClickが発火
2. filterParamを構築（`signup:'${postId}'+conversion:-'${postId}'`）
3. navigate関数で `/members?filterParam=...` に遷移（crossApp: true）

**関連コード**: `apps/posts/src/views/PostAnalytics/Growth/growth.tsx` 75-78行目

### 2-Paid members「View members」クリック

**トリガー**: Paid members KPIカードの「View members」ボタンをクリック

**処理フロー**:
1. KpiCardMoreButtonのonClickが発火
2. filterParamを構築（`conversion:'${postId}'`）
3. navigate関数で `/members?filterParam=...` に遷移（crossApp: true）

**関連コード**: `apps/posts/src/views/PostAnalytics/Growth/growth.tsx` 95-98行目

### 3-KPIラベルクリック

**トリガー**: KPIカードのラベル部分をクリック

**処理フロー**:
1. KpiCardLabelのonClickが発火
2. 対応するfilterParamで/membersに遷移

**関連コード**: `apps/posts/src/views/PostAnalytics/Growth/growth.tsx` 81-84行目, 101-104行目

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | members_attribution | SELECT | 投稿リファラー統計取得 |

### API呼び出し詳細

#### Ghost API

| エンドポイント | パラメータ | 用途 |
|---------------|-----------|------|
| /ghost/api/admin/stats/referrers/posts/:postId | - | 投稿リファラー取得（usePostReferrers） |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| - | 説明 | Where did your growth come from? | トップソースカード説明文 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| ローディング中 | Skeleton表示（KPIカード、テーブル） |
| データなし | 0を表示 |

## 備考

- centsToDollars関数でMRRをセントからドルに変換
- currencySymbolはusePostReferrersから取得
- paidMembersEnabled無効時はコンテナクラスが変更される（grid-cols-1）
- filterParamはencodeURIComponentでエンコードされる

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | growth.tsx | `apps/posts/src/views/PostAnalytics/Growth/growth.tsx` | centsToDollars関数（12-14行目） |
| 1-2 | use-post-referrers.ts | `apps/posts/src/hooks/use-post-referrers.ts` | stats, totals, currencySymbolの取得 |

**読解のコツ**: totalsオブジェクトにfree_members, paid_members, mrrが含まれる。statsが流入経路別データ配列。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | growth.tsx | `apps/posts/src/views/PostAnalytics/Growth/growth.tsx` | Growthコンポーネント全体（19-141行目） |
| 2-2 | routes.tsx | `apps/posts/src/routes.tsx` | /growthルート定義（45-48行目） |

**主要処理フロー**:
1. **20行目**: useGlobalDataでglobalData取得
2. **21行目**: useParamsでpostId取得
3. **22行目**: usePostReferrersでstats/totals/isLoading/currencySymbol取得
4. **23行目**: useAppContextでappSettings取得
5. **24行目**: useNavigate取得
6. **27-28行目**: siteUrl/siteIconをglobalDataから取得
7. **30-35行目**: paidMembersEnabledによるレイアウトクラス切り替え
8. **41-65行目**: ローディング時のSkeleton表示
9. **66-135行目**: データ表示（KPIカード、GrowthSources）

#### Step 3: 子コンポーネントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | kpi-card.tsx | `apps/posts/src/views/PostAnalytics/components/kpi-card.tsx` | KpiCard系コンポーネント |
| 3-2 | growth-sources.tsx | `apps/posts/src/views/PostAnalytics/Growth/components/growth-sources.tsx` | トップソーステーブル |

#### Step 4: カスタムフックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | use-post-referrers.ts | `apps/posts/src/hooks/use-post-referrers.ts` | 投稿リファラーデータ取得 |

### プログラム呼び出し階層図

```
Growth (growth.tsx)
    │
    ├─ useGlobalData()
    │      └─ globalData (url, icon)
    │
    ├─ useParams()
    │      └─ postId
    │
    ├─ usePostReferrers(postId)
    │      └─ stats (流入経路別), totals (free/paid/mrr), isLoading, currencySymbol
    │
    ├─ useAppContext()
    │      └─ appSettings (paidMembersEnabled)
    │
    ├─ useNavigate()
    │      └─ navigate関数
    │
    ├─ KpiCard x 3 (Free/Paid/MRR)
    │      ├─ KpiCardMoreButton -> navigate('/members?filterParam=...')
    │      ├─ KpiCardLabel -> navigate('/members?filterParam=...')
    │      └─ KpiCardValue
    │
    └─ GrowthSources
           └─ 流入経路別テーブル表示
```

### データフロー図

```
[入力]                        [処理]                           [出力]

postId (URLパラメータ) ────▶ usePostReferrers ────────▶ stats (流入経路別)
                                    │                    totals (合計KPI)
                                    │                    currencySymbol
                                    ▼
                            KpiCard x 3
                                    │
                                    ▼
                            Free/Paid/MRR表示

stats ─────────────────────▶ GrowthSources ───────────▶ テーブル表示

「View members」クリック ────▶ filterParam構築 ─────────▶ navigate('/members')
                                    │
                            encodeURIComponent
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| growth.tsx | `apps/posts/src/views/PostAnalytics/Growth/growth.tsx` | ソース | 成長分析画面メイン |
| growth-sources.tsx | `apps/posts/src/views/PostAnalytics/Growth/components/growth-sources.tsx` | ソース | トップソーステーブル |
| kpi-card.tsx | `apps/posts/src/views/PostAnalytics/components/kpi-card.tsx` | ソース | KPIカードコンポーネント |
| post-analytics-header.tsx | `apps/posts/src/views/PostAnalytics/components/post-analytics-header.tsx` | ソース | ヘッダー |
| post-analytics-content.tsx | `apps/posts/src/views/PostAnalytics/components/post-analytics-content.tsx` | ソース | コンテンツエリア |
| use-post-referrers.ts | `apps/posts/src/hooks/use-post-referrers.ts` | ソース | リファラーフック |
| source-icon.tsx | `apps/posts/src/views/PostAnalytics/components/source-icon.tsx` | ソース | ソースアイコン |
