# 画面設計書 32-設定画面

## 概要

本ドキュメントは、Ghost管理画面の設定画面（Settings）の設計内容を記載した画面設計書です。この画面は、React（admin-x-settings）で構築された包括的な設定管理画面であり、サイト全体の各種設定項目にアクセスするためのメインハブとして機能します。

### 本画面の処理概要

この画面では、Ghostサイトの全設定項目を一元的に管理・変更することができます。

**業務上の目的・背景**：Ghostサイト運営において、サイトの基本情報、デザイン、メンバーシップ、メール配信、成長施策、高度な設定など、多岐にわたる設定項目を一箇所で管理する必要があります。この画面は各設定カテゴリへのアクセスポイントとして、効率的なサイト管理を実現します。従来のEmber.js管理画面からReactへの移行の一環として、admin-x-settingsアプリケーションとして再構築されています。

**画面へのアクセス方法**：
- サイドバーメニューから「Settings」をクリック
- URL直接アクセス: `/ghost/settings`
- ダッシュボードや他の画面からの設定リンク

**主要な操作・処理内容**：
1. 設定カテゴリの閲覧：6つの主要カテゴリ（General, Site, Membership, Email, Growth, Advanced）に分類された設定項目を確認
2. 個別設定項目へのアクセス：各設定項目をクリックしてモーダルまたは詳細画面を表示
3. 設定検索：キーワード検索により目的の設定項目を素早く見つける
4. 設定の保存：各設定項目の変更を保存

**画面遷移**：
- 遷移元：ダッシュボード、サイドバーメニュー、各管理画面のヘッダーリンク
- 遷移先：各設定項目の詳細モーダル（TierDetailModal, UserDetailModal, NewsletterDetailModal等）

**権限による表示制御**：Adminまたはそれ以上の権限を持つスタッフユーザーのみアクセス可能。一部の設定項目はOwnerのみ編集可能（例：危険ゾーン）。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 35 | 一般設定 | 主機能 | サイト設定の総合管理画面 |

## 画面種別

設定ハブ（カテゴリ別設定一覧）

## URL/ルーティング

| URL パターン | 説明 |
|-------------|------|
| `/ghost/settings` | 設定画面メイン |
| `/ghost/settings/*` | 各設定項目のサブルート |

## 入出力項目

### 入力項目（設定検索）

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| 検索キーワード | String | No | 設定項目を検索するためのキーワード |

### 出力項目（設定カテゴリ）

本画面は6つの主要設定カテゴリを表示します。

## 表示項目

### 設定カテゴリ構成

| カテゴリ | コンポーネント | 含まれる設定項目 |
|---------|--------------|-----------------|
| General settings | GeneralSettings | Title and description, Time zone, Publication language, Users, Metadata, Social accounts, Analytics, Lock site |
| Site | SiteSettings | Design, Theme, Navigation, Announcement bar |
| Membership | MembershipSettings | Access, Spam filters, Tiers, Portal, Member emails*, Tips and donations** |
| Email newsletter | EmailSettings | Enable newsletters, Default recipients, Newsletters, Mailgun*** |
| Growth | GrowthSettings | Network, Explore, Recommendations, Embed signup form, Offers** |
| Advanced | AdvancedSettings | Integrations, Migration tools, Code injection, Labs, History, Danger zone |

*: welcomeEmailsフィーチャーフラグ有効時のみ表示
**: Stripe連携有効時のみ表示
***: Mailgun未設定時のみ表示

### 検索キーワード対応

各設定項目には検索用キーワードが設定されており、ユーザーは目的の設定を素早く見つけることができます。

| 設定項目 | 検索キーワード例 |
|---------|-----------------|
| Title and description | title, description, site title |
| Time zone | time, date, timezone |
| Users | users, permissions, roles, staff, invite |
| Metadata | metadata, SEO, google, meta data |
| Theme | theme, template, upload |
| Navigation | navigation, menus, links |
| Tiers | tiers, payment, paid, stripe |
| Newsletters | newsletters, emails, design |
| Integrations | integrations, zapier, slack, unsplash |

## イベント仕様

### 1-設定項目クリック

**トリガー**: 各設定項目（Setting Item）をクリック

**処理内容**:
- SettingsRouterが対応するモーダルを特定
- NiceModalを使用してモーダルを表示
- URLがサブルートに更新（例: `/ghost/settings/staff/invite`）

**主要モーダルパス**:
| パス | モーダル名 |
|-----|----------|
| design/change-theme | DesignAndThemeModal |
| navigation/edit | NavigationModal |
| staff/invite | InviteUserModal |
| staff/:slug | UserDetailModal |
| portal/edit | PortalModal |
| tiers/add | TierDetailModal |
| newsletters/:id | NewsletterDetailModal |
| integrations/zapier | ZapierModal |
| recommendations/add | AddRecommendationModal |

### 2-設定検索

**トリガー**: 検索入力フィールドへのキー入力

**処理内容**:
- 入力キーワードと各設定項目のsearchKeywordsを照合
- マッチする設定項目をハイライト表示
- マッチしない項目は非表示またはグレーアウト

### 3-設定セクションへのスクロール

**トリガー**: URLルート変更、またはナビゲーションリンククリック

**処理内容**:
- useScrollSectionContextでセクション位置を特定
- scrollToSection関数で該当セクションまでスムーズスクロール

### 4-設定保存

**トリガー**: 各設定モーダル内の「Save」ボタンクリック

**処理内容**:
- admin-x-frameworkのAPIフックを使用
- Ghost Admin APIを呼び出して設定を更新
- 成功時はモーダルを閉じ、トースト通知を表示

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示時 | settings | SELECT | 全設定値の取得 |
| 設定保存時 | settings | UPDATE | 設定値の更新 |

設定画面は各種設定項目へのハブとして機能するため、具体的なDB操作は各サブ設定画面（No.33〜No.63）で詳述します。

### テーブル別更新項目詳細

#### settings（読み取り）

本画面では主に読み取りを行い、設定の表示状態を決定します。

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | editor_default_email_recipients | 現在値 | ニュースレター有効/無効の判定 |
| SELECT | donations_enabled | 現在値 | Tips機能表示の判定 |

## メッセージ仕様

| メッセージ種別 | メッセージ内容 | 表示条件 |
|--------------|---------------|---------|
| 成功 | Settings saved | 設定保存成功時 |
| エラー | Failed to save settings | 設定保存失敗時 |
| 検索結果なし | No settings found | 検索でマッチする項目がない場合 |

## 例外処理

| 例外状態 | 処理内容 |
|---------|---------|
| 未認証 | サインイン画面へリダイレクト |
| 権限不足 | 設定項目が非表示またはグレーアウト |
| API通信エラー | エラートースト表示、リトライ可能 |
| フィーチャーフラグ無効 | 該当設定項目を非表示 |

## 備考

- 設定画面はReact（admin-x-settings）で構築され、Ember.js管理画面内にコンポーネントとして埋め込まれています
- inAdminForwardフィーチャーフラグがtrueの場合、新しいReact管理シェルで直接レンダリングされます
- モーダルの状態管理には@ebay/nice-modal-reactライブラリを使用
- 設定項目のルーティングには@tryghost/admin-x-framework/routingを使用
- 検索機能はSearchableSectionコンポーネントで実装され、各設定項目にkeywordsプロパティが設定されています

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、設定データの構造とコンテキストの流れを理解することが重要です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | settings-app-provider.tsx | `apps/admin-x-settings/src/components/providers/settings-app-provider.tsx` | アプリ全体のコンテキスト、upgradeStatusの型定義 |
| 1-2 | global-data-provider.tsx | `apps/admin-x-settings/src/components/providers/global-data-provider.tsx` | settings, configのグローバルデータ提供 |

**読解のコツ**: ReactのContext APIとカスタムフックを多用。useGlobalData()で設定値にアクセス。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイルを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | settings-x.hbs | `ghost/admin/app/templates/settings-x.hbs` | Ember側のエントリーポイント、AdminX::Settingsコンポーネントの呼び出し |
| 2-2 | app.tsx | `apps/admin-x-settings/src/app.tsx` | Reactアプリのルートコンポーネント、プロバイダーの階層 |
| 2-3 | main-content.tsx | `apps/admin-x-settings/src/main-content.tsx` | メインコンテンツ領域のレイアウト |

**主要処理フロー**:
1. **L14-29**: Appコンポーネントでプロバイダーをネスト（SettingsAppProvider > NiceModal.Provider > RoutingProvider > DesignSystemApp）
2. **L21**: RoutingProviderでbasePathを'settings'に設定、モーダルパスをロード
3. **L23-24**: SettingsRouterとMainContentを並列レンダリング

#### Step 3: 設定画面の構成を理解する

各設定セクションの構成を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | settings.tsx | `apps/admin-x-settings/src/components/settings.tsx` | 設定画面のメインレイアウト。6つのセクションコンポーネントを配置 |
| 3-2 | general-settings.tsx | `apps/admin-x-settings/src/components/settings/general/general-settings.tsx` | General設定セクション。検索キーワードとサブコンポーネントの構成 |
| 3-3 | site-settings.tsx | `apps/admin-x-settings/src/components/settings/site/site-settings.tsx` | Site設定セクション |
| 3-4 | membership-settings.tsx | `apps/admin-x-settings/src/components/settings/membership/membership-settings.tsx` | Membership設定セクション。条件付きコンポーネント表示 |

**主要処理フロー**:
- **settings.tsx L12-20**: 6つの設定セクションを順番にレンダリング
- **general-settings.tsx L13-22**: searchKeywordsオブジェクトで各項目の検索キーワードを定義
- **membership-settings.tsx L23-25**: フィーチャーフラグと設定値で条件分岐

#### Step 4: ルーティングとモーダルを理解する

設定項目のナビゲーションとモーダル表示を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | settings-router.tsx | `apps/admin-x-settings/src/components/providers/settings-router.tsx` | URLパスとモーダルのマッピング定義（modalPaths） |
| 4-2 | modals.tsx | `apps/admin-x-settings/src/components/providers/routing/modals.tsx` | モーダルコンポーネントの遅延ロード定義 |

**主要処理フロー**:
- **settings-router.tsx L6-41**: modalPathsオブジェクトでURL→モーダル名のマッピング
- **L49-53**: useRouteChangeCallbackで経路変更時にセクションスクロール
- **L55-59**: useEffectでルート変更時にナビゲーションセクションを更新

### プログラム呼び出し階層図

```
[ブラウザ] /ghost/settings
    │
    ├─ ghost/admin/app/templates/settings-x.hbs
    │      └─ <AdminX::Settings />
    │
    ├─ apps/admin-x-settings/src/app.tsx
    │      ├─ SettingsAppProvider
    │      │      └─ グローバル状態管理
    │      ├─ NiceModal.Provider
    │      │      └─ モーダル状態管理
    │      ├─ RoutingProvider (basePath='settings')
    │      │      └─ URL/モーダルルーティング
    │      └─ DesignSystemApp
    │             ├─ SettingsRouter
    │             │      └─ セクションスクロール制御
    │             └─ MainContent
    │                    └─ Settings
    │                           ├─ GeneralSettings
    │                           │      ├─ TitleAndDescription
    │                           │      ├─ TimeZone
    │                           │      ├─ PublicationLanguage
    │                           │      ├─ Users
    │                           │      ├─ SEOMeta
    │                           │      ├─ SocialAccounts
    │                           │      ├─ Analytics
    │                           │      └─ LockSite
    │                           ├─ SiteSettings
    │                           │      ├─ DesignSetting
    │                           │      ├─ ChangeTheme
    │                           │      ├─ Navigation
    │                           │      └─ AnnouncementBar
    │                           ├─ MembershipSettings
    │                           ├─ EmailSettings
    │                           ├─ GrowthSettings
    │                           └─ AdvancedSettings
    │
    └─ [モーダル表示時]
           └─ loadModals() → 各種DetailModal
```

### データフロー図

```
[入力]                     [処理]                           [出力]

                     ┌─────────────────────────────┐
URL /ghost/settings ─▶│ RoutingProvider             │
                     │   - basePathの設定          │
                     │   - modalPathsのロード      │
                     └────────────┬────────────────┘
                                  │
                     ┌────────────▼────────────────┐
                     │ SettingsAppProvider         │
                     │   - upgradeStatus管理       │
                     │   - グローバル設定取得       │
                     └────────────┬────────────────┘
                                  │
                     ┌────────────▼────────────────┐
[Ghost Admin API] ◀─▶│ useGlobalData()             │───▶ [settings, config]
GET /settings/       │   - settings取得            │
                     │   - config取得              │
                     └────────────┬────────────────┘
                                  │
                     ┌────────────▼────────────────┐
                     │ Settings コンポーネント      │───▶ [画面表示]
                     │   - 6セクションレンダリング  │
                     │   - SearchableSection       │
                     └─────────────────────────────┘
                                  │
                     ┌────────────▼────────────────┐
[ユーザー操作]       │ SettingsRouter              │
(設定項目クリック)   │   - modalPaths照合          │
                     │   - NiceModal.show()        │
                     └────────────┬────────────────┘
                                  │
                                  ▼
                     ┌───────────────────────────┐
                     │ 各種Modal コンポーネント    │───▶ [設定変更・保存]
                     │   - TierDetailModal        │
                     │   - UserDetailModal        │
                     │   - NewsletterDetailModal  │
                     └───────────────────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| settings-x.hbs | `ghost/admin/app/templates/settings-x.hbs` | テンプレート | Ember側のエントリーポイント |
| app.tsx | `apps/admin-x-settings/src/app.tsx` | ソース | Reactアプリのルートコンポーネント |
| main-content.tsx | `apps/admin-x-settings/src/main-content.tsx` | ソース | メインコンテンツ領域 |
| settings.tsx | `apps/admin-x-settings/src/components/settings.tsx` | ソース | 設定セクションの配置 |
| settings-router.tsx | `apps/admin-x-settings/src/components/providers/settings-router.tsx` | ソース | ルーティング・モーダルパス定義 |
| settings-app-provider.tsx | `apps/admin-x-settings/src/components/providers/settings-app-provider.tsx` | ソース | アプリコンテキストプロバイダー |
| general-settings.tsx | `apps/admin-x-settings/src/components/settings/general/general-settings.tsx` | ソース | General設定セクション |
| site-settings.tsx | `apps/admin-x-settings/src/components/settings/site/site-settings.tsx` | ソース | Site設定セクション |
| membership-settings.tsx | `apps/admin-x-settings/src/components/settings/membership/membership-settings.tsx` | ソース | Membership設定セクション |
| email-settings.tsx | `apps/admin-x-settings/src/components/settings/email/email-settings.tsx` | ソース | Email設定セクション |
| growth-settings.tsx | `apps/admin-x-settings/src/components/settings/growth/growth-settings.tsx` | ソース | Growth設定セクション |
| advanced-settings.tsx | `apps/admin-x-settings/src/components/settings/advanced/advanced-settings.tsx` | ソース | Advanced設定セクション |
| searchable-section.tsx | `apps/admin-x-settings/src/components/searchable-section.tsx` | ソース | 検索可能なセクションコンポーネント |
| router.js | `ghost/admin/app/router.js` | ソース | Ember側のルーター定義 |
