# 画面設計書 33-タイトルと説明設定

## 概要

本ドキュメントは、Ghost管理画面の「タイトルと説明」設定の設計内容を記載した画面設計書です。この画面は、サイトのタイトルと説明文を設定するための機能を提供します。

### 本画面の処理概要

この画面では、Ghostサイトの基本的な識別情報であるサイトタイトルとサイト説明を設定・編集することができます。

**業務上の目的・背景**：サイトタイトルと説明は、ブラウザのタイトルバー、検索エンジンの検索結果、SNSでの共有時など、多くの場面でサイトを識別するために使用される最も重要な情報です。これらの設定を適切に行うことで、ブランディングの一貫性とSEO効果を高めることができます。

**画面へのアクセス方法**：
- 設定画面（/ghost/settings）のGeneral settingsセクション内
- 「Title & description」項目をクリックして編集モードに入る

**主要な操作・処理内容**：
1. 現在のタイトルと説明の確認：表示モードで現在の設定値を確認
2. タイトルの編集：4〜63文字のサイトタイトルを入力
3. 説明の編集：最大200文字のサイト説明を入力
4. 設定の保存：変更内容をAPIを通じて保存

**画面遷移**：
- 遷移元：設定画面のGeneral settingsセクション
- 遷移先：なし（インライン編集のため画面遷移なし）

**権限による表示制御**：Admin権限以上のスタッフユーザーのみ編集可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 35 | 一般設定 | 主機能 | サイトのタイトル・説明文の設定 |

## 画面種別

編集（インライン編集形式）

## URL/ルーティング

| URL パターン | 説明 |
|-------------|------|
| `/ghost/settings` (General settings内) | 設定画面内のTitle & descriptionセクション |

## 入出力項目

### 入力項目

| 項目名 | 型 | 必須 | 最大長 | バリデーション | 説明 |
|--------|-----|------|--------|---------------|------|
| Site title | String | Yes | 63文字 | 4文字以上63文字以下必須 | サイトのタイトル |
| Site description | String | No | 200文字 | なし | サイトの説明文 |

## 表示項目

### 表示モード

| 項目名 | 表示位置 | データソース |
|--------|---------|-------------|
| Site title | 左カラム | settings.title |
| Site description | 右カラム | settings.description |

### 編集モード

| 項目名 | コンポーネント | プレースホルダー | ヒント |
|--------|--------------|-----------------|-------|
| Site title | TextField | "Site title" | "The name of your site" |
| Site description | TextField | "Site description" | "A short description, used in your theme, meta data and search results" |

## イベント仕様

### 1-編集ボタンクリック

**トリガー**: TopLevelGroupの編集ボタン（Editアイコン）をクリック

**処理内容**:
- isEditingをtrueに変更
- 表示モードから編集モードに切り替え
- Site titleフィールドにフォーカス

### 2-サイトタイトル変更

**トリガー**: Site titleフィールドへの入力

**処理内容**:
- updateSetting('title', value)でローカル設定を更新
- 入力時にバリデーションエラーをクリア

**バリデーション**:
- 空の場合: "Please enter a site title."
- 4文字未満: "Please use a site title longer than 3 characters."
- 63文字超過: "Please use a site title shorter than 63 characters."

### 3-サイト説明変更

**トリガー**: Site descriptionフィールドへの入力

**処理内容**:
- updateSetting('description', value)でローカル設定を更新

### 4-保存ボタンクリック

**トリガー**: Saveボタンをクリック

**処理内容**:
- バリデーション実行
- エラーがなければhandleSave()でAPI呼び出し
- 成功時: isEditingをfalse、saveStateを更新
- 失敗時: エラートースト表示

**API呼び出し**:
```
PUT /ghost/api/admin/settings/
Content-Type: application/json

{
  "settings": [
    { "key": "title", "value": "{新しいタイトル}" },
    { "key": "description", "value": "{新しい説明}" }
  ]
}
```

### 5-キャンセルボタンクリック

**トリガー**: Cancelボタンをクリック

**処理内容**:
- ローカル設定を元の値にリセット
- isEditingをfalseに変更
- エラー状態をクリア

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示時 | settings | SELECT | 現在のtitle, description取得 |
| 保存ボタンクリック | settings | UPDATE | title, descriptionの更新 |

### テーブル別更新項目詳細

#### settings

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | title | ユーザー入力値 | キー: 'title' |
| UPDATE | description | ユーザー入力値 | キー: 'description' |

## メッセージ仕様

| メッセージ種別 | メッセージ内容 | 表示条件 |
|--------------|---------------|---------|
| エラー | Please enter a site title. | タイトルが空の場合 |
| エラー | Please use a site title longer than 3 characters. | タイトルが4文字未満の場合 |
| エラー | Please use a site title shorter than 63 characters. | タイトルが63文字超過の場合 |
| ヒント | The name of your site | Site titleフィールドのヒント |
| ヒント | A short description, used in your theme, meta data and search results | Site descriptionフィールドのヒント |

## 例外処理

| 例外状態 | 処理内容 |
|---------|---------|
| バリデーションエラー | エラーメッセージをフィールド下部に表示、保存をブロック |
| API通信エラー | エラートースト表示、編集モードを維持 |
| 未認証 | サインイン画面へリダイレクト |

## 備考

- タイトルと説明は、テーマ、メタデータ、検索結果など様々な場所で使用されます
- withErrorBoundaryでコンポーネントエラーをキャッチし、クラッシュ時もUI全体は維持されます
- focusRefにより編集モード時にタイトルフィールドに自動フォーカスします

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | settings API | `@tryghost/admin-x-framework/api/settings` | getSettingValues関数でsettingsから値を取得する方法 |

**読解のコツ**: getSettingValues(localSettings, ['title', 'description'])で設定値を配列で取得。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | title-and-description.tsx | `apps/admin-x-settings/src/components/settings/general/title-and-description.tsx` | メインコンポーネント全体の構造 |

**主要処理フロー**:
1. **L7-41**: useSettingGroupフックでフォーム状態管理とバリデーション設定
2. **L43**: getSettingValuesでtitle, descriptionを取得
3. **L53-69**: 表示モード用のvaluesコンポーネント（SettingGroupContent）
4. **L71-92**: 編集モード用のinputFieldsコンポーネント（TextField x 2）
5. **L94-109**: TopLevelGroupでラップし、編集/表示を切り替え

#### Step 3: フック・ユーティリティを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | use-setting-group.ts | `apps/admin-x-settings/src/hooks/use-setting-group.ts` | 設定グループのCRUD操作とバリデーションを管理するカスタムフック |
| 3-2 | top-level-group.tsx | `apps/admin-x-settings/src/components/top-level-group.tsx` | 設定項目の共通レイアウトコンポーネント |

**主要処理フロー**:
- useSettingGroupは、localSettings, isEditing, saveState, handleSave, handleCancel等を提供
- onValidateコールバックでカスタムバリデーションを実装

### プログラム呼び出し階層図

```
[ユーザー操作]
    │
    ├─ TitleAndDescription コンポーネント
    │      │
    │      ├─ useSettingGroup() フック
    │      │      ├─ localSettings (ローカル設定状態)
    │      │      ├─ updateSetting() (設定値更新)
    │      │      ├─ handleSave() (保存処理)
    │      │      └─ handleCancel() (キャンセル処理)
    │      │
    │      ├─ getSettingValues()
    │      │      └─ ['title', 'description'] を取得
    │      │
    │      └─ TopLevelGroup
    │             ├─ [表示モード] SettingGroupContent (values)
    │             └─ [編集モード] SettingGroupContent (inputFields)
    │                    ├─ TextField (Site title)
    │                    └─ TextField (Site description)
    │
    └─ [保存時]
           └─ Ghost Admin API
                  └─ PUT /settings/
```

### データフロー図

```
[入力]                     [処理]                           [出力]

                     ┌─────────────────────────────┐
settings API ───────▶│ useSettingGroup()           │
(title, description) │   - localSettingsにコピー   │
                     └────────────┬────────────────┘
                                  │
                     ┌────────────▼────────────────┐
[ユーザー入力] ─────▶│ updateSetting()             │
                     │   - title更新               │
                     │   - description更新         │
                     └────────────┬────────────────┘
                                  │
                     ┌────────────▼────────────────┐
[Saveクリック] ─────▶│ onValidate()                │
                     │   - タイトル長チェック      │
                     │   - 空チェック              │
                     └────────────┬────────────────┘
                                  │
                     ┌────────────▼────────────────┐
                     │ handleSave()                │───▶ [PUT /settings/]
                     │   - API呼び出し             │
                     │   - saveState更新           │
                     └─────────────────────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| title-and-description.tsx | `apps/admin-x-settings/src/components/settings/general/title-and-description.tsx` | ソース | メインコンポーネント |
| use-setting-group.ts | `apps/admin-x-settings/src/hooks/use-setting-group.ts` | ソース | 設定グループ管理フック |
| top-level-group.tsx | `apps/admin-x-settings/src/components/top-level-group.tsx` | ソース | 設定項目レイアウト |
| general-settings.tsx | `apps/admin-x-settings/src/components/settings/general/general-settings.tsx` | ソース | 親コンポーネント |
| settings.ts | `@tryghost/admin-x-framework/api/settings` | ソース | 設定API |
