# 画面設計書 35-言語設定

## 概要

本ドキュメントは、Ghost管理画面の「言語」設定の設計内容を記載した画面設計書です。この画面は、サイトの表示言語（ロケール）を設定するための機能を提供します。

### 本画面の処理概要

この画面では、Ghostサイトで使用する言語/ロケールを選択・設定することができます。

**業務上の目的・背景**：Ghostは60以上の言語をサポートしており、テーマの表示テキスト、日付フォーマット、その他のローカライゼーション要素がこの設定に基づいて表示されます。多言語サイトの運営や、非英語圏のユーザー向けサイトで重要な設定です。

**画面へのアクセス方法**：
- 設定画面（/ghost/settings）のGeneral settingsセクション内
- 「Publication Language」項目で言語を選択

**主要な操作・処理内容**：
1. 現在の言語設定の確認：選択中のロケールコードを確認
2. 言語の選択：ドロップダウンから言語を検索・選択
3. カスタムロケールの入力：リストにない場合は手動で入力
4. 設定の保存：変更内容をAPIを通じて保存

**画面遷移**：
- 遷移元：設定画面のGeneral settingsセクション
- 遷移先：なし（インライン編集のため画面遷移なし）

**権限による表示制御**：Admin権限以上のスタッフユーザーのみ編集可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 37 | 多言語対応（i18n） | 主機能 | サイトの表示言語設定 |

## 画面種別

編集（インライン選択形式）

## URL/ルーティング

| URL パターン | 説明 |
|-------------|------|
| `/ghost/settings` (General settings内) | 設定画面内のPublication Languageセクション |

## 入出力項目

### 入力項目

| 項目名 | 型 | 必須 | 選択肢 | 説明 |
|--------|-----|------|--------|------|
| Site language | String | Yes | @tryghost/i18n/lib/locale-data.json + カスタム入力 | ロケールコード（例: ja, en, pt-BR） |

## 表示項目

### 言語選択

| 項目名 | コンポーネント | データソース | 説明 |
|--------|--------------|-------------|------|
| 言語選択 | SelectWithOther (検索可能) | LOCALE_DATA | 言語一覧 + カスタム入力オプション |
| ヒント | Hint | 固定テキスト | 翻訳ドキュメントへのリンク |

## イベント仕様

### 1-言語選択

**トリガー**: SelectWithOtherコンポーネントで言語を選択

**処理内容**:
- handleLanguageChange(value)が呼ばれる
- updateSetting('locale', value)でローカル設定を更新
- isEditingがfalseなら handleEditingChange(true)で編集状態に遷移
- Saveボタンが表示される

### 2-カスタムロケール入力

**トリガー**: 「Other」オプションを選択し、カスタム値を入力

**処理内容**:
- SelectWithOtherがotherモードに切り替わる
- 入力値がvalidateLocale()でバリデーション
- 有効なロケールコードであればupdateSetting()で更新

**バリデーション** (validateLocale):
- 空またはnullチェック
- ロケールコード形式の検証

### 3-保存ボタンクリック

**トリガー**: Saveボタンをクリック

**処理内容**:
- onValidateでバリデーション実行
- エラーがなければhandleSave()でAPI呼び出し
- 成功時: saveStateを更新

**API呼び出し**:
```
PUT /ghost/api/admin/settings/
Content-Type: application/json

{
  "settings": [
    { "key": "locale", "value": "{選択されたロケールコード}" }
  ]
}
```

### 4-キャンセルボタンクリック

**トリガー**: Cancelボタンをクリック

**処理内容**:
- ローカル設定を元の値にリセット
- isEditingをfalseに変更

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示時 | settings | SELECT | 現在のlocale取得 |
| 保存ボタンクリック | settings | UPDATE | localeの更新 |

### テーブル別更新項目詳細

#### settings

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | locale | 選択されたロケールコード | キー: 'locale' |

## メッセージ仕様

| メッセージ種別 | メッセージ内容 | 表示条件 |
|--------------|---------------|---------|
| ヒント | Default: English (en); find out more about using Ghost in other languages | 常時表示、リンク付き |
| エラー | (validateLocaleからのメッセージ) | バリデーションエラー時 |
| プレースホルダー | e.g. pt-BR, sr-Cyrl, en | カスタム入力時 |

## 例外処理

| 例外状態 | 処理内容 |
|---------|---------|
| 無効なロケールコード | バリデーションエラー表示、保存をブロック |
| API通信エラー | エラートースト表示 |

## 備考

- ロケールデータは@tryghost/i18n/lib/locale-data.jsonから提供されます
- 編集ボタン（Edit）は非表示（hideEditButton）で、SelectWithOtherを直接操作して編集開始
- デフォルト値は "en"（英語）
- カスタムロケール入力で、リストにない言語コードも設定可能です
- 言語ドキュメントへのリンク: https://ghost.org/docs/faq/translation/

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | locale-data.json | `@tryghost/i18n/lib/locale-data.json` | ロケールデータの構造（code, label） |

**読解のコツ**: LOCALE_DATAはcode（ロケール識別子）とlabel（表示名）を持つオブジェクトの配列。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | publication-language.tsx | `apps/admin-x-settings/src/components/settings/general/publication-language.tsx` | メインコンポーネント全体の構造 |

**主要処理フロー**:
1. **L1**: @tryghost/i18n/lib/locale-data.jsonをインポート
2. **L10-31**: useSettingGroupフックでフォーム状態管理とバリデーション設定
3. **L33**: getSettingValuesで'locale'を取得
4. **L35-42**: localeOptionsをuseMemoで生成（value/labelの形式に変換）
5. **L44-49**: handleLanguageChangeでロケール変更処理
6. **L51-56**: ヒントコンポーネント（ドキュメントリンク付き）
7. **L73-86**: SelectWithOtherコンポーネントでカスタム入力対応

#### Step 3: バリデーション関数を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | locale-validation.ts | `apps/admin-x-settings/src/utils/locale-validation.ts` | validateLocale関数の実装 |

### プログラム呼び出し階層図

```
[ユーザー操作]
    │
    ├─ PublicationLanguage コンポーネント
    │      │
    │      ├─ useSettingGroup() フック
    │      │      ├─ localSettings (ローカル設定状態)
    │      │      ├─ updateSetting() (設定値更新)
    │      │      ├─ handleSave() (保存処理)
    │      │      └─ onValidate (validateLocale)
    │      │
    │      ├─ LOCALE_DATA.map()
    │      │      └─ localeOptions配列を生成 (useMemo)
    │      │
    │      └─ TopLevelGroup
    │             └─ SelectWithOther
    │                    ├─ 既存ロケール選択
    │                    └─ カスタムロケール入力
    │
    └─ [保存時]
           ├─ validateLocale() バリデーション
           └─ Ghost Admin API
                  └─ PUT /settings/
```

### データフロー図

```
[入力]                     [処理]                           [出力]

                     ┌─────────────────────────────┐
settings API ───────▶│ useSettingGroup()           │
(locale)             │   - localSettingsにコピー   │
                     └────────────┬────────────────┘
                                  │
LOCALE_DATA ────────▶┌────────────▼────────────────┐
                     │ localeOptions = useMemo()   │
                     │   - value/label形式に変換   │
                     └────────────┬────────────────┘
                                  │
                     ┌────────────▼────────────────┐
[Select選択/入力] ──▶│ handleLanguageChange()      │
                     │   - updateSetting('locale') │
                     │   - handleEditingChange()   │
                     └────────────┬────────────────┘
                                  │
                     ┌────────────▼────────────────┐
[Saveクリック] ─────▶│ onValidate()                │
                     │   - validateLocale()        │
                     └────────────┬────────────────┘
                                  │
                     ┌────────────▼────────────────┐
                     │ handleSave()                │───▶ [PUT /settings/]
                     └─────────────────────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| publication-language.tsx | `apps/admin-x-settings/src/components/settings/general/publication-language.tsx` | ソース | メインコンポーネント |
| locale-data.json | `@tryghost/i18n/lib/locale-data.json` | データ | ロケールデータ |
| locale-validation.ts | `apps/admin-x-settings/src/utils/locale-validation.ts` | ソース | バリデーション関数 |
| use-setting-group.ts | `apps/admin-x-settings/src/hooks/use-setting-group.ts` | ソース | 設定グループ管理フック |
| general-settings.tsx | `apps/admin-x-settings/src/components/settings/general/general-settings.tsx` | ソース | 親コンポーネント |
