# 画面設計書 39-サイトロック設定

## 概要

本ドキュメントは、Ghost管理画面の「サイトロック」設定（Make site private）の設計内容を記載した画面設計書です。この画面は、サイト全体をパスワードで保護する機能を提供します。

### 本画面の処理概要

この画面では、サイト全体のパスワード保護を有効/無効にし、共有パスワードを設定することができます。

**業務上の目的・背景**：サイトの開発中、限定公開、または特定のユーザーグループのみにアクセスを許可したい場合に、パスワード保護機能が有用です。この機能を有効にすると、すべての訪問者はサイトにアクセスする前にパスワードの入力を求められます。ただし、SEOおよびソーシャル機能は無効化されます。

**画面へのアクセス方法**：
- 設定画面（/ghost/settings）のGeneral settingsセクション内
- 「Make site private」項目でパスワード保護を設定

**主要な操作・処理内容**：
1. パスワード保護の有効化/無効化：トグルで切り替え
2. パスワードの設定：保護を有効にした場合、共有パスワードを入力
3. プライベートRSSフィードの確認：保護有効時、特別なRSSフィードURLを確認
4. 設定の保存：変更内容をAPIを通じて保存

**画面遷移**：
- 遷移元：設定画面のGeneral settingsセクション
- 遷移先：なし（インライン編集のため画面遷移なし）

**権限による表示制御**：Admin権限以上のスタッフユーザーのみ編集可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 35 | 一般設定 | 主機能 | サイトのパスワード保護設定 |

## 画面種別

編集（トグル + 入力形式）

## URL/ルーティング

| URL パターン | 説明 |
|-------------|------|
| `/ghost/settings` (General settings内) | 設定画面内のMake site privateセクション |

## 入出力項目

### 入力項目

| 項目名 | 型 | 必須 | 設定キー | 説明 |
|--------|-----|------|---------|------|
| Enable password protection | Boolean | - | is_private | パスワード保護の有効/無効 |
| Site password | String | 保護有効時は必須 | password | サイトアクセス用パスワード |

### 表示用データ

| 項目名 | 設定キー | 説明 |
|--------|---------|------|
| public_hash | public_hash | プライベートRSSフィード用のハッシュ値 |

## 表示項目

### 表示モード（パスワード保護有効時）

| 項目名 | コンポーネント | 説明 |
|--------|--------------|------|
| ロックアイコン | Icon (lock-locked) | 黄色のロックアイコン |
| ステータステキスト | テキスト | "Your site is password protected" |
| プライベートRSS URL | Hint（リンク付き） | `{siteUrl}/{publicHash}/rss` |

### 表示モード（パスワード保護無効時）

| 項目名 | コンポーネント | 説明 |
|--------|--------------|------|
| アンロックアイコン | Icon (lock-unlocked) | 黒/白のアンロックアイコン |
| ステータステキスト | テキスト | "Your site is not password protected" |

### 編集モード

| 項目名 | コンポーネント | 説明 |
|--------|--------------|------|
| Enable password protection | Toggle | パスワード保護の切り替え |
| Site password | TextField | パスワード入力（保護有効時のみ表示） |

## イベント仕様

### 1-パスワード保護トグル変更

**トリガー**: 「Enable password protection」トグルを切り替え

**処理内容**:
- handleToggleChange(e)が呼ばれる
- updateSetting('is_private', e.target.checked)で設定を更新
- 編集モードに遷移（Saveボタンが表示される）

### 2-パスワード入力

**トリガー**: Site passwordフィールドへの入力

**処理内容**:
- handlePasswordChange(e)が呼ばれる
- updateSetting('password', e.target.value)で設定を更新

### 3-保存ボタンクリック

**トリガー**: Saveボタンをクリック

**処理内容**:
- onValidateでバリデーション実行
  - passwordEnabled && !password の場合: "Enter a password"エラー
- エラーがなければhandleSave()でAPI呼び出し
- 成功時: saveStateを更新、編集モードを終了

**API呼び出し**:
```
PUT /ghost/api/admin/settings/
Content-Type: application/json

{
  "settings": [
    { "key": "is_private", "value": true/false },
    { "key": "password", "value": "{パスワード}" }
  ]
}
```

### 4-プライベートRSSリンククリック

**トリガー**: プライベートRSS URLをクリック

**処理内容**:
- 新しいタブでプライベートRSSフィードを開く
- URL形式: `{siteUrl}/{publicHash}/rss`

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示時 | settings | SELECT | is_private, password, public_hash取得 |
| 保存ボタンクリック | settings | UPDATE | is_private, passwordの更新 |

### テーブル別更新項目詳細

#### settings

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | is_private | true/false | パスワード保護の有効/無効 |
| UPDATE | password | ユーザー入力値 | 共有パスワード |

## メッセージ仕様

| メッセージ種別 | メッセージ内容 | 表示条件 |
|--------------|---------------|---------|
| ステータス（保護有効） | Your site is password protected | is_private === true |
| ステータス（保護無効） | Your site is not password protected | is_private === false |
| ヒント | A private RSS feed is available at {url} | 保護有効時 |
| ヒント（トグル） | All search engine optimization and social features will be disabled. | 編集モード |
| エラー | Enter a password | 保護有効でパスワード空の場合 |

## 例外処理

| 例外状態 | 処理内容 |
|---------|---------|
| パスワード未入力（保護有効時） | バリデーションエラー表示、保存をブロック |
| API通信エラー | エラートースト表示 |

## 備考

- パスワード保護を有効にすると、SEOおよびソーシャル機能が無効化されます
- プライベートRSSフィードは`{siteUrl}/{publicHash}/rss`形式でアクセス可能
- public_hashはサイト初期化時に自動生成され、変更不可
- withErrorBoundaryでコンポーネントエラーをキャッチします

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | settings API | `@tryghost/admin-x-framework/api/settings` | getSettingValues関数 |

**読解のコツ**: is_private（ブール値）、password（文字列）、public_hash（文字列）の3つの設定を使用。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | lock-site.tsx | `apps/admin-x-settings/src/components/settings/general/lock-site.tsx` | メインコンポーネント全体の構造 |

**主要処理フロー**:
1. **L8-30**: useSettingGroupでフォーム状態管理とバリデーション設定
2. **L32**: getSettingValuesでis_private, password, public_hashを取得
3. **L34-36**: handleToggleChangeでis_private更新
4. **L38-40**: handlePasswordChangeでpassword更新
5. **L42-45**: privateRssUrl生成
6. **L47-76**: 表示モードのvaluesコンポーネント（保護状態に応じた表示）
7. **L78-100**: 編集モードのinputsコンポーネント（Toggle + TextField）

### プログラム呼び出し階層図

```
[ユーザー操作]
    │
    ├─ LockSite コンポーネント
    │      │
    │      ├─ useGlobalData()
    │      │      └─ siteData (siteUrl取得)
    │      │
    │      ├─ useSettingGroup() フック
    │      │      ├─ localSettings
    │      │      ├─ updateSetting()
    │      │      ├─ handleSave()
    │      │      └─ onValidate (パスワード必須チェック)
    │      │
    │      ├─ getSettingValues()
    │      │      ├─ is_private
    │      │      ├─ password
    │      │      └─ public_hash
    │      │
    │      └─ TopLevelGroup
    │             ├─ [表示モード] SettingGroupContent (values)
    │             │      ├─ Icon (lock-locked / lock-unlocked)
    │             │      ├─ ステータステキスト
    │             │      └─ プライベートRSS URL (保護有効時)
    │             │
    │             └─ [編集モード] SettingGroupContent (inputs)
    │                    ├─ Toggle (is_private)
    │                    └─ TextField (password, 保護有効時のみ)
    │
    └─ [保存時]
           └─ Ghost Admin API
                  └─ PUT /settings/
```

### データフロー図

```
[入力]                     [処理]                           [出力]

                     ┌─────────────────────────────┐
settings API ───────▶│ useSettingGroup()           │
(is_private,         │   - localSettingsにコピー   │
password,            │   - onValidate設定          │
public_hash)         └────────────┬────────────────┘
                                  │
                     ┌────────────▼────────────────┐
                     │ privateRssUrl生成           │
                     │   = siteUrl + public_hash   │
                     │   + '/rss'                  │
                     └────────────┬────────────────┘
                                  │
[Toggle操作] ──────▶┌────────────▼────────────────┐
                     │ handleToggleChange()        │
                     │   - updateSetting('is_private')│
                     └────────────┬────────────────┘
                                  │
[Password入力] ────▶┌────────────▼────────────────┐
                     │ handlePasswordChange()      │
                     │   - updateSetting('password')│
                     └────────────┬────────────────┘
                                  │
[Saveクリック] ─────▶┌────────────▼────────────────┐
                     │ onValidate()                │
                     │   - パスワード必須チェック  │───▶ [PUT /settings/]
                     │   - handleSave()            │
                     └─────────────────────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| lock-site.tsx | `apps/admin-x-settings/src/components/settings/general/lock-site.tsx` | ソース | メインコンポーネント |
| use-setting-group.ts | `apps/admin-x-settings/src/hooks/use-setting-group.ts` | ソース | 設定グループ管理フック |
| global-data-provider.tsx | `apps/admin-x-settings/src/components/providers/global-data-provider.tsx` | ソース | siteData提供 |
| general-settings.tsx | `apps/admin-x-settings/src/components/settings/general/general-settings.tsx` | ソース | 親コンポーネント |
