# 画面設計書 4-パスワードリセット画面

## 概要

本ドキュメントは、Ghost管理画面のパスワードリセット画面の設計内容を記載する。

### 本画面の処理概要

パスワードリセット画面は、パスワードを忘れたスタッフユーザーが新しいパスワードを設定するための画面である。サインイン画面の「Forgot?」リンクからパスワードリセットメールを受け取り、メール内のリンクからアクセスして新しいパスワードを設定する。

**業務上の目的・背景**：ユーザーがパスワードを忘れた場合に、セキュアな方法で新しいパスワードを設定できるようにする。リセットトークンには有効期限があり、1回のみ使用可能とすることで、リンクの不正利用を防止する。また、パスワードリセット完了後は自動的にログインされ、スムーズに管理画面へアクセスできる。

**画面へのアクセス方法**：パスワードリセットメール内のリンク（`/ghost/reset/{token}`）をクリックしてアクセスする。トークンはBase64エンコードされており、有効期限とメールアドレス情報を含む。

**主要な操作・処理内容**：
1. 新しいパスワード入力 - 10文字以上の安全なパスワードを入力
2. パスワード確認入力 - 新しいパスワードを再入力して確認
3. 保存ボタン押下 - パスワードを更新し、自動ログイン

**画面遷移**：
- 遷移元：パスワードリセットメール内のリンク
- 遷移先：
  - リセット成功時：ホーム画面（自動ログイン）
  - 無効なトークン時：サインイン画面

**権限による表示制御**：本画面は未認証ユーザー専用。既にログイン済みの場合、警告メッセージが表示される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 88 | 認証 | 主機能 | パスワードリセットトークンの検証と新パスワードの設定 |

## 画面種別

パスワード変更

## URL/ルーティング

- **URL**: `/ghost/reset/:token`
- **Emberルート名**: `reset`
- **ルートファイル**: `ghost/admin/app/routes/reset.js`

## 入出力項目

| 項目名 | 項目ID | 型 | 必須 | 入力/出力 | バリデーション | 備考 |
|--------|--------|-----|------|----------|---------------|------|
| 新しいパスワード | newPassword | string | 必須 | 入力 | 10文字以上、複雑性チェック | プレースホルダー: "New password" |
| パスワード確認 | ne2Password | string | 必須 | 入力 | newPasswordと一致 | プレースホルダー: "Confirm new password" |
| リセットトークン | token | string | 必須 | URL | Base64形式、有効性チェック | URLパラメータから取得 |

## 表示項目

| 項目名 | 表示条件 | データソース | 備考 |
|--------|----------|--------------|------|
| サイトアイコン | 常時 | config.siteIcon | スタイル属性で表示 |
| ヘッダータイトル | 常時 | 固定値 | "Reset your password." |
| フローエラー | エラー発生時 | flowErrors | 画面下部に赤字表示 |
| 項目別エラー | バリデーションエラー時 | errors | 各入力項目下に表示 |

## イベント仕様

### 1-保存ボタン押下（Save new password）

**トリガー**: 「Save new password」ボタンクリックまたはEnterキー押下

**処理フロー**:
1. `resetPasswordTask`が実行される
2. クライアント側バリデーション実行（パスワード必須、一致、複雑性）
3. バリデーション成功時、APIエンドポイント`PUT /ghost/api/admin/authentication/password_reset`にリクエスト送信
4. バックエンドでトークン検証、パスワード更新、ユーザーステータス更新
5. レスポンスに含まれるemailVerificationTokenを使用して自動ログイン
6. 成功時：通知表示後、ホーム画面へリダイレクト
7. 失敗時：エラーメッセージを表示

**遷移先**:
- 成功時: `/ghost/` (ホーム画面)
- 失敗時: 本画面に留まりエラー表示

### 2-入力欄への入力

**トリガー**: 各入力欄への入力時

**処理フロー**:
1. `handleInput`アクションが実行される
2. flowErrorsとerrorsをクリア
3. hasValidatedに両プロパティを追加
4. 入力値を該当プロパティに設定

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| パスワードリセット | users | UPDATE | passwordカラムを更新 |
| パスワードリセット | users | UPDATE | statusをactiveに更新 |
| 自動ログイン | users | UPDATE | last_seenカラムを更新 |
| 自動ログイン | sessions | INSERT | 新規セッションレコードの作成 |

### テーブル別更新項目詳細

#### users

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | password | フォーム入力値（ハッシュ化） | bcryptでハッシュ化 |
| UPDATE | status | 'active' | locked状態からの復帰 |
| UPDATE | last_seen | 現在日時 | 自動ログイン時に更新 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| M001 | エラー | "Please enter a password." | 新しいパスワード未入力 |
| M002 | エラー | "The two new passwords don't match." | パスワード不一致 |
| M003 | エラー | "Password must be at least 10 characters long." | パスワード10文字未満 |
| M004 | エラー | "Sorry, you cannot use an insecure password." | 安全でないパスワード |
| M005 | 警告 | "You can't reset your password while you're signed in." | 既にログイン済み |
| M006 | エラー | "Cannot reset password." | リセット失敗（汎用） |
| M007 | エラー | "Password reset link expired." | トークン有効期限切れ |
| M008 | エラー | "Password reset link has already been used." | トークン使用済み |
| M009 | エラー | "Invalid password reset link." | トークン不正 |
| M010 | エラー | "Token locked" | ブルートフォース検出（10回以上試行） |
| M011 | 成功 | （APIからのメッセージ） | パスワードリセット成功 |

## 例外処理

| 例外ケース | 対応処理 | 表示内容 |
|-----------|----------|----------|
| パスワード未入力 | バリデーションエラー表示 | "Please enter a password." |
| パスワード不一致 | バリデーションエラー表示 | "The two new passwords don't match." |
| パスワード複雑性不足 | バリデーションエラー表示 | パスワード関連エラーメッセージ |
| トークン有効期限切れ | APIエラー通知表示 | "Password reset link expired." |
| トークン使用済み | APIエラー通知表示 | "Password reset link has already been used." |
| トークン形式不正 | APIエラー通知表示 | "Invalid password reset link." |
| ブルートフォース検出 | APIエラー通知表示 | "Token locked" |
| 既にログイン済み | 警告表示後、通常の未認証チェック | "You can't reset your password while you're signed in." |
| ユーザー不在 | APIエラー通知表示 | "User not found." |

## 備考

- リセットトークンの有効期限は1日（24時間）
- トークンはユーザーのパスワードハッシュとDB hashを使用して生成されるため、パスワード変更後は自動的に無効化される
- 同一トークンで10回以上のリセット試行があるとブルートフォース保護が発動
- パスワードリセット完了後は2FA検証バイパス用のemailVerificationTokenが生成される
- パスワードリセット成功時、ユーザーのstatusがactiveに更新される（locked状態からの復帰）
- 画面離脱時（deactivate）に機密情報（パスワード、トークン）がクリアされる

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

パスワードリセットに使用されるデータとバリデーションルールを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | reset.js (Controller) | `ghost/admin/app/controllers/reset.js` | trackedプロパティ（newPassword, ne2Password, token）の定義 |
| 1-2 | reset.js (Validator) | `ghost/admin/app/validators/reset.js` | パスワード必須、一致、複雑性チェックのルール |
| 1-3 | password.js | `ghost/admin/app/validators/mixins/password.js` | パスワード複雑性チェックの詳細ルール |

**読解のコツ**: コントローラーがValidationEngineを継承しているため、`validate()`メソッドがコントローラー上で直接呼び出せる。

#### Step 2: エントリーポイントを理解する

テンプレートとルートの関係を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | reset.hbs | `ghost/admin/app/templates/reset.hbs` | フォーム構造、イベントバインディング |
| 2-2 | reset.js (Route) | `ghost/admin/app/routes/reset.js` | setupControllerでのトークン設定、deactivateでの機密情報クリア |

**主要処理フロー**:
1. **8-14行目**: beforeModelで認証状態チェック、ログイン済みなら警告表示
2. **16-18行目**: setupControllerでURLパラメータのトークンをコントローラーに設定
3. **21-24行目**: deactivateで機密情報クリア

#### Step 3: コントローラーのタスク処理を理解する

パスワードリセット処理の実装を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | reset.js (Controller) | `ghost/admin/app/controllers/reset.js` | resetPasswordTask（49-90行目）の処理フロー、email getter（25-29行目）のトークンデコード |

**主要処理フロー**:
- **25-29行目**: トークンからメールアドレスを抽出（Base64デコード）
- **49-90行目**: バリデーション → APIリクエスト → 自動ログインの流れ
- **60-64行目**: PUT /authentication/password_resetでパスワードリセット
- **71行目**: emailVerificationTokenを使用して2FA検証をバイパスしてログイン

#### Step 4: バックエンドAPI処理を理解する

サーバーサイドのパスワードリセット処理を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | authentication.js | `ghost/core/core/server/api/endpoints/authentication.js` | resetPassword（147-172行目）のエンドポイント定義 |
| 4-2 | passwordreset.js | `ghost/core/core/server/services/auth/passwordreset.js` | extractTokenParts、protectBruteForce、doResetの処理詳細 |

**主要処理フロー**:
- **passwordreset.js 66-82行目**: トークンをデコードしてパーツを抽出
- **passwordreset.js 85-94行目**: ブルートフォース保護（10回以上でロック）
- **passwordreset.js 96-162行目**: トークン検証、パスワード変更、ステータス更新、2FA検証トークン生成

### プログラム呼び出し階層図

```
reset.hbs (テンプレート)
    │
    └─ ResetController.resetPasswordTask
           ├─ ValidationEngine.validate
           │      └─ ResetValidator.newPassword
           │             └─ PasswordValidatorMixin.passwordValidation
           │
           ├─ PUT /authentication/password_reset
           │      └─ AuthenticationController.resetPassword
           │             ├─ passwordreset.extractTokenParts
           │             ├─ passwordreset.protectBruteForce
           │             └─ passwordreset.doReset
           │                    ├─ security.tokens.resetToken.compare
           │                    ├─ User.changePassword
           │                    ├─ user.save (status: 'active')
           │                    └─ otp.generate (emailVerificationToken)
           │
           └─ session.authenticate('authenticator:cookie')
                  └─ POST /session
                         └─ セッション作成
```

### データフロー図

```
[入力]                      [処理]                              [出力]

リセットメール ──────▶ トークンデコード ──────▶ email抽出
(token)                   │
                          │
newPassword ──────────────┼──▶ resetPasswordTask ───────────▶ ホーム画面へ遷移
ne2Password ──────────────┘       │                            または
                                 │                            エラー表示
                                 ▼
                           PUT /password_reset
                                 │
                                 ▼
                           ┌─────┴─────┐
                           │           │
                        トークン    トークン
                        検証成功    検証失敗
                           │           │
                           ▼           ▼
                        users       エラー
                       UPDATE     レスポンス
                       (password,
                        status)
                           │
                           ▼
                    emailVerificationToken生成
                           │
                           ▼
                    POST /session（自動ログイン）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| reset.hbs | `ghost/admin/app/templates/reset.hbs` | テンプレート | パスワードリセットフォームのUI定義 |
| reset.js | `ghost/admin/app/routes/reset.js` | ルート | ルーティング、トークン設定、機密情報クリア |
| reset.js | `ghost/admin/app/controllers/reset.js` | コントローラー | フォーム処理とタスク定義 |
| reset.js | `ghost/admin/app/validators/reset.js` | バリデータ | パスワードバリデーションルール |
| password.js | `ghost/admin/app/validators/mixins/password.js` | ミックスイン | パスワード複雑性バリデーション |
| authentication.js | `ghost/core/core/server/api/endpoints/authentication.js` | API | パスワードリセットエンドポイント |
| passwordreset.js | `ghost/core/core/server/services/auth/passwordreset.js` | サービス | トークン検証、パスワード更新処理 |
| user.js | `ghost/core/core/server/models/user.js` | モデル | ユーザーモデル、changePassword |
| cookie.js | `ghost/admin/app/authenticators/cookie.js` | 認証 | 自動ログイン処理 |
| otp.js | `ghost/core/core/server/services/auth/otp.js` | ユーティリティ | 2FA検証バイパストークン生成 |
| unauthenticated.js | `ghost/admin/app/routes/unauthenticated.js` | ルート（親） | 未認証ルートの基底クラス |
