# 画面設計書 40-デザイン設定

## 概要

本ドキュメントは、Ghost管理画面の「デザイン設定」（Design & branding）の設計内容を記載した画面設計書です。この画面は、サイトのデザインとブランディング設定へのエントリーポイントを提供します。

### 本画面の処理概要

この画面では、サイトのデザインとブランディング（ロゴ、カラー、フォント等）をカスタマイズするための設定モーダルへアクセスすることができます。

**業務上の目的・背景**：サイトのビジュアルアイデンティティは、ブランド認知とユーザーエクスペリエンスに大きく影響します。この画面から詳細なデザイン設定モーダルにアクセスし、ロゴ、カバー画像、アクセントカラー、背景色などをカスタマイズすることで、サイトの外観を統一的に管理できます。

**画面へのアクセス方法**：
- 設定画面（/ghost/settings）のSiteセクション内
- 「Design & branding」項目の「Customize」ボタンをクリック

**主要な操作・処理内容**：
1. デザイン設定プレビュー画像の確認：サムネイル画像でデザイン設定のイメージを把握
2. カスタマイズモーダルを開く：「Customize」ボタンでDesignAndThemeModalを表示
3. モーダル内でロゴ、カラー等を設定（詳細は別モーダル）

**画面遷移**：
- 遷移元：設定画面のSiteセクション
- 遷移先：DesignAndThemeModal（design/edit）

**権限による表示制御**：Admin権限以上のスタッフユーザーのみアクセス可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 31 | カスタムテーマ設定 | 主機能 | ロゴ・カラー・ブランディングの設定 |

## 画面種別

エントリーポイント（モーダルへのランチャー）

## URL/ルーティング

| URL パターン | 説明 |
|-------------|------|
| `/ghost/settings` (Site内) | 設定画面内のDesign & brandingセクション |
| `/ghost/settings/design/edit` | デザイン設定モーダル（遷移先） |

## 入出力項目

### 入力項目

この画面自体には入力項目はありません。「Customize」ボタンでモーダルを開いて設定を行います。

## 表示項目

| 項目名 | コンポーネント | 説明 |
|--------|--------------|------|
| プレビュー画像 | img | デザイン設定のサムネイル画像（DesignSettingsImg） |
| Customizeボタン | Button | クリックでDesignAndThemeModalを開く |

## イベント仕様

### 1-Customizeボタンクリック

**トリガー**: 「Customize」ボタンをクリック

**処理内容**:
- openPreviewModal()が呼ばれる
- updateRoute('design/edit')でルートを更新
- SettingsRouterがmodalPathsからDesignAndThemeModalを特定
- モーダルが表示される

**ルーティング**:
```
design/edit → DesignAndThemeModal
```

### 2-モーダルクローズ

**トリガー**: モーダルを閉じる（保存またはキャンセル）

**処理内容**:
- モーダルがクローズされる
- ルートが`/ghost/settings`に戻る

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| - | - | - | この画面ではDB操作なし（モーダル側で実行） |

この画面自体ではデータベース操作を行いません。実際のデザイン設定の変更は、遷移先のDesignAndThemeModalで行われます。

## メッセージ仕様

| メッセージ種別 | メッセージ内容 | 表示条件 |
|--------------|---------------|---------|
| 説明文 | Customize the style and layout of your site | 常時表示 |

## 例外処理

| 例外状態 | 処理内容 |
|---------|---------|
| モーダルロードエラー | エラーバウンダリでエラー表示 |

## 備考

- この画面はDesignAndThemeModalへのエントリーポイントとして機能します
- 実際のデザイン設定はDesignAndThemeModal内で行われます
- プレビュー画像はassetsディレクトリの静的画像ファイルを使用
- customButtonsプロパティでボタンをTopLevelGroupに渡しています
- withErrorBoundaryでコンポーネントエラーをキャッチします

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | design-setting.tsx | `apps/admin-x-settings/src/components/settings/site/design-setting.tsx` | メインコンポーネント全体の構造 |

**主要処理フロー**:
1. **L1**: DesignSettingsImgをインポート（プレビュー画像）
2. **L5**: useRoutingでルーティング機能を取得
3. **L7**: DesignSettingコンポーネント定義
4. **L8**: useRoutingからupdateRouteを取得
5. **L9-11**: openPreviewModal関数でモーダルを開く
6. **L13-23**: TopLevelGroupでラップ、customButtonsでCustomizeボタンを配置

#### Step 2: 遷移先モーダルを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | settings-router.tsx | `apps/admin-x-settings/src/components/providers/settings-router.tsx` | modalPathsで'design/edit'がDesignAndThemeModalにマッピング |
| 2-2 | design-and-theme-modal.tsx | `apps/admin-x-settings/src/components/settings/site/design-and-theme-modal.tsx` | 実際のデザイン設定モーダル |

**modalPaths（settings-router.tsx）**:
```javascript
'design/edit': 'DesignAndThemeModal',
'design/change-theme': 'DesignAndThemeModal',
```

### プログラム呼び出し階層図

```
[ユーザー操作]
    │
    ├─ DesignSetting コンポーネント
    │      │
    │      ├─ useRouting()
    │      │      └─ updateRoute
    │      │
    │      ├─ openPreviewModal()
    │      │      └─ updateRoute('design/edit')
    │      │
    │      └─ TopLevelGroup
    │             ├─ customButtons (Customizeボタン)
    │             └─ img (DesignSettingsImg)
    │
    └─ [Customizeクリック時]
           └─ SettingsRouter
                  └─ modalPaths['design/edit']
                         └─ DesignAndThemeModal
```

### データフロー図

```
[入力]                     [処理]                           [出力]

                     ┌─────────────────────────────┐
                     │ DesignSetting コンポーネント │
                     │   - プレビュー画像表示      │
                     │   - Customizeボタン表示     │
                     └────────────┬────────────────┘
                                  │
[Customizeクリック] ─▶┌──────────▼────────────────┐
                     │ openPreviewModal()         │
                     │   - updateRoute('design/edit')│
                     └────────────┬────────────────┘
                                  │
                     ┌────────────▼────────────────┐
                     │ SettingsRouter              │
                     │   - modalPaths照合          │───▶ [DesignAndThemeModal]
                     │   - モーダルロード          │
                     └─────────────────────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| design-setting.tsx | `apps/admin-x-settings/src/components/settings/site/design-setting.tsx` | ソース | メインコンポーネント（ランチャー） |
| design-settings.png | `apps/admin-x-settings/src/assets/images/design-settings.png` | 画像 | プレビュー画像 |
| design-and-theme-modal.tsx | `apps/admin-x-settings/src/components/settings/site/design-and-theme-modal.tsx` | ソース | デザイン設定モーダル |
| settings-router.tsx | `apps/admin-x-settings/src/components/providers/settings-router.tsx` | ソース | モーダルパスマッピング |
| site-settings.tsx | `apps/admin-x-settings/src/components/settings/site/site-settings.tsx` | ソース | 親コンポーネント |
| design-modal.tsx | `apps/admin-x-settings/src/components/settings/site/design-modal.tsx` | ソース | デザイン設定詳細モーダル |
| global-settings.tsx | `apps/admin-x-settings/src/components/settings/site/design-and-branding/global-settings.tsx` | ソース | グローバルデザイン設定 |
| theme-settings.tsx | `apps/admin-x-settings/src/components/settings/site/design-and-branding/theme-settings.tsx` | ソース | テーマ固有設定 |
