# 画面設計書 44-アクセス設定

## 概要

本ドキュメントは、Ghost管理画面の「アクセス設定」画面の設計仕様を定義する。この画面はサイトへのサインアップ権限、新規投稿のデフォルトアクセス権限、コメント機能の設定を行う機能を提供する。

### 本画面の処理概要

この画面では、メンバーシップとコンテンツアクセスに関する基本的な設定を管理する。誰がサイトに登録できるか、新規投稿のデフォルトの公開範囲、誰がコメントできるかを設定できる。

**業務上の目的・背景**：Ghostはメンバーシップ機能を中核としたプラットフォームであり、コンテンツへのアクセス制御はサイト運営の重要な要素である。サブスクリプションアクセス（誰が登録できるか）、デフォルトのコンテンツ可視性（投稿のデフォルト公開範囲）、コメント設定（誰がコメントできるか）を一元管理することで、サイト運営者は収益化戦略やコミュニティ管理を効率的に行える。

**画面へのアクセス方法**：管理画面のサイドバーから「Settings」→「Membership」セクション→「Access」カードにアクセスする。URLは`/ghost/#/settings`でnavid: `members`となる。

**主要な操作・処理内容**：
1. サブスクリプションアクセスの設定（Anyone/Paid-only/Invite-only/Nobody）
2. 新規投稿のデフォルトアクセス設定（Public/Members only/Paid-members only/Specific tiers）
3. 特定ティア選択時の対象ティア選択
4. コメント権限の設定（All members/Paid-members only/Nobody）

**画面遷移**：設定画面のMembershipセクションに直接表示される。編集後は「Save」ボタンで保存、「Cancel」で変更を破棄できる。

**権限による表示制御**：Administrator以上のロールを持つユーザーのみがアクセス設定にアクセスできる。ティア選択はアクティブおよびアーカイブ済みティアがグループ分けされて表示される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 35 | 一般設定 | 主機能 | デフォルトのコンテンツアクセス権限設定 |
| 8 | メンバー登録 | 補助機能 | メンバーシップ機能の有効/無効設定 |

## 画面種別

設定画面（インライン編集型）

## URL/ルーティング

- 画面URL: `/ghost/#/settings` (navid: `members`)

## 入出力項目

| 項目名 | 種別 | データ型 | 必須 | 説明 |
|--------|------|---------|------|------|
| Subscription access | 入力 | enum | 必須 | サインアップ権限（all/paid/invite/none） |
| Default post access | 入力 | enum | 必須 | 投稿のデフォルトアクセス（public/members/paid/tiers） |
| Specific tiers | 入力 | string[] | 条件付き | 特定ティア選択時の対象ティアID |
| Comment permission | 入力 | enum | 必須 | コメント権限（all/paid/off） |

## 表示項目

| 項目名 | データ型 | 説明 |
|--------|---------|------|
| Subscription access select | SelectOption | サインアップ権限の選択肢 |
| Default post access select | SelectOption | デフォルトアクセスの選択肢 |
| Tiers multiselect | MultiSelectOption[] | ティア選択（条件付き表示） |
| Comment permission select | SelectOption | コメント権限の選択肢 |

## イベント仕様

### 1-Subscription access変更

ドロップダウンで選択を変更すると：

1. `updateSetting('members_signup_access', value)`で設定を更新
2. `handleEditingChange(true)`で編集モードを開始
3. 「Save」ボタンが有効化される

### 2-Default post access変更

ドロップダウンで選択を変更すると：

1. `updateSetting('default_content_visibility', value)`で設定を更新
2. 「tiers」を選択した場合、MultiSelectが表示される
3. `handleEditingChange(true)`で編集モードを開始

### 3-Specific tiers選択

「Specific tiers」を選択した場合、MultiSelectが表示され：

1. ティアを選択/解除すると`default_content_visibility_tiers`を更新
2. JSON配列形式で保存（例：`["tier-id-1", "tier-id-2"]`）
3. アクティブティアとアーカイブ済みティアがグループ分けされて表示

### 4-Comment permission変更

ドロップダウンで選択を変更すると：

1. `updateSetting('comments_enabled', value)`で設定を更新
2. `handleEditingChange(true)`で編集モードを開始

### 5-保存

「Save」ボタンをクリックすると：

1. `handleSave`で全設定をAPIに送信
2. 成功時は編集モードを終了

### 6-キャンセル

「Cancel」ボタンをクリックすると：

1. `handleCancel`で変更を破棄
2. 設定を元の値に戻す

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| アクセス設定保存 | settings | UPDATE | members_signup_access更新 |
| アクセス設定保存 | settings | UPDATE | default_content_visibility更新 |
| アクセス設定保存 | settings | UPDATE | default_content_visibility_tiers更新 |
| アクセス設定保存 | settings | UPDATE | comments_enabled更新 |

### テーブル別更新項目詳細

#### settings

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | key='members_signup_access' | 'all'/'paid'/'invite'/'none' | サインアップ権限 |
| UPDATE | key='default_content_visibility' | 'public'/'members'/'paid'/'tiers' | デフォルトアクセス |
| UPDATE | key='default_content_visibility_tiers' | JSON配列 | 対象ティアID |
| UPDATE | key='comments_enabled' | 'all'/'paid'/'off' | コメント権限 |

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|-----------|----------|
| ヒント | All visitors will be able to subscribe and sign in | all選択時 |
| ヒント | A paid Stripe subscription is required to sign up | paid選択時 |
| ヒント | People can sign in but won't be able to sign up | invite選択時 |
| ヒント | Disable all member features, including newsletters | none選択時 |

## 例外処理

| 状態 | 処理内容 |
|------|----------|
| ティア取得失敗 | 空のMultiSelectが表示される |
| 保存エラー | エラートーストを表示 |

## 備考

- サブスクリプションアクセスを「Nobody」に設定すると、全メンバー機能（ニュースレター含む）が無効化される
- デフォルトアクセス設定は新規投稿作成時の初期値であり、個別投稿で上書き可能
- ティア選択はアクティブティアとアーカイブ済みティアがグループ分けされる
- コメント機能を「Nobody」に設定すると、サイト全体でコメントが無効化される
- 編集ボタンは非表示（hideEditButton=true）で、直接編集モードで操作

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、アクセス設定に関連する設定値と選択肢を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | access.tsx | `apps/admin-x-settings/src/components/settings/membership/access.tsx` | 設定オプションの定義（9-71行目） |

**読解のコツ**: `MEMBERS_SIGNUP_ACCESS_OPTIONS`、`DEFAULT_CONTENT_VISIBILITY_OPTIONS`、`COMMENTS_ENABLED_OPTIONS`の3つの定数がすべての選択肢を定義している。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル・関数を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | access.tsx | `apps/admin-x-settings/src/components/settings/membership/access.tsx` | Accessコンポーネントの構造（73-195行目） |

**主要処理フロー**:
1. **74-82行目**: `useSettingGroup`でローカル設定を管理
2. **84-86行目**: 現在の設定値を取得
3. **88-99行目**: ティアオプションのグループ化
4. **101-107行目**: 選択されたティアの抽出

#### Step 3: フォームUIを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | access.tsx | `apps/admin-x-settings/src/components/settings/membership/access.tsx` | フォーム構造（109-174行目） |

**主要処理フロー**:
- **111-124行目**: Subscription access Select
- **125行目**: Separator
- **126-139行目**: Default post access Select
- **140-156行目**: 条件付きティア選択MultiSelect
- **157行目**: Separator
- **158-172行目**: Comment permission Select

#### Step 4: API連携を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | settings.ts | `apps/admin-x-framework/src/api/settings.ts` | 設定API定義 |
| 4-2 | tiers.ts | `apps/admin-x-framework/src/api/tiers.ts` | ティアAPI定義 |

**主要処理フロー**:
- `useEditSettings`で設定を保存
- `useBrowseTiers`でティア一覧を取得

### プログラム呼び出し階層図

```
Access (access.tsx)
    │
    ├─ useSettingGroup()
    │      ├─ localSettings
    │      │      ├─ members_signup_access
    │      │      ├─ default_content_visibility
    │      │      ├─ default_content_visibility_tiers
    │      │      └─ comments_enabled
    │      │
    │      ├─ updateSetting(key, value)
    │      ├─ handleSave()
    │      │      └─ PUT /settings/
    │      └─ handleCancel()
    │
    ├─ useBrowseTiers() ──► GET /tiers/
    │      └─ tiers: Tier[]
    │
    └─ Form UI
           ├─ Select (members_signup_access)
           ├─ Select (default_content_visibility)
           ├─ MultiSelect (tiers) [条件付き]
           └─ Select (comments_enabled)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

                    ┌─────────────────┐
Settings DB ────────┤  getSettingValues │
                    │                   │
                    └────────┬─────────┘
                             │
              ┌──────────────┼──────────────┐
              │              │              │
    ┌─────────▼────┐  ┌──────▼─────┐  ┌────▼────────┐
    │Subscription  │  │ Content    │  │  Comments   │
    │   Access     │  │ Visibility │  │  Enabled    │
    └──────┬───────┘  └──────┬─────┘  └──────┬──────┘
           │                 │               │
           │         ┌───────▼───────┐       │
           │         │  tiers (条件)  │       │
           │         └───────┬───────┘       │
           │                 │               │
           └─────────────────┼───────────────┘
                             │
                    ┌────────▼────────┐
ユーザー選択 ───────┤   updateSetting   │
                    └────────┬────────┘
                             │
                    ┌────────▼────────┐
handleSave() ───────┤  PUT /settings/  │───────► Settings DB
                    └─────────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| access.tsx | `apps/admin-x-settings/src/components/settings/membership/access.tsx` | ソース | メイン設定コンポーネント |
| settings.ts | `apps/admin-x-framework/src/api/settings.ts` | ソース | 設定API定義 |
| tiers.ts | `apps/admin-x-framework/src/api/tiers.ts` | ソース | ティアAPI定義 |
| use-setting-group.ts | `apps/admin-x-settings/src/hooks/use-setting-group.ts` | ソース | 設定グループ管理フック |
| top-level-group.tsx | `apps/admin-x-settings/src/components/top-level-group.tsx` | ソース | 設定グループUIコンポーネント |
