# 画面設計書 48-ニュースレター有効化設定

## 概要

本ドキュメントは、Ghost管理画面の「ニュースレター有効化設定」画面の設計仕様を定義する。この画面はニュースレター機能の有効/無効を切り替える機能を提供する。

### 本画面の処理概要

この画面では、投稿をメールで配信するニュースレター機能の有効化/無効化を管理する。トグルスイッチでシンプルに切り替えができる。

**業務上の目的・背景**：Ghostはブログプラットフォームとニュースレター配信を統合している。サイト運営者の中にはメール配信を使用しない場合もあり、そのような場合にニュースレター機能を完全に無効化できる。逆に、有効化することで投稿をメンバーにメール配信できるようになる。

**画面へのアクセス方法**：管理画面のサイドバーから「Settings」→「Email」セクション→「Newsletter sending」カードにアクセスする。URLは`/ghost/#/settings`でnavid: `enable-newsletters`となる。

**主要な操作・処理内容**：
1. ニュースレター機能の有効/無効切り替え（トグルスイッチ）
2. 現在の状態の確認（Enabled/Disabled表示）
3. サブスクリプションアクセスが「Nobody」の場合の警告表示

**画面遷移**：設定画面のEmailセクションに直接表示される。トグル変更は即時保存される。

**権限による表示制御**：Administrator以上のロールを持つユーザーのみがニュースレター有効化設定にアクセスできる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 20 | ニュースレター管理 | 主機能 | ニュースレター機能の有効/無効切り替え |

## 画面種別

設定画面（インライン設定型）

## URL/ルーティング

- 画面URL: `/ghost/#/settings` (navid: `enable-newsletters`)

## 入出力項目

| 項目名 | 種別 | データ型 | 必須 | 説明 |
|--------|------|---------|------|------|
| Newsletter sending toggle | 入力 | boolean | 必須 | ニュースレター機能の有効/無効 |

## 表示項目

| 項目名 | データ型 | 説明 |
|--------|---------|------|
| Status icon | Icon | Enabled/Disabledのアイコン（チェック/ブロック） |
| Status text | string | 現在の状態テキスト |
| Warning banner | Banner | サブスクリプション無効時の警告 |

## イベント仕様

### 1-トグル変更

トグルスイッチを変更すると：

1. `handleToggleChange`関数が呼び出される
2. `editor_default_email_recipients`設定を更新
   - 有効化時: `'visibility'`に設定
   - 無効化時: `'disabled'`に設定、`editor_default_email_recipients_filter`を`null`に
3. `editSettings`でAPIに即時保存

### 2-警告バナーリンク

「Subscription access」リンクをクリックすると：

1. `updateRoute('members')`でメンバーシップ設定に遷移

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| ニュースレター有効化 | settings | UPDATE | editor_default_email_recipients更新 |
| ニュースレター無効化 | settings | UPDATE | 2つの設定を更新 |

### テーブル別更新項目詳細

#### settings

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | key='editor_default_email_recipients' | 'visibility'/'disabled' | 有効/無効 |
| UPDATE | key='editor_default_email_recipients_filter' | null | 無効化時のみ |

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|-----------|----------|
| 説明 | Newsletter features are active, posts can be sent by email | 常時表示（タイトル下） |
| 警告 | Your Subscription access is set to 'Nobody', only existing members will receive newsletters. | members_signup_access='none'の場合 |

## 例外処理

| 状態 | 処理内容 |
|------|----------|
| 保存エラー | handleErrorでエラー処理 |

## 備考

- ニュースレター機能の有効/無効は`editor_default_email_recipients`設定で管理される
- `'disabled'`以外の値は全て有効として扱われる
- サブスクリプションアクセスが「Nobody」でもニュースレターは有効化可能だが、既存メンバーのみに配信される
- トグル変更は即時保存（Saveボタン不要）
- customButtonsとしてトグルを表示

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、ニュースレター有効化に関連する設定値を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | enable-newsletters.tsx | `apps/admin-x-settings/src/components/settings/email/enable-newsletters.tsx` | 設定値の取得（15行目） |

**読解のコツ**: `editor_default_email_recipients`が`'disabled'`以外なら有効として扱われる。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル・関数を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | enable-newsletters.tsx | `apps/admin-x-settings/src/components/settings/email/enable-newsletters.tsx` | EnableNewslettersコンポーネントの構造（9-81行目） |

**主要処理フロー**:
1. **10-13行目**: グローバルデータとAPIフックの取得
2. **15行目**: 現在の設定値の取得
3. **17行目**: 無効状態の判定（members_signup_access='none'）
4. **19-33行目**: `handleToggleChange`でトグル処理

#### Step 3: UIコンポーネントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | enable-newsletters.tsx | `apps/admin-x-settings/src/components/settings/email/enable-newsletters.tsx` | UI構成（35-78行目） |

**主要処理フロー**:
- **35-43行目**: `enableToggle` - トグルスイッチコンポーネント
- **45-78行目**: `TopLevelGroup`のレンダリング
- **53-77行目**: 状態表示（Enabled/Disabled）と警告バナー

### プログラム呼び出し階層図

```
EnableNewsletters (enable-newsletters.tsx)
    │
    ├─ useGlobalData()
    │      └─ settings
    │             ├─ editor_default_email_recipients
    │             └─ members_signup_access
    │
    ├─ useEditSettings()
    │      └─ mutateAsync(updates)
    │             └─ PUT /settings/
    │
    ├─ useRouting()
    │      └─ updateRoute('members')
    │
    └─ UI
           ├─ Toggle (customButtons)
           │      └─ onChange: handleToggleChange()
           │
           └─ SettingGroupContent
                  ├─ Icon (check/mail-block)
                  ├─ Status text (Enabled/Disabled)
                  └─ Banner (警告メッセージ)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

                    ┌─────────────────┐
Settings DB ────────┤  useGlobalData   │
                    │  settings        │
                    └────────┬─────────┘
                             │
                    ┌────────▼────────┐
                    │ getSettingValues │
                    │                  │
                    └────────┬─────────┘
                             │
              ┌──────────────┼──────────────┐
              │              │              │
    ┌─────────▼────┐  ┌──────▼─────┐       │
    │ Toggle       │  │ Status     │       │
    │ checked=     │  │ Display    │       │
    │ (!=disabled) │  │            │       │
    └──────┬───────┘  └────────────┘       │
           │                               │
Toggle変更 ─┘                              │
           │                               │
    ┌──────▼───────┐                       │
    │handleToggle  │                       │
    │Change()      │                       │
    └──────┬───────┘                       │
           │                               │
    ┌──────▼───────┐                       │
    │useEditSettings│                      │
    │mutateAsync() │                       │
    └──────┬───────┘                       │
           │                               │
    ┌──────▼───────┐                       │
    │PUT /settings/│───────────────────────┘
    └──────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| enable-newsletters.tsx | `apps/admin-x-settings/src/components/settings/email/enable-newsletters.tsx` | ソース | メイン設定コンポーネント |
| settings.ts | `apps/admin-x-framework/src/api/settings.ts` | ソース | 設定API定義 |
| global-data-provider.tsx | `apps/admin-x-settings/src/components/providers/global-data-provider.tsx` | ソース | グローバルデータプロバイダー |
